/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.types.stream;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.ArrayFW;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.Flyweight;

public final class FrameFW
extends Flyweight {
    public static final int FIELD_OFFSET_ROUTE_ID = 0;
    private static final int FIELD_SIZE_ROUTE_ID = 8;
    public static final int FIELD_OFFSET_STREAM_ID = 8;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_SEQUENCE = 16;
    private static final int FIELD_SIZE_SEQUENCE = 8;
    public static final int FIELD_OFFSET_ACKNOWLEDGE = 24;
    private static final int FIELD_SIZE_ACKNOWLEDGE = 8;
    public static final int FIELD_OFFSET_MAXIMUM = 32;
    private static final int FIELD_SIZE_MAXIMUM = 4;
    public static final int FIELD_OFFSET_TIMESTAMP = 36;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE_ID = 44;
    private static final int FIELD_SIZE_TRACE_ID = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 52;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;

    public long routeId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long streamId() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long sequence() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public long acknowledge() {
        return this.buffer().getLong(this.offset() + 24);
    }

    public int maximum() {
        return this.buffer().getInt(this.offset() + 32);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 36);
    }

    public long traceId() {
        return this.buffer().getLong(this.offset() + 44);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 52);
    }

    @Override
    public FrameFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        FrameFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public FrameFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 52 + 8;
    }

    public String toString() {
        return String.format("FRAME [routeId=%d, streamId=%d, sequence=%d, acknowledge=%d, maximum=%d, timestamp=%d, traceId=%d, authorization=%d]", this.routeId(), this.streamId(), this.sequence(), this.acknowledge(), this.maximum(), this.timestamp(), this.traceId(), this.authorization());
    }

    public static final class Builder
    extends Flyweight.Builder<FrameFW> {
        private static final int INDEX_ROUTE_ID = 0;
        private static final int INDEX_STREAM_ID = 1;
        private static final int INDEX_SEQUENCE = 2;
        private static final int INDEX_ACKNOWLEDGE = 3;
        private static final int INDEX_MAXIMUM = 4;
        private static final int INDEX_TIMESTAMP = 5;
        public static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE_ID = 6;
        public static final long DEFAULT_TRACE_ID = 0L;
        private static final int INDEX_AUTHORIZATION = 7;
        public static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int FIELD_COUNT = 8;
        private int lastFieldSet = -1;

        public Builder() {
            super(new FrameFW());
        }

        public Builder routeId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder streamId(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder sequence(long value) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder acknowledge(long value) {
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder maximum(int value) {
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + 4;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 4;
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 5;
            this.limit(newLimit);
            return this;
        }

        public Builder traceId(long value) {
            if (this.lastFieldSet < 5) {
                this.timestamp(0L);
            }
            assert (this.lastFieldSet == 5);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 6;
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            if (this.lastFieldSet < 6) {
                this.traceId(0L);
            }
            assert (this.lastFieldSet == 6);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 7;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public FrameFW build() {
            if (this.lastFieldSet < 7) {
                this.authorization(0L);
            }
            assert (this.lastFieldSet == 7);
            this.lastFieldSet = -1;
            return (FrameFW)super.build();
        }
    }
}

