/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.layouts;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.reaktivity.reaktor.internal.layouts.Layout;

public final class ControlLayout
extends Layout {
    private static final int CONTROL_VERSION = 1;
    private static final int FIELD_OFFSET_VERSION = 0;
    private static final int FIELD_SIZE_VERSION = 4;
    private static final int FIELD_OFFSET_COMMAND_BUFFER_LENGTH = 4;
    private static final int FIELD_SIZE_COMMAND_BUFFER_LENGTH = 4;
    private static final int FIELD_OFFSET_RESPONSE_BUFFER_LENGTH = 8;
    private static final int FIELD_SIZE_RESPONSE_BUFFER_LENGTH = 4;
    private static final int END_OF_META_DATA_OFFSET = BitUtil.align((int)12, (int)64);
    private final AtomicBuffer commandBuffer = new UnsafeBuffer(new byte[0]);
    private final AtomicBuffer responseBuffer = new UnsafeBuffer(new byte[0]);

    public AtomicBuffer commandBuffer() {
        return this.commandBuffer;
    }

    public AtomicBuffer responseBuffer() {
        return this.responseBuffer;
    }

    @Override
    public void close() {
        IoUtil.unmap((ByteBuffer)this.commandBuffer.byteBuffer());
        IoUtil.unmap((ByteBuffer)this.responseBuffer.byteBuffer());
    }

    public static final class Builder
    extends Layout.Builder<ControlLayout> {
        private final ControlLayout layout = new ControlLayout();
        private Path controlPath;
        private int commandBufferCapacity;
        private int responseBufferCapacity;
        private boolean readonly;

        public Builder controlPath(Path controlPath) {
            this.controlPath = controlPath;
            return this;
        }

        public Path controlPath() {
            return this.controlPath;
        }

        public Builder commandBufferCapacity(int commandBufferCapacity) {
            this.commandBufferCapacity = commandBufferCapacity;
            return this;
        }

        public Builder responseBufferCapacity(int responseBufferCapacity) {
            this.responseBufferCapacity = responseBufferCapacity;
            return this;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @Override
        public ControlLayout build() {
            int responseBufferLength;
            int commandBufferLength;
            File controlFile = this.controlPath.toFile();
            if (!this.readonly) {
                commandBufferLength = this.commandBufferCapacity + RingBufferDescriptor.TRAILER_LENGTH;
                responseBufferLength = this.responseBufferCapacity + BroadcastBufferDescriptor.TRAILER_LENGTH;
                CloseHelper.close((AutoCloseable)IoUtil.createEmptyFile((File)controlFile, (long)(END_OF_META_DATA_OFFSET + commandBufferLength + responseBufferLength)));
                MappedByteBuffer metadata = IoUtil.mapExistingFile((File)controlFile, (String)"metadata", (long)0L, (long)END_OF_META_DATA_OFFSET);
                metadata.putInt(0, 1);
                metadata.putInt(4, this.commandBufferCapacity);
                metadata.putInt(8, this.responseBufferCapacity);
                IoUtil.unmap((MappedByteBuffer)metadata);
            } else {
                MappedByteBuffer metadata = IoUtil.mapExistingFile((File)controlFile, (String)"metadata", (long)0L, (long)END_OF_META_DATA_OFFSET);
                assert (1 == metadata.getInt(0));
                this.commandBufferCapacity = metadata.getInt(4);
                this.responseBufferCapacity = metadata.getInt(8);
                IoUtil.unmap((MappedByteBuffer)metadata);
            }
            commandBufferLength = this.commandBufferCapacity + RingBufferDescriptor.TRAILER_LENGTH;
            responseBufferLength = this.responseBufferCapacity + BroadcastBufferDescriptor.TRAILER_LENGTH;
            int commandBufferOffset = END_OF_META_DATA_OFFSET;
            this.layout.commandBuffer.wrap((ByteBuffer)IoUtil.mapExistingFile((File)controlFile, (String)"commands", (long)commandBufferOffset, (long)commandBufferLength));
            int responseBufferOffset = commandBufferOffset + commandBufferLength;
            this.layout.responseBuffer.wrap((ByteBuffer)IoUtil.mapExistingFile((File)controlFile, (String)"responses", (long)responseBufferOffset, (long)responseBufferLength));
            return this.layout;
        }
    }
}

