/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.layouts;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.reaktivity.nukleus.internal.ManyToOneRingBuffer;
import org.reaktivity.reaktor.internal.layouts.Layout;

public final class StreamsLayout
extends Layout {
    private final RingBuffer streamsBuffer;

    private StreamsLayout(RingBuffer streamsBuffer) {
        this.streamsBuffer = streamsBuffer;
    }

    public RingBuffer streamsBuffer() {
        return this.streamsBuffer;
    }

    @Override
    public void close() {
        IoUtil.unmap((ByteBuffer)this.streamsBuffer.buffer().byteBuffer());
    }

    public String toString() {
        long head = this.streamsBuffer.consumerPosition();
        long tail = this.streamsBuffer.producerPosition();
        int capacity = this.streamsBuffer.capacity();
        int mask = capacity - 1;
        int headIndex = (int)(head & (long)mask);
        int tailIndex = (int)(tail & (long)mask);
        return String.format("streams=[consumeAt=0x%08x (0x%016x), produceAt=0x%08x (0x%016x)]", headIndex, head, tailIndex, tail);
    }

    public static final class Builder
    extends Layout.Builder<StreamsLayout> {
        private long streamsCapacity;
        private Path path;
        private boolean readonly;

        public Builder streamsCapacity(long streamsCapacity) {
            this.streamsCapacity = streamsCapacity;
            return this;
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @Override
        public StreamsLayout build() {
            File layoutFile = this.path.toFile();
            if (!this.readonly) {
                CloseHelper.close((AutoCloseable)IoUtil.createEmptyFile((File)layoutFile, (long)(this.streamsCapacity + (long)RingBufferDescriptor.TRAILER_LENGTH)));
            }
            MappedByteBuffer mappedStreams = IoUtil.mapExistingFile((File)layoutFile, (String)"streams");
            UnsafeBuffer atomicStreams = new UnsafeBuffer((ByteBuffer)mappedStreams);
            return new StreamsLayout(new ManyToOneRingBuffer((AtomicBuffer)atomicStreams));
        }
    }
}

