/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.router;

import java.util.function.LongFunction;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.function.MessagePredicate;
import org.reaktivity.reaktor.ReaktorConfiguration;
import org.reaktivity.reaktor.internal.layouts.StreamsLayout;
import org.reaktivity.reaktor.internal.router.StreamId;
import org.reaktivity.reaktor.internal.router.WriteCounters;
import org.reaktivity.reaktor.internal.types.stream.FrameFW;
import org.reaktivity.reaktor.internal.types.stream.ResetFW;

public final class Target
implements AutoCloseable {
    private final FrameFW frameRO = new FrameFW();
    private final ResetFW.Builder resetRW = new ResetFW.Builder();
    private final int localIndex;
    private final String targetName;
    private final AutoCloseable streamsLayout;
    private final MutableDirectBuffer writeBuffer;
    private final boolean timestamps;
    private final Int2ObjectHashMap<MessageConsumer>[] streams;
    private final Int2ObjectHashMap<MessageConsumer>[] throttles;
    private final Long2ObjectHashMap<WriteCounters> countersByRouteId;
    private final MessageConsumer writeHandler;
    private final LongFunction<WriteCounters> newWriteCounters;
    private MessagePredicate streamsBuffer;

    public Target(ReaktorConfiguration config, int index, MutableDirectBuffer writeBuffer, Int2ObjectHashMap<MessageConsumer>[] streams, Int2ObjectHashMap<MessageConsumer>[] throttles, LongFunction<WriteCounters> newWriteCounters) {
        String targetName;
        this.timestamps = config.timestamps();
        this.localIndex = index;
        this.targetName = targetName = String.format("data%d", index);
        StreamsLayout streamsLayout = new StreamsLayout.Builder().path(config.directory().resolve(targetName)).streamsCapacity(config.streamsBufferCapacity()).readonly(true).build();
        this.streamsLayout = streamsLayout;
        this.streamsBuffer = (arg_0, arg_1, arg_2, arg_3) -> ((RingBuffer)streamsLayout.streamsBuffer()).write(arg_0, arg_1, arg_2, arg_3);
        this.writeBuffer = writeBuffer;
        this.newWriteCounters = newWriteCounters;
        this.streams = streams;
        this.throttles = throttles;
        this.writeHandler = this::handleWrite;
        this.countersByRouteId = new Long2ObjectHashMap();
    }

    public void detach() {
        this.streamsBuffer = (t, b, i, l) -> true;
    }

    @Override
    public void close() throws Exception {
        for (int remoteIndex = 0; remoteIndex < this.throttles.length; ++remoteIndex) {
            int remoteIndex0 = remoteIndex;
            this.throttles[remoteIndex].forEach((id, handler) -> this.doSyntheticReset(StreamId.throttleId(this.localIndex, remoteIndex0, id), (MessageConsumer)handler));
        }
        this.streamsLayout.close();
    }

    public String toString() {
        return String.format("%s (write)", this.targetName);
    }

    public MessageConsumer writeHandler() {
        return this.writeHandler;
    }

    private void handleWrite(int msgTypeId, DirectBuffer buffer, int index, int length) {
        boolean handled = false;
        if (this.timestamps) {
            ((MutableDirectBuffer)buffer).putLong(index + 36, System.nanoTime());
        }
        FrameFW frame = this.frameRO.wrap(buffer, index, index + length);
        long streamId = frame.streamId();
        long routeId = frame.routeId();
        handled = streamId == 0L ? this.handleWriteSystem(streamId, routeId, msgTypeId, buffer, index, length) : (StreamId.isInitial(streamId) ? this.handleWriteInitial(streamId, routeId, msgTypeId, buffer, index, length) : this.handleWriteReply(streamId, routeId, msgTypeId, buffer, index, length));
        if (!handled) {
            throw new IllegalStateException("Unable to write to streams buffer");
        }
    }

    private boolean handleWriteSystem(long streamId, long routeId, int msgTypeId, DirectBuffer buffer, int index, int length) {
        boolean handled = false;
        switch (msgTypeId) {
            case 5: {
                handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                break;
            }
            case 0x40000002: {
                handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
            }
        }
        return handled;
    }

    private boolean handleWriteInitial(long streamId, long routeId, int msgTypeId, DirectBuffer buffer, int index, int length) {
        boolean handled;
        if ((msgTypeId & 0x40000000) == 0) {
            WriteCounters counters = (WriteCounters)this.countersByRouteId.computeIfAbsent(routeId, this.newWriteCounters);
            switch (msgTypeId) {
                case 1: {
                    counters.opens.increment();
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                case 2: {
                    counters.frames.increment();
                    counters.bytes.getAndAdd((long)buffer.getInt(index + 73));
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                case 3: {
                    counters.closes.increment();
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    this.throttles[StreamId.throttleIndex(streamId)].remove(StreamId.instanceId(streamId));
                    break;
                }
                case 4: {
                    counters.aborts.increment();
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    this.throttles[StreamId.throttleIndex(streamId)].remove(StreamId.instanceId(streamId));
                    break;
                }
                case 5: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                default: {
                    handled = true;
                    break;
                }
            }
        } else {
            switch (msgTypeId) {
                case 0x40000002: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                case 0x40000001: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    this.streams[StreamId.streamIndex(streamId)].remove(StreamId.instanceId(streamId));
                    break;
                }
                case 0x40000003: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                case 0x40000004: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                default: {
                    handled = true;
                }
            }
        }
        return handled;
    }

    private boolean handleWriteReply(long streamId, long routeId, int msgTypeId, DirectBuffer buffer, int index, int length) {
        boolean handled;
        if ((msgTypeId & 0x40000000) == 0) {
            switch (msgTypeId) {
                case 1: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                case 2: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                case 3: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    this.throttles[StreamId.throttleIndex(streamId)].remove(StreamId.instanceId(streamId));
                    break;
                }
                case 4: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    this.throttles[StreamId.throttleIndex(streamId)].remove(StreamId.instanceId(streamId));
                    break;
                }
                case 5: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                default: {
                    handled = true;
                    break;
                }
            }
        } else {
            WriteCounters counters = (WriteCounters)this.countersByRouteId.computeIfAbsent(routeId, this.newWriteCounters);
            switch (msgTypeId) {
                case 0x40000002: {
                    counters.windows.increment();
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                case 0x40000001: {
                    counters.resets.increment();
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    this.streams[StreamId.streamIndex(streamId)].remove(StreamId.instanceId(streamId));
                    break;
                }
                case 0x40000003: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                case 0x40000004: {
                    handled = this.streamsBuffer.test(msgTypeId, buffer, index, length);
                    break;
                }
                default: {
                    handled = true;
                }
            }
        }
        return handled;
    }

    private void doSyntheticReset(long streamId, MessageConsumer sender) {
        long syntheticRouteId = 0L;
        ResetFW reset = this.resetRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(0L).streamId(streamId).sequence(-1L).acknowledge(-1L).maximum(0).build();
        sender.accept(reset.typeId(), reset.buffer(), reset.offset(), reset.sizeof());
    }
}

