/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.types.control;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.reaktor.internal.types.Flyweight;
import org.reaktivity.reaktor.internal.types.control.Capability;

public final class CapabilityFW
extends Flyweight {
    private static final int FIELD_OFFSET_VALUE = 0;
    private static final int FIELD_SIZE_VALUE = 1;

    @Override
    public int limit() {
        return this.offset() + 1;
    }

    public Capability get() {
        return Capability.valueOf(this.buffer().getByte(this.offset() + 0));
    }

    @Override
    public CapabilityFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null || this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public CapabilityFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        CapabilityFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : this.get().toString();
    }

    public static final class Builder
    extends Flyweight.Builder<CapabilityFW> {
        private boolean valueSet;

        public Builder() {
            super(new CapabilityFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }

        public Builder set(CapabilityFW value) {
            int newLimit = this.offset() + value.sizeof();
            CapabilityFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.offset(), value.buffer(), value.offset(), value.sizeof());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(Capability value) {
            MutableDirectBuffer buffer = this.buffer();
            int offset = this.offset();
            int newLimit = offset + 1;
            CapabilityFW.checkLimit(newLimit, this.maxLimit());
            buffer.putByte(offset, (byte)value.ordinal());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public CapabilityFW build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Capability not set");
            }
            return (CapabilityFW)super.build();
        }
    }
}

