/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.reaktor.internal.types.Flyweight;
import org.reaktivity.reaktor.internal.types.control.RouteFW;
import org.reaktivity.reaktor.internal.types.control.UnrouteFW;

public final class ReaktorSignalExFW
extends Flyweight {
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 4;
    public static final int KIND_ROUTE = 1;
    public static final int FIELD_OFFSET_ROUTE = 5;
    public static final int KIND_UNROUTE = 2;
    public static final int FIELD_OFFSET_UNROUTE = 5;
    private RouteFW routeRO;
    private UnrouteFW unrouteRO;

    public int kind() {
        return this.buffer().getByte(this.offset() + 4) & 0xFF;
    }

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public RouteFW route() {
        if (this.routeRO == null) {
            this.routeRO = new RouteFW();
        }
        return this.routeRO;
    }

    public UnrouteFW unroute() {
        if (this.unrouteRO == null) {
            this.unrouteRO = new UnrouteFW();
        }
        return this.unrouteRO;
    }

    @Override
    public ReaktorSignalExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 1: {
                if (this.route().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 2: {
                if (this.unroute().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public ReaktorSignalExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 1: {
                this.route().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 2: {
                this.unroute().wrap(buffer, offset + 5, maxLimit);
                break;
            }
        }
        ReaktorSignalExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 1: {
                return this.route().limit();
            }
            case 2: {
                return this.unroute().limit();
            }
        }
        return this.offset() + 0 + 4;
    }

    public String toString() {
        switch (this.kind()) {
            case 1: {
                return String.format("REAKTOR_SIGNAL_EX [typeId=%d, route=%s]", this.typeId(), this.route());
            }
            case 2: {
                return String.format("REAKTOR_SIGNAL_EX [typeId=%d, unroute=%s]", this.typeId(), this.unroute());
            }
        }
        return String.format("REAKTOR_SIGNAL_EX [typeId=%d]", this.typeId());
    }

    public static final class Builder
    extends Flyweight.Builder<ReaktorSignalExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private RouteFW.Builder routeRW;
        private UnrouteFW.Builder unrouteRW;
        private int lastFieldSet = -1;

        public Builder() {
            super(new ReaktorSignalExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            ReaktorSignalExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder kind(int value) {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            this.buffer().putByte(this.offset() + 4, (byte)(value & 0xFF));
            return this;
        }

        private RouteFW.Builder route() {
            int newLimit = this.maxLimit();
            ReaktorSignalExFW.checkLimit(newLimit, this.maxLimit());
            if (this.routeRW == null) {
                this.routeRW = new RouteFW.Builder();
            }
            return this.routeRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder route(Consumer<RouteFW.Builder> mutator) {
            this.kind(1);
            RouteFW.Builder route = this.route();
            mutator.accept(route);
            this.limit(route.build().limit());
            return this;
        }

        public Builder route(RouteFW field) {
            this.kind(1);
            int newLimit = this.limit() + field.sizeof();
            ReaktorSignalExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private UnrouteFW.Builder unroute() {
            int newLimit = this.maxLimit();
            ReaktorSignalExFW.checkLimit(newLimit, this.maxLimit());
            if (this.unrouteRW == null) {
                this.unrouteRW = new UnrouteFW.Builder();
            }
            return this.unrouteRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder unroute(Consumer<UnrouteFW.Builder> mutator) {
            this.kind(2);
            UnrouteFW.Builder unroute = this.unroute();
            mutator.accept(unroute);
            this.limit(unroute.build().limit());
            return this;
        }

        public Builder unroute(UnrouteFW field) {
            this.kind(2);
            int newLimit = this.limit() + field.sizeof();
            ReaktorSignalExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        @Override
        public ReaktorSignalExFW build() {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            return (ReaktorSignalExFW)super.build();
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            return this;
        }
    }
}

