/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.layouts;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.internal.layouts.Layout;

public final class BudgetsLayout
extends Layout {
    public static final int OFFSET_BUDGET_ID = 0;
    public static final int SIZEOF_BUDGET_ID = 8;
    public static final int LIMIT_BUDGET_ID = 8;
    public static final int OFFSET_BUDGET_REMAINING = 8;
    public static final int SIZEOF_BUDGET_REMAINING = 8;
    public static final int LIMIT_BUDGET_REMAINING = 16;
    public static final int OFFSET_BUDGET_WATCHERS = 16;
    public static final int SIZEOF_BUDGET_WATCHERS = 8;
    public static final int LIMIT_BUDGET_WATCHERS = 24;
    public static final int SIZEOF_BUDGET_ENTRY = BitUtil.findNextPositivePowerOfTwo((int)BitUtil.align((int)24, (int)64));
    public static final int SIZEOF_BUDGET_ENTRY_SHIFT = Integer.numberOfTrailingZeros(SIZEOF_BUDGET_ENTRY);
    private final AtomicBuffer buffer;

    private BudgetsLayout(AtomicBuffer buffer) {
        if (!BitUtil.isPowerOfTwo((int)buffer.capacity())) {
            throw new IllegalArgumentException("budgets buffer capacity is not a power of 2");
        }
        this.buffer = buffer;
    }

    @Override
    public void close() {
        IoUtil.unmap((ByteBuffer)this.buffer().byteBuffer());
    }

    public AtomicBuffer buffer() {
        return this.buffer;
    }

    public int entries() {
        return this.buffer.capacity() / SIZEOF_BUDGET_ENTRY;
    }

    public static int budgetIdOffset(int index) {
        return BudgetsLayout.budgetEntryOffset(index) + 0;
    }

    public static int budgetRemainingOffset(int index) {
        return BudgetsLayout.budgetEntryOffset(index) + 8;
    }

    public static int budgetWatchersOffset(int index) {
        return BudgetsLayout.budgetEntryOffset(index) + 16;
    }

    private static int budgetEntryOffset(int index) {
        return (index & Integer.MAX_VALUE) << SIZEOF_BUDGET_ENTRY_SHIFT;
    }

    public static final class Builder
    extends Layout.Builder<BudgetsLayout> {
        private Path path;
        private int capacity;
        private boolean owner;

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder owner(boolean owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public BudgetsLayout build() {
            File budgets = this.path.toFile();
            if (this.owner) {
                CloseHelper.close((AutoCloseable)IoUtil.createEmptyFile((File)budgets, (long)this.capacity));
            } else {
                this.capacity = (int)budgets.length();
            }
            MappedByteBuffer mapped = IoUtil.mapExistingFile((File)budgets, (String)"budgets");
            UnsafeBuffer buffer = new UnsafeBuffer((ByteBuffer)mapped);
            return new BudgetsLayout((AtomicBuffer)buffer);
        }
    }
}

