/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor;

import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.agrona.ErrorHandler;
import org.reaktivity.reaktor.Reaktor;
import org.reaktivity.reaktor.ReaktorAffinity;
import org.reaktivity.reaktor.ReaktorConfiguration;
import org.reaktivity.reaktor.nukleus.Configuration;
import org.reaktivity.reaktor.nukleus.Nukleus;
import org.reaktivity.reaktor.nukleus.NukleusFactory;

public class ReaktorBuilder {
    private Configuration config;
    private ErrorHandler errorHandler;
    private int threads = 1;
    private URL configURL;
    private Collection<ReaktorAffinity> affinities = new LinkedHashSet<ReaktorAffinity>();

    ReaktorBuilder() {
    }

    public ReaktorBuilder config(Configuration config) {
        this.config = Objects.requireNonNull(config);
        return this;
    }

    public ReaktorBuilder configURL(URL configURL) {
        this.configURL = configURL;
        return this;
    }

    public ReaktorBuilder threads(int threads) {
        this.threads = threads;
        return this;
    }

    public ReaktorBuilder affinity(String namespace, String binding, long mask) {
        this.affinities.add(new ReaktorAffinity(namespace, binding, mask));
        return this;
    }

    public ReaktorBuilder errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = Objects.requireNonNull(errorHandler);
        return this;
    }

    public Reaktor build() {
        ReaktorConfiguration config = new ReaktorConfiguration(this.config != null ? this.config : new Configuration());
        LinkedHashSet<Nukleus> nuklei = new LinkedHashSet<Nukleus>();
        NukleusFactory factory = NukleusFactory.instantiate();
        for (String name : factory.names()) {
            Nukleus nukleus = factory.create(name, config);
            nuklei.add(nukleus);
        }
        ErrorHandler errorHandler = Objects.requireNonNull(this.errorHandler, "errorHandler");
        return new Reaktor(config, nuklei, errorHandler, this.configURL, this.threads, this.affinities);
    }
}

