/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.agrona.CloseHelper;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public final class Counters
implements AutoCloseable {
    private final CountersManager manager;
    private final ConcurrentMap<String, AtomicCounter> counters;
    private final ConcurrentMap<String, LongSupplier> readonlyCounters;
    private final Function<? super String, ? extends AtomicCounter> newCounter;

    public Counters(CountersManager manager) {
        this.manager = manager;
        this.counters = new ConcurrentHashMap<String, AtomicCounter>();
        this.readonlyCounters = new ConcurrentHashMap<String, LongSupplier>();
        this.newCounter = this::newCounter;
    }

    @Override
    public void close() throws Exception {
        this.counters.values().forEach(CloseHelper::quietClose);
    }

    public AtomicCounter counter(String name) {
        return this.counters.computeIfAbsent(name, this.newCounter);
    }

    public LongSupplier readonlyCounter(String name) {
        LongSupplier readonlyCounter = (LongSupplier)this.readonlyCounters.get(name);
        if (readonlyCounter == null) {
            this.manager.forEach(this::populateReadonlyCounter);
            readonlyCounter = (LongSupplier)this.readonlyCounters.get(name);
        }
        if (readonlyCounter == null) {
            readonlyCounter = () -> 0L;
        }
        return readonlyCounter;
    }

    private AtomicCounter newCounter(String name) {
        return this.manager.newCounter(name);
    }

    private void populateReadonlyCounter(int counterId, String name) {
        this.readonlyCounters.computeIfAbsent(name, k -> () -> this.manager.getCounterValue(counterId));
    }
}

