/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.budget;

import java.util.function.LongConsumer;
import org.agrona.BitUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.AtomicBuffer;
import org.reaktivity.reaktor.ReaktorConfiguration;
import org.reaktivity.reaktor.internal.layouts.BudgetsLayout;
import org.reaktivity.reaktor.internal.stream.BudgetId;
import org.reaktivity.reaktor.nukleus.budget.BudgetDebitor;

public final class DefaultBudgetDebitor
implements BudgetDebitor,
AutoCloseable {
    private final BudgetsLayout layout;
    private final AtomicBuffer storage;
    private final int entries;
    private final long budgetMask;
    private final long watcherMask;
    private final Long2LongHashMap budgetIdByIndex;
    private final Long2ObjectHashMap<Long2ObjectHashMap<LongConsumer>> flushersByBudgetId;
    private final Long2ObjectHashMap<LongHashSet> watcherIdsByBudgetId;

    public DefaultBudgetDebitor(int watcherIndex, int ownerIndex, BudgetsLayout layout) {
        this.layout = layout;
        this.storage = layout.buffer();
        int entries = layout.entries();
        assert (BitUtil.isPowerOfTwo((int)entries));
        this.entries = entries;
        this.budgetMask = BudgetId.budgetMask(ownerIndex);
        this.watcherMask = 1L << watcherIndex;
        this.budgetIdByIndex = new Long2LongHashMap(-1L);
        this.flushersByBudgetId = new Long2ObjectHashMap();
        this.watcherIdsByBudgetId = new Long2ObjectHashMap();
    }

    @Override
    public void close() throws Exception {
        this.layout.close();
    }

    @Override
    public long acquire(long budgetId, long watcherId, LongConsumer flusher) {
        assert ((budgetId & this.budgetMask) == this.budgetMask);
        long budgetIndex = -1L;
        int entriesMask = this.entries - 1;
        int index = Hashing.hash((long)budgetId, (int)entriesMask);
        for (int i = 0; i < this.entries; ++i) {
            if (this.storage.getLong(BudgetsLayout.budgetIdOffset(index)) == budgetId) {
                budgetIndex = this.budgetMask | (long)index;
                Long2ObjectHashMap flushersByWatcherId = (Long2ObjectHashMap)this.flushersByBudgetId.computeIfAbsent(budgetId, id -> new Long2ObjectHashMap());
                flushersByWatcherId.put(watcherId, (Object)flusher);
                break;
            }
            ++index;
            index &= entriesMask;
        }
        if (budgetIndex != -1L) {
            this.budgetIdByIndex.put(budgetIndex, budgetId);
            if (ReaktorConfiguration.DEBUG_BUDGETS) {
                System.out.format("[%d] [0x%016x] [0x%016x] debitor acquired %d\n", System.nanoTime(), watcherId, budgetId, budgetIndex);
            }
        }
        return budgetIndex;
    }

    @Override
    public int claim(long budgetIndex, long watcherId, int minimum, int maximum) {
        return this.claim(budgetIndex, watcherId, minimum, maximum, 0);
    }

    @Override
    public int claim(long budgetIndex, long watcherId, int minimum, int maximum, int deferred) {
        return this.claim(0L, budgetIndex, watcherId, minimum, maximum, deferred);
    }

    @Override
    public int claim(long traceId, long budgetIndex, long watcherId, int minimum, int maximum, int deferred) {
        long claimed;
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        assert (0 <= minimum);
        assert (minimum <= maximum);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        int budgetRemainingOffset = BudgetsLayout.budgetRemainingOffset(index);
        long previous = this.storage.getAndAddLong(budgetRemainingOffset, -(claimed = (long)maximum));
        if (previous - claimed < 0L) {
            if (previous >= (long)minimum) {
                this.storage.getAndAddLong(budgetRemainingOffset, claimed - previous);
                claimed = previous;
            } else {
                this.storage.getAndAddLong(budgetRemainingOffset, claimed);
                claimed = 0L;
            }
        }
        if (ReaktorConfiguration.DEBUG_BUDGETS) {
            long budgetId = this.budgetIdByIndex.get(budgetIndex);
            System.out.format("[%d] [0x%016x] [0x%016x] [0x%016x] claimed %d / %d @ %d => %d\n", System.nanoTime(), traceId, watcherId, budgetId, claimed, maximum, previous, previous - claimed);
        }
        if (claimed != (long)maximum) {
            this.watch(index, watcherId);
        } else {
            this.unwatch(index, watcherId);
        }
        return (int)claimed;
    }

    @Override
    public void release(long budgetIndex, long watcherId) {
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        this.unwatch(index, watcherId);
        long budgetId = this.budgetIdByIndex.get(budgetIndex);
        if (ReaktorConfiguration.DEBUG_BUDGETS) {
            System.out.format("[%d] [0x%016x] [0x%016x] debitor release %d\n", System.nanoTime(), watcherId, budgetId, budgetIndex);
        }
        Long2ObjectHashMap flushersByWatcherId = (Long2ObjectHashMap)this.flushersByBudgetId.get(budgetId);
        assert (flushersByWatcherId != null);
        LongConsumer flusher = (LongConsumer)flushersByWatcherId.remove(watcherId);
        assert (flusher != null);
        if (flushersByWatcherId.isEmpty()) {
            this.flushersByBudgetId.remove(budgetId);
            this.budgetIdByIndex.remove(budgetIndex);
        }
    }

    public void flush(long traceId, long budgetId) {
        assert ((budgetId & this.budgetMask) == this.budgetMask);
        LongHashSet watcherIds = (LongHashSet)this.watcherIdsByBudgetId.get(budgetId);
        Long2ObjectHashMap flushersByWatcherId = (Long2ObjectHashMap)this.flushersByBudgetId.get(budgetId);
        if (ReaktorConfiguration.DEBUG_BUDGETS) {
            System.out.format("[%d] [0x%016x] [0x%016x] flush %s %d\n", System.nanoTime(), traceId, budgetId, watcherIds, flushersByWatcherId != null ? flushersByWatcherId.size() : 0);
        }
        if (watcherIds != null && flushersByWatcherId != null) {
            LongHashSet.LongIterator longIterator = watcherIds.iterator();
            while (longIterator.hasNext()) {
                long watcherId = (Long)longIterator.next();
                LongConsumer flush = (LongConsumer)flushersByWatcherId.get(watcherId);
                if (flush == null) continue;
                flush.accept(traceId);
            }
        }
    }

    public long available(long budgetIndex) {
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        return this.storage.getLongVolatile(BudgetsLayout.budgetRemainingOffset(index));
    }

    public int acquired() {
        return this.budgetIdByIndex.size();
    }

    long watchers(long budgetIndex) {
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        return this.storage.getLongVolatile(BudgetsLayout.budgetWatchersOffset(index));
    }

    long budgetId(long budgetIndex) {
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        return this.storage.getLongVolatile(BudgetsLayout.budgetIdOffset(index));
    }

    private void watch(int index, long watcherId) {
        long budgetId = this.storage.getLongVolatile(BudgetsLayout.budgetIdOffset(index));
        LongHashSet watcherIds = (LongHashSet)this.watcherIdsByBudgetId.computeIfAbsent(budgetId, id -> new LongHashSet());
        watcherIds.add(watcherId);
        int watchersOffset = BudgetsLayout.budgetWatchersOffset(index);
        long watchers = this.storage.getLongVolatile(watchersOffset);
        while ((watchers & this.watcherMask) == 0L && !this.storage.compareAndSetLong(watchersOffset, watchers, watchers | this.watcherMask)) {
            Thread.onSpinWait();
            watchers = this.storage.getLongVolatile(watchersOffset);
        }
    }

    private void unwatch(int index, long watcherId) {
        long budgetId = this.storage.getLongVolatile(BudgetsLayout.budgetIdOffset(index));
        LongHashSet watcherIds = (LongHashSet)this.watcherIdsByBudgetId.get(budgetId);
        if (watcherIds != null) {
            watcherIds.remove(watcherId);
            if (watcherIds.isEmpty()) {
                this.watcherIdsByBudgetId.remove(budgetId);
                int watchersOffset = BudgetsLayout.budgetWatchersOffset(index);
                long watchers = this.storage.getLongVolatile(watchersOffset);
                while ((watchers & this.watcherMask) != 0L && !this.storage.compareAndSetLong(watchersOffset, watchers, watchers & (this.watcherMask ^ 0xFFFFFFFFFFFFFFFFL))) {
                    Thread.onSpinWait();
                    watchers = this.storage.getLongVolatile(watchersOffset);
                }
            }
        }
    }
}

