/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.buffer;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Hashing;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.nukleus.buffer.BufferPool;

public class DefaultBufferPool
implements BufferPool {
    private final MutableDirectBuffer slotBuffer = new UnsafeBuffer(new byte[0]);
    private final int slotCapacity;
    private final int slotCount;
    private final AtomicBuffer poolBuffer;
    private final ByteBuffer slotByteBuffer;
    private final int bitsPerSlot;
    private final int hashMask;
    private final BitSet used;
    private final MutableInteger availableSlots;
    private final int usedIndex;

    public DefaultBufferPool(int poolCapacity, int slotCapacity) {
        this(slotCapacity, poolCapacity / slotCapacity, ByteBuffer.allocate((slotCapacity + 8) * poolCapacity / slotCapacity + 4));
    }

    public DefaultBufferPool(int slotCapacity, int slotCount, ByteBuffer poolByteBuffer) {
        if (!DefaultBufferPool.isZeroOrPowerOfTwo(slotCapacity)) {
            throw new IllegalArgumentException("slotCapacity is not a power of 2");
        }
        if (!DefaultBufferPool.isZeroOrPowerOfTwo(slotCount)) {
            throw new IllegalArgumentException("slotCount is not a power of 2");
        }
        int capacity = slotCapacity * slotCount;
        int trailerLength = 8 * slotCount + 4;
        int totalCapacity = capacity + trailerLength;
        if (poolByteBuffer.capacity() != totalCapacity) {
            throw new IllegalArgumentException(String.format("poolBuffer capacity not equal to %x", totalCapacity));
        }
        this.slotCapacity = slotCapacity;
        this.slotCount = slotCount;
        this.bitsPerSlot = Integer.numberOfTrailingZeros(slotCapacity);
        this.hashMask = slotCount - 1;
        this.poolBuffer = new UnsafeBuffer(poolByteBuffer);
        this.slotByteBuffer = poolByteBuffer.duplicate();
        this.used = new BitSet(slotCount);
        this.availableSlots = new MutableInteger(slotCount);
        this.usedIndex = capacity;
    }

    @Override
    public int acquiredSlots() {
        return this.used.cardinality();
    }

    public int slotCount() {
        return this.slotCount;
    }

    @Override
    public int slotCapacity() {
        return this.slotCapacity;
    }

    @Override
    public int acquire(long streamId) {
        if (this.availableSlots.value == 0) {
            return -1;
        }
        int slot = Hashing.hash((long)streamId, (int)this.hashMask);
        while (this.used.get(slot)) {
            ++slot;
            slot &= this.hashMask;
        }
        this.used.set(slot);
        --this.availableSlots.value;
        this.poolBuffer.putLongOrdered(this.usedIndex + (slot << 3), streamId);
        return slot;
    }

    @Override
    public MutableDirectBuffer buffer(int slot) {
        assert (this.used.get(slot));
        this.slotBuffer.wrap((DirectBuffer)this.poolBuffer, slot << this.bitsPerSlot, this.slotCapacity);
        return this.slotBuffer;
    }

    @Override
    public ByteBuffer byteBuffer(int slot) {
        assert (this.used.get(slot));
        int slotOffset = slot << this.bitsPerSlot;
        this.slotByteBuffer.clear();
        this.slotByteBuffer.position(slotOffset);
        this.slotByteBuffer.limit(slotOffset + this.slotCapacity);
        return this.slotByteBuffer;
    }

    @Override
    public MutableDirectBuffer buffer(int slot, int offset) {
        assert (this.used.get(slot));
        long slotAddressOffset = this.poolBuffer.addressOffset() + (long)(slot << this.bitsPerSlot);
        this.slotBuffer.wrap(slotAddressOffset + (long)offset, this.slotCapacity);
        return this.slotBuffer;
    }

    @Override
    public void release(int slot) {
        assert (this.used.get(slot));
        this.used.clear(slot);
        ++this.availableSlots.value;
        this.poolBuffer.putLongOrdered(this.usedIndex + (slot << 3), 0L);
    }

    @Override
    public BufferPool duplicate() {
        return new DefaultBufferPool(this);
    }

    public DirectBuffer poolBuffer() {
        return this.poolBuffer;
    }

    private DefaultBufferPool(DefaultBufferPool that) {
        this.availableSlots = that.availableSlots;
        this.bitsPerSlot = that.bitsPerSlot;
        this.hashMask = that.hashMask;
        this.poolBuffer = that.poolBuffer;
        this.slotCapacity = that.slotCapacity;
        this.slotCount = that.slotCount;
        this.used = that.used;
        this.usedIndex = that.usedIndex;
        this.slotByteBuffer = that.slotByteBuffer.duplicate();
    }

    private static boolean isZeroOrPowerOfTwo(int value) {
        return value == 0 || BitUtil.isPowerOfTwo((int)value);
    }
}

