/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.config;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.adapter.JsonbAdapter;
import org.reaktivity.reaktor.internal.config.NamespaceRef;

public class NamspaceRefAdapter
implements JsonbAdapter<NamespaceRef, JsonObject> {
    private static final String NAME_NAME = "name";
    private static final String LINKS_NAME = "links";
    private static final Map<String, String> LINKS_DEFAULT = Collections.emptyMap();

    public JsonObject adaptToJson(NamespaceRef ref) {
        JsonObjectBuilder object = Json.createObjectBuilder();
        object.add(NAME_NAME, ref.name);
        if (!LINKS_DEFAULT.equals(ref.links)) {
            JsonObjectBuilder links = Json.createObjectBuilder();
            ref.links.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)links).add(arg_0, arg_1));
            object.add(LINKS_NAME, links);
        }
        return object.build();
    }

    public NamespaceRef adaptFromJson(JsonObject object) {
        String name = object.getString(NAME_NAME);
        Map<String, String> links = object.containsKey((Object)LINKS_NAME) ? object.getJsonObject(LINKS_NAME).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> NamspaceRefAdapter.asJsonString((JsonValue)e.getValue()))) : LINKS_DEFAULT;
        return new NamespaceRef(name, links);
    }

    private static String asJsonString(JsonValue value) {
        return ((JsonString)value).getString();
    }
}

