/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.context;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToIntFunction;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.adapter.JsonbAdapter;
import org.agrona.ErrorHandler;
import org.reaktivity.reaktor.config.Binding;
import org.reaktivity.reaktor.config.Route;
import org.reaktivity.reaktor.config.Vault;
import org.reaktivity.reaktor.internal.config.Configuration;
import org.reaktivity.reaktor.internal.config.ConfigurationAdapter;
import org.reaktivity.reaktor.internal.context.DispatchAgent;
import org.reaktivity.reaktor.internal.stream.NamespacedId;

public class ConfigureTask
implements Callable<Void> {
    private final ToIntFunction<String> supplyId;
    private final URL configURL;
    private final Collection<DispatchAgent> dispatchers;
    private final ErrorHandler errorHandler;

    public ConfigureTask(URL configURL, ToIntFunction<String> supplyId, Collection<DispatchAgent> dispatchers, ErrorHandler errorHandler) {
        this.supplyId = supplyId;
        this.configURL = configURL;
        this.dispatchers = dispatchers;
        this.errorHandler = errorHandler;
    }

    @Override
    public Void call() throws Exception {
        String configText;
        if (this.configURL == null) {
            configText = "{}";
        } else if ("https".equals(this.configURL.getProtocol()) || "https".equals(this.configURL.getProtocol())) {
            HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
            HttpRequest request = HttpRequest.newBuilder().GET().uri(this.configURL.toURI()).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            Iterator body = response.body();
            configText = body;
        } else {
            URLConnection connection = this.configURL.openConnection();
            try (InputStream input = connection.getInputStream();){
                configText = new String(input.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        try {
            JsonbConfig config = new JsonbConfig().withAdapters(new JsonbAdapter[]{new ConfigurationAdapter()});
            Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
            Configuration configuration = (Configuration)jsonb.fromJson(configText, Configuration.class);
            configuration.id = this.supplyId.applyAsInt(configuration.name);
            for (Binding binding : configuration.bindings) {
                binding.id = NamespacedId.id(configuration.id, this.supplyId.applyAsInt(binding.entry));
                if (binding.vault != null) {
                    binding.vault.id = NamespacedId.id(this.supplyId.applyAsInt(binding.vault.namespace), this.supplyId.applyAsInt(binding.vault.name));
                }
                for (Route route : binding.routes) {
                    route.id = NamespacedId.id(configuration.id, this.supplyId.applyAsInt(route.exit));
                }
                if (binding.exit == null) continue;
                binding.exit.id = NamespacedId.id(configuration.id, this.supplyId.applyAsInt(binding.exit.exit));
            }
            for (Vault vault : configuration.vaults) {
                vault.id = NamespacedId.id(configuration.id, this.supplyId.applyAsInt(vault.name));
            }
            CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
            for (DispatchAgent dispatcher : this.dispatchers) {
                future = CompletableFuture.allOf(future, dispatcher.attach(configuration));
            }
            future.join();
        }
        catch (Throwable ex) {
            this.errorHandler.onError(ex);
        }
        return null;
    }
}

