/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.context;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.agrona.collections.Int2ObjectHashMap;
import org.reaktivity.reaktor.config.Binding;
import org.reaktivity.reaktor.config.Namespace;
import org.reaktivity.reaktor.config.Vault;
import org.reaktivity.reaktor.internal.context.BindingContext;
import org.reaktivity.reaktor.internal.context.VaultContext;
import org.reaktivity.reaktor.nukleus.Elektron;

public class NamespaceContext {
    private final Namespace namespace;
    private final Function<String, Elektron> lookupElektron;
    private final ToIntFunction<String> supplyLabelId;
    private final int namespaceId;
    private final Int2ObjectHashMap<BindingContext> bindingsById;
    private final Int2ObjectHashMap<VaultContext> vaultsById;

    public NamespaceContext(Namespace namespace, Function<String, Elektron> lookupElektron, ToIntFunction<String> supplyLabelId) {
        this.namespace = namespace;
        this.lookupElektron = lookupElektron;
        this.supplyLabelId = supplyLabelId;
        this.namespaceId = supplyLabelId.applyAsInt(namespace.name);
        this.bindingsById = new Int2ObjectHashMap();
        this.vaultsById = new Int2ObjectHashMap();
    }

    public int namespaceId() {
        return this.namespaceId;
    }

    public void attach() {
        this.namespace.vaults.forEach(this::attachVault);
        this.namespace.bindings.forEach(this::attachBinding);
    }

    public void detach() {
        this.namespace.vaults.forEach(this::detachVault);
        this.namespace.bindings.forEach(this::detachBinding);
    }

    private void attachBinding(Binding binding) {
        Elektron elektron = this.lookupElektron.apply(binding.type);
        if (elektron != null) {
            int bindingId = this.supplyLabelId.applyAsInt(binding.entry);
            BindingContext context = new BindingContext(binding, elektron);
            this.bindingsById.put(bindingId, (Object)context);
            context.attach();
        }
    }

    private void detachBinding(Binding binding) {
        int bindingId = this.supplyLabelId.applyAsInt(binding.entry);
        BindingContext context = (BindingContext)this.bindingsById.remove(bindingId);
        context.detach();
    }

    private void attachVault(Vault vault) {
        Elektron elektron = this.lookupElektron.apply(vault.type);
        if (elektron != null) {
            int vaultId = this.supplyLabelId.applyAsInt(vault.name);
            VaultContext context = new VaultContext(vault, elektron);
            this.vaultsById.put(vaultId, (Object)context);
            context.attach();
        }
    }

    private void detachVault(Vault vault) {
        int vaultId = this.supplyLabelId.applyAsInt(vault.name);
        VaultContext context = (VaultContext)this.vaultsById.remove(vaultId);
        context.detach();
    }

    BindingContext findBinding(int bindingId) {
        return (BindingContext)this.bindingsById.get(bindingId);
    }

    VaultContext findVault(int vaultId) {
        return (VaultContext)this.vaultsById.get(vaultId);
    }
}

