/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.poller;

import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.nio.TransportPoller;
import org.reaktivity.reaktor.internal.poller.PollerKeyImpl;

public final class Poller
extends TransportPoller {
    private final ToIntFunction<SelectionKey> selectHandler = this::handleSelect;

    public int doWork() {
        int workDone = 0;
        try {
            if (this.selector.selectNow() != 0) {
                workDone = this.selectedKeySet.forEach(this.selectHandler);
            }
        }
        catch (Throwable ex) {
            this.selectedKeySet.reset();
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return workDone;
    }

    public void onClose() {
        for (SelectionKey key : this.selector.keys()) {
            CloseHelper.quietClose((AutoCloseable)key.channel());
        }
        this.selectNowWithoutProcessing();
        super.close();
    }

    public PollerKeyImpl register(SelectableChannel channel) {
        PollerKeyImpl pollerKey = null;
        try {
            SelectionKey key = channel.keyFor(this.selector);
            if (key == null) {
                key = channel.register(this.selector, 0, null);
                key.attach(new PollerKeyImpl(key));
            }
            pollerKey = Poller.attachment(key);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return pollerKey;
    }

    public Stream<PollerKeyImpl> keys() {
        return this.selector.keys().stream().map(k -> Poller.attachment(k));
    }

    private int handleSelect(SelectionKey key) {
        PollerKeyImpl attachment = Poller.attachment(key);
        return attachment.handleSelect(key);
    }

    private static PollerKeyImpl attachment(SelectionKey key) {
        return (PollerKeyImpl)key.attachment();
    }
}

