/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.poller;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.function.ToIntFunction;
import org.reaktivity.reaktor.nukleus.poller.PollerKey;

public final class PollerKeyImpl
implements PollerKey {
    private ToIntFunction<PollerKey> acceptHandler = PollerKeyImpl::nop;
    private ToIntFunction<PollerKey> connectHandler = PollerKeyImpl::nop;
    private ToIntFunction<PollerKey> readHandler = PollerKeyImpl::nop;
    private ToIntFunction<PollerKey> writeHandler = PollerKeyImpl::nop;
    private final SelectionKey key;
    private int interestOps;
    private Object attached;

    PollerKeyImpl(SelectionKey key) {
        this.key = key;
        this.interestOps = key.interestOps();
    }

    @Override
    public Object attach(Object attachment) {
        Object detached = this.attached;
        this.attached = attachment;
        return detached;
    }

    @Override
    public Object attachment() {
        return this.attached;
    }

    @Override
    public SelectableChannel channel() {
        return this.key.channel();
    }

    @Override
    public boolean isValid() {
        return this.key.isValid();
    }

    @Override
    public void register(int registerOps) {
        int newInterestOps = this.interestOps | registerOps;
        if (newInterestOps != this.interestOps) {
            this.key.interestOps(newInterestOps);
            this.interestOps = newInterestOps;
        }
    }

    @Override
    public void cancel() {
        this.key.cancel();
    }

    @Override
    public void clear(int clearOps) {
        int newInterestOps = this.interestOps & ~clearOps;
        if (newInterestOps != this.interestOps) {
            this.key.interestOps(newInterestOps);
            this.interestOps = newInterestOps;
        }
    }

    @Override
    public void handler(int handlerOps, ToIntFunction<PollerKey> handler) {
        if ((handlerOps & 0x10) != 0) {
            ToIntFunction<PollerKey> toIntFunction = this.acceptHandler = handler != null ? handler : PollerKeyImpl::nop;
        }
        if ((handlerOps & 8) != 0) {
            ToIntFunction<PollerKey> toIntFunction = this.connectHandler = handler != null ? handler : PollerKeyImpl::nop;
        }
        if ((handlerOps & 1) != 0) {
            ToIntFunction<PollerKey> toIntFunction = this.readHandler = handler != null ? handler : PollerKeyImpl::nop;
        }
        if ((handlerOps & 4) != 0) {
            this.writeHandler = handler != null ? handler : PollerKeyImpl::nop;
        }
    }

    int handleSelect(SelectionKey key) {
        int readyOps = key.readyOps() & this.interestOps;
        int workDone = 0;
        if ((readyOps & 0x10) != 0) {
            workDone += this.acceptHandler.applyAsInt(this);
        }
        if ((readyOps & 8) != 0) {
            workDone += this.connectHandler.applyAsInt(this);
        }
        if ((readyOps & 1) != 0) {
            workDone += this.readHandler.applyAsInt(this);
        }
        if ((readyOps & 4) != 0) {
            workDone += this.writeHandler.applyAsInt(this);
        }
        return workDone;
    }

    private static int nop(PollerKey key) {
        return 0;
    }
}

