/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.types;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.internal.types.ArrayFW;
import org.reaktivity.reaktor.internal.types.Flyweight;

public final class Array8FW<V extends Flyweight>
extends ArrayFW<V> {
    private static final int LENGTH_SIZE = 1;
    private static final int FIELD_COUNT_SIZE = 1;
    private static final int LENGTH_OFFSET = 0;
    private static final int FIELD_COUNT_OFFSET = 1;
    private static final int FIELDS_OFFSET = 2;
    private static final int LENGTH_MAX_VALUE = 255;
    private static final DirectBuffer EMPTY_BUFFER = new UnsafeBuffer();
    private final V itemRO;
    private final DirectBuffer itemsRO = new UnsafeBuffer(0L, 0);
    private int maxLength;

    public Array8FW(V itemRO) {
        this.itemRO = itemRO;
    }

    @Override
    public int length() {
        return this.buffer().getByte(this.offset() + 0);
    }

    @Override
    public int fieldsOffset() {
        return this.offset() + 2;
    }

    @Override
    public int fieldCount() {
        return this.buffer().getByte(this.offset() + 1);
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    @Override
    public void forEach(Consumer<? super V> consumer) {
        int offset = this.offset() + 2;
        for (int i = 0; i < this.fieldCount(); ++i) {
            ((Flyweight)this.itemRO).wrap(this.buffer(), offset, this.limit(), this);
            consumer.accept(this.itemRO);
            offset = ((Flyweight)this.itemRO).limit();
        }
    }

    @Override
    public boolean anyMatch(Predicate<? super V> predicate) {
        int offset = this.offset() + 2;
        for (int i = 0; i < this.fieldCount(); ++i) {
            ((Flyweight)this.itemRO).wrap(this.buffer(), offset, this.maxLimit(), this);
            if (predicate.test(this.itemRO)) {
                return true;
            }
            offset = ((Flyweight)this.itemRO).limit();
        }
        return false;
    }

    @Override
    public V matchFirst(Predicate<? super V> predicate) {
        int offset = this.offset() + 2;
        for (int i = 0; i < this.fieldCount(); ++i) {
            ((Flyweight)this.itemRO).wrap(this.buffer(), offset, this.maxLimit(), this);
            if (predicate.test(this.itemRO)) {
                return this.itemRO;
            }
            offset = ((Flyweight)this.itemRO).limit();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.fieldCount() == 0;
    }

    @Override
    public DirectBuffer items() {
        return this.itemsRO;
    }

    @Override
    public Array8FW<V> wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        int itemsSize = this.limit() - this.fieldsOffset();
        if (itemsSize == 0) {
            this.itemsRO.wrap(EMPTY_BUFFER, 0, 0);
        } else {
            this.itemsRO.wrap(buffer, offset + 2, itemsSize);
        }
        Array8FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public Array8FW<V> tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (offset + 2 > maxLimit) {
            return null;
        }
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        int itemsSize = this.limit() - this.fieldsOffset();
        if (itemsSize == 0) {
            this.itemsRO.wrap(EMPTY_BUFFER, 0, 0);
        } else {
            this.itemsRO.wrap(buffer, offset + 2, itemsSize);
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 1 + this.length();
    }

    public String toString() {
        return String.format("array8<%d, %d>", this.length(), this.fieldCount());
    }

    @Override
    public void maxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public static final class Builder<B extends Flyweight.Builder<V>, V extends Flyweight>
    extends ArrayFW.Builder<Array8FW<V>, B, V> {
        private final B itemRW;
        private final V itemRO;
        private int fieldCount;
        private int maxLength;

        public Builder(B itemRW, V itemRO) {
            super(new Array8FW<V>(itemRO));
            this.itemRW = itemRW;
            this.itemRO = itemRO;
        }

        @Override
        public int fieldsOffset() {
            return this.offset() + 2;
        }

        public Builder<B, V> item(Consumer<B> consumer) {
            ((Flyweight.Builder)this.itemRW).wrap(this);
            consumer.accept(this.itemRW);
            ((Flyweight.Builder)this.itemRW).build();
            this.maxLength = Math.max(this.maxLength, ((Flyweight.Builder)this.itemRW).sizeof());
            Flyweight.checkLimit(((Flyweight.Builder)this.itemRW).limit(), this.maxLimit());
            this.limit(((Flyweight.Builder)this.itemRW).limit());
            ++this.fieldCount;
            return this;
        }

        public Builder<B, V> items(DirectBuffer buffer, int srcOffset, int length, int fieldCount, int maxLength) {
            this.buffer().putBytes(this.offset() + 2, buffer, srcOffset, length);
            int newLimit = this.offset() + 2 + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            this.fieldCount = fieldCount;
            this.maxLength = maxLength;
            assert (length <= 255) : "Length is too large";
            assert (fieldCount <= 255) : "Field count is too large";
            this.buffer().putByte(this.offset() + 0, (byte)(length + 1));
            this.buffer().putByte(this.offset() + 1, (byte)fieldCount);
            return this;
        }

        public Builder<B, V> wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            int newLimit = offset + 2;
            Flyweight.checkLimit(newLimit, maxLimit);
            this.limit(newLimit);
            this.fieldCount = 0;
            this.maxLength = 0;
            return this;
        }

        @Override
        public Array8FW<V> build() {
            int length = this.limit() - this.offset() - 1;
            assert (length <= 255) : "Length is too large";
            assert (this.fieldCount <= 255) : "Field count is too large";
            this.buffer().putByte(this.offset() + 0, (byte)length);
            this.buffer().putByte(this.offset() + 1, (byte)this.fieldCount);
            ArrayFW array = (ArrayFW)super.build();
            int maxLimit = this.maxLimit();
            this.limit(this.fieldsOffset());
            int itemOffset = this.fieldsOffset();
            ((Flyweight.Builder)this.itemRW).reset(this);
            for (int i = 0; i < this.fieldCount; ++i) {
                Flyweight item = ((Flyweight)this.itemRO).wrap((DirectBuffer)this.buffer(), itemOffset, maxLimit, array);
                itemOffset = item.limit();
                Flyweight newItem = ((Flyweight.Builder)this.itemRW).wrap(this).rebuild(item, this.maxLength);
                int newLimit = newItem.limit();
                assert (newLimit <= itemOffset);
                this.limit(newLimit);
            }
            length = this.limit() - this.offset() - 1;
            this.buffer().putByte(this.offset() + 0, (byte)length);
            Array8FW array8 = (Array8FW)super.build();
            array8.maxLength(this.maxLength);
            return array8;
        }
    }
}

