/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.nukleus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.reaktivity.reaktor.nukleus.Configuration;
import org.reaktivity.reaktor.nukleus.Nukleus;
import org.reaktivity.reaktor.nukleus.NukleusFactorySpi;

public final class NukleusFactory {
    private final Map<String, NukleusFactorySpi> factorySpis;

    public static NukleusFactory instantiate() {
        return NukleusFactory.instantiate(ServiceLoader.load(NukleusFactorySpi.class));
    }

    public Iterable<String> names() {
        return this.factorySpis.keySet();
    }

    public Nukleus create(String name, Configuration config) {
        Objects.requireNonNull(name, "name");
        NukleusFactorySpi factorySpi = Objects.requireNonNull(this.factorySpis.get(name), () -> "Unregonized nukleus name: " + name);
        return factorySpi.create(config);
    }

    private static NukleusFactory instantiate(ServiceLoader<NukleusFactorySpi> factories) {
        HashMap factorySpisByName = new HashMap();
        factories.forEach(factorySpi -> factorySpisByName.put(factorySpi.name(), factorySpi));
        return new NukleusFactory(Collections.unmodifiableMap(factorySpisByName));
    }

    private NukleusFactory(Map<String, NukleusFactorySpi> factorySpis) {
        this.factorySpis = factorySpis;
    }
}

