/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.reaktivity.reaktor.nukleus.Configuration;

public final class NukleusExtConfiguration
extends Configuration {
    public static final Configuration.PropertyDef<String> NUKLEUS_EXT_DIRECTORY;
    public static final Configuration.IntPropertyDef NUKLEUS_EXT_BUDGETS_BUFFER_CAPACITY;
    public static final Configuration.IntPropertyDef NUKLEUS_EXT_STREAMS_BUFFER_CAPACITY;
    public static final Configuration.IntPropertyDef NUKLEUS_EXT_COMMAND_BUFFER_CAPACITY;
    public static final Configuration.IntPropertyDef NUKLEUS_EXT_RESPONSE_BUFFER_CAPACITY;
    public static final Configuration.IntPropertyDef NUKLEUS_EXT_COUNTERS_BUFFER_CAPACITY;
    public static final Configuration.IntPropertyDef NUKLEUS_EXT_MAXIMUM_MESSAGES_PER_READ;
    public static final Configuration.LongPropertyDef NUKLEUS_EXT_BACKOFF_MAX_SPINS;
    public static final Configuration.LongPropertyDef NUKLEUS_EXT_BACKOFF_MAX_YIELDS;
    public static final Configuration.LongPropertyDef NUKLEUS_EXT_BACKOFF_MIN_PARK_NANOS;
    public static final Configuration.LongPropertyDef NUKLEUS_EXT_BACKOFF_MAX_PARK_NANOS;
    private static final Configuration.ConfigurationDef NUKLEUS_EXT_CONFIG;

    public NukleusExtConfiguration() {
    }

    public NukleusExtConfiguration(Configuration config) {
        super(NUKLEUS_EXT_CONFIG, config);
    }

    public NukleusExtConfiguration(Properties properties) {
        super(NUKLEUS_EXT_CONFIG, properties);
    }

    public NukleusExtConfiguration(Configuration config, Properties defaultOverrides) {
        super(NUKLEUS_EXT_CONFIG, config, defaultOverrides);
    }

    public Path directory() {
        return Paths.get((String)NUKLEUS_EXT_DIRECTORY.get((Configuration)this), new String[0]);
    }

    public int maximumMessagesPerRead() {
        return NUKLEUS_EXT_MAXIMUM_MESSAGES_PER_READ.getAsInt((Configuration)this);
    }

    public int budgetsBufferCapacity() {
        return NUKLEUS_EXT_BUDGETS_BUFFER_CAPACITY.getAsInt((Configuration)this);
    }

    public int streamsBufferCapacity() {
        return NUKLEUS_EXT_STREAMS_BUFFER_CAPACITY.getAsInt((Configuration)this);
    }

    public int commandBufferCapacity() {
        return (Integer)NUKLEUS_EXT_COMMAND_BUFFER_CAPACITY.get((Configuration)this);
    }

    public int responseBufferCapacity() {
        return NUKLEUS_EXT_RESPONSE_BUFFER_CAPACITY.getAsInt((Configuration)this);
    }

    public int counterValuesBufferCapacity() {
        return NUKLEUS_EXT_COUNTERS_BUFFER_CAPACITY.getAsInt((Configuration)this);
    }

    public int counterLabelsBufferCapacity() {
        return NUKLEUS_EXT_COUNTERS_BUFFER_CAPACITY.getAsInt((Configuration)this) * 2;
    }

    public long maxSpins() {
        return NUKLEUS_EXT_BACKOFF_MAX_SPINS.getAsLong((Configuration)this);
    }

    public long maxYields() {
        return NUKLEUS_EXT_BACKOFF_MAX_YIELDS.getAsLong((Configuration)this);
    }

    public long minParkNanos() {
        return NUKLEUS_EXT_BACKOFF_MIN_PARK_NANOS.getAsLong((Configuration)this);
    }

    public long maxParkNanos() {
        return NUKLEUS_EXT_BACKOFF_MAX_PARK_NANOS.getAsLong((Configuration)this);
    }

    static {
        Configuration.ConfigurationDef config = new Configuration.ConfigurationDef("k3po.nukleus.ext");
        NUKLEUS_EXT_DIRECTORY = config.property("directory", "target/nukleus-itests");
        NUKLEUS_EXT_BUDGETS_BUFFER_CAPACITY = config.property("budgets.buffer.capacity", 0x100000);
        NUKLEUS_EXT_STREAMS_BUFFER_CAPACITY = config.property("streams.buffer.capacity", 0x100000);
        NUKLEUS_EXT_COMMAND_BUFFER_CAPACITY = config.property("command.buffer.capacity", 0x100000);
        NUKLEUS_EXT_RESPONSE_BUFFER_CAPACITY = config.property("response.buffer.capacity", 0x100000);
        NUKLEUS_EXT_COUNTERS_BUFFER_CAPACITY = config.property("counters.buffer.capacity", 0x100000);
        NUKLEUS_EXT_MAXIMUM_MESSAGES_PER_READ = config.property("maximum.messages.per.read", Integer.MAX_VALUE);
        NUKLEUS_EXT_BACKOFF_MAX_SPINS = config.property("backoff.idle.strategy.max.spins", 64L);
        NUKLEUS_EXT_BACKOFF_MAX_YIELDS = config.property("backoff.idle.strategy.max.yields", 64L);
        NUKLEUS_EXT_BACKOFF_MIN_PARK_NANOS = config.property("backoff.idle.strategy.min.park.period", TimeUnit.NANOSECONDS.toNanos(64L));
        NUKLEUS_EXT_BACKOFF_MAX_PARK_NANOS = config.property("backoff.idle.strategy.max.park.period", TimeUnit.MILLISECONDS.toNanos(1L));
        NUKLEUS_EXT_CONFIG = config;
    }
}

