/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.net.URI;
import java.util.Objects;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public final class NukleusChannelAddress
extends ChannelAddress {
    private static final long serialVersionUID = 1L;
    private final long authorization;
    private final String namespace;
    private final String binding;

    public NukleusChannelAddress(URI location, long authorization, String namespace) {
        this(location, authorization, namespace, NukleusChannelAddress.bindingName(location));
    }

    private NukleusChannelAddress(URI location, long authorization, String namespace, String binding) {
        super(location);
        this.authorization = authorization;
        this.namespace = Objects.requireNonNull(namespace);
        this.binding = Objects.requireNonNull(binding);
    }

    private NukleusChannelAddress(URI location, ChannelAddress transport, boolean ephemeral, long authorization, String namespace, String binding) {
        super(location, transport, ephemeral);
        this.authorization = authorization;
        this.namespace = Objects.requireNonNull(namespace);
        this.binding = Objects.requireNonNull(binding);
    }

    public long getAuthorization() {
        return this.authorization;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getBinding() {
        return this.binding;
    }

    public NukleusChannelAddress newEphemeralAddress() {
        return (NukleusChannelAddress)super.createEphemeralAddress(this::newEphemeralAddress);
    }

    public NukleusChannelAddress newReplyToAddress(String replyAddress) {
        URI location = this.getLocation();
        return new NukleusChannelAddress(location, this.authorization, this.namespace, replyAddress);
    }

    private NukleusChannelAddress newEphemeralAddress(URI location, ChannelAddress transport) {
        return new NukleusChannelAddress(location, transport, true, this.authorization, this.namespace, this.binding);
    }

    private static String bindingName(URI location) {
        String fragment = location.getFragment();
        String path = location.getPath().substring(1);
        return fragment != null ? String.format("%s#%s", path, fragment) : path;
    }
}

