/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.ExecutorUtil;
import org.reaktivity.reaktor.test.internal.k3po.ext.NukleusExtConfiguration;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusReaktor;

public class NukleusReaktorPool
implements ExternalResourceReleasable {
    private final NukleusExtConfiguration config;
    private NukleusReaktor reaktor;
    private ExecutorService reaktorExecutor;

    public NukleusReaktorPool(NukleusExtConfiguration config) {
        this.config = config;
    }

    public NukleusReaktor nextReaktor() {
        if (this.reaktor == null) {
            this.reaktor = new NukleusReaktor(this.config);
            this.reaktorExecutor = Executors.newFixedThreadPool(1);
            this.reaktorExecutor.execute((Runnable)new ThreadRenamingRunnable((Runnable)this.reaktor, "Nukleus reaktor #1"));
        }
        return this.reaktor;
    }

    public void shutdown() {
        if (this.reaktor != null) {
            this.reaktor.shutdown();
        }
    }

    public void releaseExternalResources() {
        this.shutdown();
        if (this.reaktor != null) {
            this.reaktor.releaseExternalResources();
            ExecutorUtil.shutdownNow((Executor)this.reaktorExecutor);
        }
    }
}

