/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public final class Info
implements AutoCloseable {
    private final int workers;
    private final Path info;

    public Info(Path directory, int workers) {
        this.info = directory.resolve("info");
        this.workers = workers;
    }

    public void reset() {
        try {
            Files.deleteIfExists(this.info);
            Files.createDirectories(this.info.getParent(), new FileAttribute[0]);
            Files.createFile(this.info, new FileAttribute[0]);
            long processId = ProcessHandle.current().pid();
            try (SeekableByteChannel channel = Files.newByteChannel(this.info, StandardOpenOption.APPEND);){
                ByteBuffer byteBuf = ByteBuffer.wrap(new byte[12]).order(ByteOrder.nativeOrder());
                byteBuf.putLong(processId);
                byteBuf.putInt(this.workers);
                byteBuf.flip();
                while (byteBuf.hasRemaining()) {
                    channel.write(byteBuf);
                    Thread.onSpinWait();
                }
            }
            catch (IOException ex) {
                System.out.printf("Error: %s is not writeable\n", this.info);
            }
        }
        catch (IOException ex) {
            System.out.printf("Error: %s is not writeable\n", this.info);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

