/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.collections.Long2LongHashMap;

public final class Tuning
implements AutoCloseable {
    private final int available;
    private final Long2LongHashMap affinities;
    private final Path tuning;
    private MappedByteBuffer mappedByteBuf;

    public Tuning(Path directory, int count) {
        this.available = (1 << count) - 1;
        this.affinities = new Long2LongHashMap(-1L);
        this.tuning = directory.resolve("tuning");
    }

    public void reset() {
        try {
            Files.deleteIfExists(this.tuning);
            Files.createDirectories(this.tuning.getParent(), new FileAttribute[0]);
            Files.createFile(this.tuning, new FileAttribute[0]);
            this.mappedByteBuf = Tuning.mapCreateReadWrite(this.tuning, 10240);
        }
        catch (IOException ex) {
            System.out.printf("Error: %s is not writeable\n", this.tuning);
        }
    }

    public void affinity(long routeId, long mask) {
        assert ((mask & (long)(~this.available)) == 0L || mask == Long.MIN_VALUE);
        long offset = this.affinities.get(routeId);
        if (offset == this.affinities.missingValue()) {
            try (SeekableByteChannel channel = Files.newByteChannel(this.tuning, StandardOpenOption.APPEND);){
                offset = channel.position() + 8L;
                ByteBuffer byteBuf = ByteBuffer.wrap(new byte[16]).order(ByteOrder.nativeOrder());
                byteBuf.putLong(routeId);
                byteBuf.putLong(0L);
                byteBuf.flip();
                while (byteBuf.hasRemaining()) {
                    channel.write(byteBuf);
                    Thread.onSpinWait();
                }
                this.affinities.put(routeId, offset);
            }
            catch (IOException ex) {
                System.out.printf("Error: %s is not writeable\n", this.tuning);
            }
        }
        offset = this.affinities.get(routeId);
        assert (offset != this.affinities.missingValue());
        this.mappedByteBuf.putLong((int)offset, mask);
    }

    public long affinity(long routeId) {
        long offset = this.affinities.get(routeId);
        return offset != this.affinities.missingValue() ? this.mappedByteBuf.getLong((int)offset) : (long)this.available;
    }

    @Override
    public void close() throws Exception {
        if (this.mappedByteBuf != null) {
            IoUtil.unmap((MappedByteBuffer)this.mappedByteBuf);
        }
    }

    private static MappedByteBuffer mapCreateReadWrite(Path file, int capacity) {
        MappedByteBuffer mapped = null;
        IoUtil.delete((File)file.toFile(), (boolean)true);
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            mapped = channel.map(FileChannel.MapMode.READ_WRITE, 0L, capacity);
            mapped.order(ByteOrder.nativeOrder());
            channel.truncate(0L);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        assert (mapped != null);
        return mapped;
    }
}

