/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.config;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.bind.adapter.JsonbAdapter;
import org.agrona.collections.MutableInteger;
import org.reaktivity.reaktor.config.Binding;
import org.reaktivity.reaktor.config.NamespacedRef;
import org.reaktivity.reaktor.config.Options;
import org.reaktivity.reaktor.config.OptionsAdapterSpi;
import org.reaktivity.reaktor.config.Role;
import org.reaktivity.reaktor.config.Route;
import org.reaktivity.reaktor.internal.config.OptionsAdapter;
import org.reaktivity.reaktor.internal.config.RoleAdapter;
import org.reaktivity.reaktor.internal.config.RouteAdapter;

public class BindingAdapter
implements JsonbAdapter<Binding, JsonObject> {
    private static final String VAULT_NAME = "vault";
    private static final String ENTRY_NAME = "entry";
    private static final String EXIT_NAME = "exit";
    private static final String TYPE_NAME = "type";
    private static final String KIND_NAME = "kind";
    private static final String OPTIONS_NAME = "options";
    private static final String ROUTES_NAME = "routes";
    private static final List<Route> ROUTES_DEFAULT = Collections.emptyList();
    private final RoleAdapter role = new RoleAdapter();
    private final RouteAdapter route = new RouteAdapter();
    private final OptionsAdapter options = new OptionsAdapter(OptionsAdapterSpi.Kind.BINDING);

    public JsonObject adaptToJson(Binding binding) {
        this.route.adaptType(binding.type);
        this.options.adaptType(binding.type);
        JsonObjectBuilder object = Json.createObjectBuilder();
        if (binding.vault != null) {
            object.add(VAULT_NAME, binding.vault.name);
        }
        if (binding.entry != null) {
            object.add(ENTRY_NAME, binding.entry);
        }
        object.add(TYPE_NAME, binding.type);
        object.add(KIND_NAME, (JsonValue)this.role.adaptToJson(binding.kind));
        if (binding.options != null) {
            object.add(OPTIONS_NAME, (JsonValue)this.options.adaptToJson(binding.options));
        }
        if (!ROUTES_DEFAULT.equals(binding.routes)) {
            JsonArrayBuilder routes = Json.createArrayBuilder();
            binding.routes.forEach(r -> routes.add((JsonValue)this.route.adaptToJson((Route)r)));
            object.add(ROUTES_NAME, routes);
        }
        if (binding.exit != null) {
            object.add(EXIT_NAME, binding.exit.exit);
        }
        return object.build();
    }

    public Binding adaptFromJson(JsonObject object) {
        String type = object.getString(TYPE_NAME);
        this.route.adaptType(type);
        this.options.adaptType(type);
        NamespacedRef vault = object.containsKey((Object)VAULT_NAME) ? NamespacedRef.of(object.getString(VAULT_NAME)) : null;
        String entry = object.containsKey((Object)ENTRY_NAME) ? object.getString(ENTRY_NAME) : null;
        Role kind = this.role.adaptFromJson(object.getJsonString(KIND_NAME));
        Options opts = object.containsKey((Object)OPTIONS_NAME) ? this.options.adaptFromJson(object.getJsonObject(OPTIONS_NAME)) : null;
        MutableInteger order = new MutableInteger();
        List<Route> routes = object.containsKey((Object)ROUTES_NAME) ? object.getJsonArray(ROUTES_NAME).stream().map(JsonValue::asJsonObject).peek(o -> this.route.adaptFromJsonIndex(order.value++)).map(this.route::adaptFromJson).collect(Collectors.toList()) : ROUTES_DEFAULT;
        Route exit = object.containsKey((Object)EXIT_NAME) ? new Route(routes.size(), object.getString(EXIT_NAME)) : null;
        return new Binding(vault, entry, type, kind, opts, routes, exit);
    }
}

