/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.config;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.bind.adapter.JsonbAdapter;
import org.reaktivity.reaktor.config.Binding;
import org.reaktivity.reaktor.config.Vault;
import org.reaktivity.reaktor.internal.config.BindingAdapter;
import org.reaktivity.reaktor.internal.config.Configuration;
import org.reaktivity.reaktor.internal.config.NamespaceRef;
import org.reaktivity.reaktor.internal.config.NamspaceRefAdapter;
import org.reaktivity.reaktor.internal.config.VaultAdapter;

public class ConfigurationAdapter
implements JsonbAdapter<Configuration, JsonObject> {
    private static final String NAME_NAME = "name";
    private static final String BINDINGS_NAME = "bindings";
    private static final String NAMESPACES_NAME = "namespaces";
    private static final String VAULTS_NAME = "vaults";
    private static final String NAME_DEFAULT = "default";
    private static final List<NamespaceRef> NAMESPACES_DEFAULT = Collections.emptyList();
    private static final List<Binding> BINDINGS_DEFAULT = Collections.emptyList();
    private static final List<Vault> VAULTS_DEFAULT = Collections.emptyList();
    private final NamspaceRefAdapter namespace = new NamspaceRefAdapter();
    private final VaultAdapter vault = new VaultAdapter();
    private final BindingAdapter binding = new BindingAdapter();

    public JsonObject adaptToJson(Configuration root) throws Exception {
        JsonObjectBuilder object = Json.createObjectBuilder();
        if (!NAME_DEFAULT.equals(root.name)) {
            object.add(NAME_NAME, root.name);
        }
        if (!VAULTS_DEFAULT.equals(root.vaults)) {
            JsonArrayBuilder vaults = Json.createArrayBuilder();
            root.vaults.forEach(b -> vaults.add((JsonValue)this.vault.adaptToJson((Vault)b)));
            object.add(VAULTS_NAME, vaults);
        }
        if (!BINDINGS_DEFAULT.equals(root.bindings)) {
            JsonArrayBuilder bindings = Json.createArrayBuilder();
            root.bindings.forEach(b -> bindings.add((JsonValue)this.binding.adaptToJson((Binding)b)));
            object.add(BINDINGS_NAME, bindings);
        }
        if (!NAMESPACES_DEFAULT.equals(root.namespaces)) {
            JsonArrayBuilder references = Json.createArrayBuilder();
            root.namespaces.forEach(r -> references.add((JsonValue)this.namespace.adaptToJson((NamespaceRef)r)));
            object.add(NAMESPACES_NAME, references);
        }
        return object.build();
    }

    public Configuration adaptFromJson(JsonObject object) {
        List<Binding> bindings;
        List<NamespaceRef> namespaces;
        String name;
        String string = name = object.containsKey((Object)NAME_NAME) ? object.getString(NAME_NAME) : NAME_DEFAULT;
        List<NamespaceRef> list = object.containsKey((Object)NAMESPACES_NAME) ? object.getJsonArray(NAMESPACES_NAME).stream().map(JsonValue::asJsonObject).map(this.namespace::adaptFromJson).collect(Collectors.toList()) : (namespaces = NAMESPACES_DEFAULT);
        List<Binding> list2 = object.containsKey((Object)BINDINGS_NAME) ? object.getJsonArray(BINDINGS_NAME).stream().map(JsonValue::asJsonObject).map(this.binding::adaptFromJson).collect(Collectors.toList()) : (bindings = BINDINGS_DEFAULT);
        List<Vault> vaults = object.containsKey((Object)VAULTS_NAME) ? object.getJsonArray(VAULTS_NAME).stream().map(JsonValue::asJsonObject).map(this.vault::adaptFromJson).collect(Collectors.toList()) : VAULTS_DEFAULT;
        return new Configuration(name, namespaces, vaults, bindings);
    }
}

