/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.config;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.bind.adapter.JsonbAdapter;
import org.reaktivity.reaktor.config.Binding;
import org.reaktivity.reaktor.config.Namespace;
import org.reaktivity.reaktor.config.Vault;
import org.reaktivity.reaktor.internal.config.BindingAdapter;
import org.reaktivity.reaktor.internal.config.VaultAdapter;

public class NamespaceAdapter
implements JsonbAdapter<Namespace, JsonObject> {
    private static final String NAME_NAME = "name";
    private static final String VAULTS_NAME = "vaults";
    private static final String BINDINGS_NAME = "bindings";
    private static final String NAME_DEFAULT = "default";
    private static final List<Binding> BINDINGS_DEFAULT = Collections.emptyList();
    private static final List<Vault> VAULTS_DEFAULT = Collections.emptyList();
    private final VaultAdapter vault = new VaultAdapter();
    private final BindingAdapter binding = new BindingAdapter();

    public JsonObject adaptToJson(Namespace namespace) throws Exception {
        JsonObjectBuilder object = Json.createObjectBuilder();
        if (!NAME_DEFAULT.equals(namespace.name)) {
            object.add(NAME_NAME, namespace.name);
        }
        if (!VAULTS_DEFAULT.equals(namespace.vaults)) {
            JsonArrayBuilder vaults = Json.createArrayBuilder();
            namespace.vaults.forEach(b -> vaults.add((JsonValue)this.vault.adaptToJson((Vault)b)));
            object.add(VAULTS_NAME, vaults);
        }
        if (!BINDINGS_DEFAULT.equals(namespace.bindings)) {
            JsonArrayBuilder bindings = Json.createArrayBuilder();
            namespace.bindings.forEach(b -> bindings.add((JsonValue)this.binding.adaptToJson((Binding)b)));
            object.add(BINDINGS_NAME, bindings);
        }
        return object.build();
    }

    public Namespace adaptFromJson(JsonObject object) {
        List<Binding> bindings;
        String name = object.getString(NAME_NAME, NAME_DEFAULT);
        List<Binding> list = object.containsKey((Object)BINDINGS_NAME) ? object.getJsonArray(BINDINGS_NAME).stream().map(JsonValue::asJsonObject).map(this.binding::adaptFromJson).collect(Collectors.toList()) : (bindings = BINDINGS_DEFAULT);
        List<Vault> vaults = object.containsKey((Object)VAULTS_NAME) ? object.getJsonArray(VAULTS_NAME).stream().map(JsonValue::asJsonObject).map(this.vault::adaptFromJson).collect(Collectors.toList()) : VAULTS_DEFAULT;
        return new Namespace(name, vaults, bindings);
    }
}

