/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.config;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.bind.adapter.JsonbAdapter;
import org.reaktivity.reaktor.config.Condition;
import org.reaktivity.reaktor.config.Route;
import org.reaktivity.reaktor.config.With;
import org.reaktivity.reaktor.internal.config.ConditionAdapter;
import org.reaktivity.reaktor.internal.config.WithAdapter;

public class RouteAdapter
implements JsonbAdapter<Route, JsonObject> {
    private static final String EXIT_NAME = "exit";
    private static final String WHEN_NAME = "when";
    private static final String WITH_NAME = "with";
    private static final List<Condition> WHEN_DEFAULT = Collections.emptyList();
    private int index;
    private final ConditionAdapter condition = new ConditionAdapter();
    private final WithAdapter with = new WithAdapter();

    public RouteAdapter adaptType(String type) {
        this.condition.adaptType(type);
        this.with.adaptType(type);
        return this;
    }

    public void adaptFromJsonIndex(int index) {
        this.index = index;
    }

    public JsonObject adaptToJson(Route route) {
        JsonObjectBuilder object = Json.createObjectBuilder();
        object.add(EXIT_NAME, route.exit);
        if (!WHEN_DEFAULT.equals(route.when)) {
            JsonArrayBuilder when = Json.createArrayBuilder();
            route.when.forEach(r -> when.add((JsonValue)this.condition.adaptToJson((Condition)r)));
            object.add(WHEN_NAME, when);
        }
        if (route.with != null) {
            object.add(WITH_NAME, (JsonValue)this.with.adaptToJson(route.with));
        }
        return object.build();
    }

    public Route adaptFromJson(JsonObject object) {
        String exit = object.getString(EXIT_NAME);
        List<Condition> when = object.containsKey((Object)WHEN_NAME) ? object.getJsonArray(WHEN_NAME).stream().map(JsonValue::asJsonObject).map(this.condition::adaptFromJson).collect(Collectors.toList()) : WHEN_DEFAULT;
        With wth = object.containsKey((Object)WITH_NAME) ? this.with.adaptFromJson(object.getJsonObject(WITH_NAME)) : null;
        return new Route(this.index, exit, when, wth);
    }
}

