/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.config;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.bind.adapter.JsonbAdapter;
import org.reaktivity.reaktor.config.Options;
import org.reaktivity.reaktor.config.OptionsAdapterSpi;
import org.reaktivity.reaktor.config.Vault;
import org.reaktivity.reaktor.internal.config.OptionsAdapter;

public class VaultAdapter
implements JsonbAdapter<Vault, JsonObject> {
    private static final String NAME_NAME = "name";
    private static final String TYPE_NAME = "type";
    private static final String OPTIONS_NAME = "options";
    private final OptionsAdapter options = new OptionsAdapter(OptionsAdapterSpi.Kind.VAULT);

    public JsonObject adaptToJson(Vault vault) {
        this.options.adaptType(vault.type);
        JsonObjectBuilder object = Json.createObjectBuilder();
        object.add(NAME_NAME, vault.name);
        object.add(TYPE_NAME, vault.type);
        if (vault.options != null) {
            object.add(OPTIONS_NAME, (JsonValue)this.options.adaptToJson(vault.options));
        }
        return object.build();
    }

    public Vault adaptFromJson(JsonObject object) {
        String name = object.getString(NAME_NAME);
        String type = object.getString(TYPE_NAME);
        this.options.adaptType(type);
        Options opts = object.containsKey((Object)OPTIONS_NAME) ? this.options.adaptFromJson(object.getJsonObject(OPTIONS_NAME)) : null;
        return new Vault(name, type, opts);
    }
}

