/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.context;

import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.ToIntFunction;
import org.agrona.collections.Int2ObjectHashMap;
import org.reaktivity.reaktor.config.Namespace;
import org.reaktivity.reaktor.internal.context.BindingContext;
import org.reaktivity.reaktor.internal.context.NamespaceContext;
import org.reaktivity.reaktor.internal.context.NamespaceTask;
import org.reaktivity.reaktor.internal.context.VaultContext;
import org.reaktivity.reaktor.internal.stream.NamespacedId;
import org.reaktivity.reaktor.nukleus.Elektron;

public class ConfigurationContext {
    private final Function<String, Elektron> elektronsByName;
    private final ToIntFunction<String> supplyLabelId;
    private final LongConsumer supplyLoadEntry;
    private final Int2ObjectHashMap<NamespaceContext> namespacesById;

    public ConfigurationContext(Function<String, Elektron> elektronsByName, ToIntFunction<String> supplyLabelId, LongConsumer supplyLoadEntry) {
        this.elektronsByName = elektronsByName;
        this.supplyLabelId = supplyLabelId;
        this.supplyLoadEntry = supplyLoadEntry;
        this.namespacesById = new Int2ObjectHashMap();
    }

    public NamespaceTask attach(Namespace namespace) {
        return new NamespaceTask(namespace, this::attachNamespace);
    }

    public NamespaceTask detach(Namespace namespace) {
        return new NamespaceTask(namespace, this::detachNamespace);
    }

    public BindingContext resolveBinding(long bindingId) {
        int namespaceId = NamespacedId.namespaceId(bindingId);
        int localId = NamespacedId.localId(bindingId);
        NamespaceContext namespace = this.findNamespace(namespaceId);
        return namespace != null ? namespace.findBinding(localId) : null;
    }

    public VaultContext resolveVault(long vaultId) {
        int namespaceId = NamespacedId.namespaceId(vaultId);
        int localId = NamespacedId.localId(vaultId);
        NamespaceContext namespace = this.findNamespace(namespaceId);
        return namespace != null ? namespace.findVault(localId) : null;
    }

    public void detachAll() {
        this.namespacesById.values().forEach(n -> n.detach());
        this.namespacesById.clear();
    }

    private NamespaceContext findNamespace(int namespaceId) {
        return (NamespaceContext)this.namespacesById.get(namespaceId);
    }

    private void attachNamespace(Namespace namespace) {
        NamespaceContext context = new NamespaceContext(namespace, this.elektronsByName, this.supplyLabelId, this.supplyLoadEntry);
        this.namespacesById.put(context.namespaceId(), (Object)context);
        context.attach();
    }

    protected void detachNamespace(Namespace namespace) {
        int namespaceId = this.supplyLabelId.applyAsInt(namespace.name);
        NamespaceContext context = (NamespaceContext)this.namespacesById.remove(namespaceId);
        context.detach();
    }
}

