/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.context;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.adapter.JsonbAdapter;
import org.agrona.ErrorHandler;
import org.reaktivity.reaktor.config.Binding;
import org.reaktivity.reaktor.config.Route;
import org.reaktivity.reaktor.config.Vault;
import org.reaktivity.reaktor.ext.ReaktorExtContext;
import org.reaktivity.reaktor.ext.ReaktorExtSpi;
import org.reaktivity.reaktor.internal.Tuning;
import org.reaktivity.reaktor.internal.config.Configuration;
import org.reaktivity.reaktor.internal.config.ConfigurationAdapter;
import org.reaktivity.reaktor.internal.context.DispatchAgent;
import org.reaktivity.reaktor.internal.stream.NamespacedId;
import org.reaktivity.reaktor.internal.util.Mustache;

public class ConfigureTask
implements Callable<Void> {
    private final URL configURL;
    private final ToIntFunction<String> supplyId;
    private final Tuning tuning;
    private final Collection<DispatchAgent> dispatchers;
    private final ErrorHandler errorHandler;
    private final Consumer<String> logger;
    private final ReaktorExtContext context;
    private final List<ReaktorExtSpi> extensions;

    public ConfigureTask(URL configURL, ToIntFunction<String> supplyId, Tuning tuning, Collection<DispatchAgent> dispatchers, ErrorHandler errorHandler, Consumer<String> logger, ReaktorExtContext context, List<ReaktorExtSpi> extensions) {
        this.configURL = configURL;
        this.supplyId = supplyId;
        this.tuning = tuning;
        this.dispatchers = dispatchers;
        this.errorHandler = errorHandler;
        this.logger = logger;
        this.context = context;
        this.extensions = extensions;
    }

    @Override
    public Void call() throws Exception {
        String configText;
        if (this.configURL == null) {
            configText = "{}";
        } else if ("https".equals(this.configURL.getProtocol()) || "https".equals(this.configURL.getProtocol())) {
            HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
            HttpRequest request = HttpRequest.newBuilder().GET().uri(this.configURL.toURI()).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            Iterator body = response.body();
            configText = body;
        } else {
            URLConnection connection = this.configURL.openConnection();
            try (InputStream input = connection.getInputStream();){
                configText = new String(input.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        configText = Mustache.resolve(configText, System::getenv);
        this.logger.accept(configText);
        try {
            JsonbConfig config = new JsonbConfig().withAdapters(new JsonbAdapter[]{new ConfigurationAdapter()});
            Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
            Configuration configuration = (Configuration)jsonb.fromJson(configText, Configuration.class);
            configuration.id = this.supplyId.applyAsInt(configuration.name);
            for (Binding binding : configuration.bindings) {
                binding.id = NamespacedId.id(configuration.id, this.supplyId.applyAsInt(binding.entry));
                if (binding.vault != null) {
                    binding.vault.id = NamespacedId.id(this.supplyId.applyAsInt(binding.vault.namespace), this.supplyId.applyAsInt(binding.vault.name));
                }
                for (Route route : binding.routes) {
                    route.id = NamespacedId.id(configuration.id, this.supplyId.applyAsInt(route.exit));
                }
                if (binding.exit != null) {
                    binding.exit.id = NamespacedId.id(configuration.id, this.supplyId.applyAsInt(binding.exit.exit));
                }
                this.tuning.affinity(binding.id, this.tuning.affinity(binding.id));
            }
            for (Vault vault : configuration.vaults) {
                vault.id = NamespacedId.id(configuration.id, this.supplyId.applyAsInt(vault.name));
            }
            CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
            for (DispatchAgent dispatcher : this.dispatchers) {
                future = CompletableFuture.allOf(future, dispatcher.attach(configuration));
            }
            future.join();
            this.extensions.forEach(e -> e.onConfigured(this.context));
        }
        catch (Throwable ex) {
            this.errorHandler.onError(ex);
        }
        return null;
    }
}

