/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.layouts;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.internal.layouts.Layout;

public final class LoadLayout
extends Layout {
    private static final int LOAD_VERSION = 1;
    private static final int FIELD_OFFSET_VERSION = 0;
    private static final int FIELD_SIZE_VERSION = 4;
    private static final int FIELD_OFFSET_BUFFER_LENGTH = 4;
    private static final int FIELD_SIZE_COUNTER_LABELS_BUFFER_LENGTH = 4;
    private static final int END_OF_META_DATA_OFFSET = BitUtil.align((int)8, (int)64);
    private final AtomicBuffer buffer = new UnsafeBuffer(0L, 0);

    public AtomicBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        IoUtil.unmap((ByteBuffer)this.buffer.byteBuffer());
    }

    public static final class Builder
    extends Layout.Builder<LoadLayout> {
        private final LoadLayout layout = new LoadLayout();
        private Path path;
        private int capacity;

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        @Override
        public LoadLayout build() {
            File loadFile = this.path.toFile();
            CloseHelper.close((AutoCloseable)IoUtil.createEmptyFile((File)loadFile, (long)(END_OF_META_DATA_OFFSET + this.capacity)));
            MappedByteBuffer metadata = IoUtil.mapExistingFile((File)loadFile, (String)"metadata", (long)0L, (long)END_OF_META_DATA_OFFSET);
            metadata.putInt(0, 1);
            metadata.putInt(4, this.capacity);
            IoUtil.unmap((MappedByteBuffer)metadata);
            int loadBufferOffset = END_OF_META_DATA_OFFSET;
            int loadBufferLength = this.capacity;
            this.layout.buffer.wrap((ByteBuffer)IoUtil.mapExistingFile((File)loadFile, (String)"load", (long)loadBufferOffset, (long)loadBufferLength));
            return this.layout;
        }
    }
}

