/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.load;

import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.reaktivity.reaktor.ReaktorLoad;
import org.reaktivity.reaktor.internal.stream.NamespacedId;

public final class LoadEntry
implements ReaktorLoad {
    private static final int OFFSET_NAMESPACE_ID = 0;
    private static final int SIZE_OF_NAMESPACE_ID = 4;
    private static final int OFFSET_ENTRY_ID = 4;
    private static final int SIZE_OF_ENTRY_ID = 4;
    private static final int OFFSET_INITIAL_OPENS = 8;
    private static final int SIZE_OF_INITIAL_OPENS = 8;
    private static final int OFFSET_INITIAL_CLOSES = 16;
    private static final int SIZE_OF_INITIAL_CLOSES = 8;
    private static final int OFFSET_INITIAL_BYTES = 24;
    private static final int SIZE_OF_INITIAL_BYTES = 8;
    private static final int OFFSET_INITIAL_ERRORS = 32;
    private static final int SIZE_OF_INITIAL_ERRORS = 8;
    private static final int OFFSET_REPLY_OPENS = 40;
    private static final int SIZE_OF_REPLY_OPENS = 8;
    private static final int OFFSET_REPLY_CLOSES = 48;
    private static final int SIZE_OF_REPLY_CLOSES = 8;
    private static final int OFFSET_REPLY_BYTES = 56;
    private static final int SIZE_OF_REPLY_BYTES = 8;
    private static final int OFFSET_REPLY_ERRORS = 64;
    private static final int SIZE_OF_REPLY_ERRORS = 8;
    private static final int SIZE_OF = 72;
    private static final int SIZE_OF_ALIGNED = BitUtil.align((int)72, (int)16);
    private final AtomicBuffer buffer;
    private final int offset;

    public LoadEntry(AtomicBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
    }

    public long namespacedId() {
        return NamespacedId.id(this.namespaceId(), this.entryId());
    }

    public int namespaceId() {
        return this.buffer.getInt(this.offset + 0);
    }

    public int entryId() {
        return this.buffer.getInt(this.offset + 4);
    }

    @Override
    public long initialOpens() {
        return this.buffer.getLong(this.offset + 8);
    }

    @Override
    public long initialCloses() {
        return this.buffer.getLong(this.offset + 16);
    }

    public LoadEntry initialOpened(long count) {
        assert (count >= 0L);
        this.buffer.getAndAddLong(this.offset + 8, count);
        return this;
    }

    public LoadEntry initialClosed(long count) {
        assert (count >= 0L);
        this.buffer.getAndAddLong(this.offset + 16, count);
        return this;
    }

    @Override
    public long initialBytes() {
        return this.buffer.getLong(this.offset + 24);
    }

    public LoadEntry initialBytesRead(long count) {
        assert (count >= 0L);
        this.buffer.getAndAddLong(this.offset + 24, count);
        return this;
    }

    @Override
    public long initialErrors() {
        return this.buffer.getLong(this.offset + 32);
    }

    public LoadEntry initialErrored(long count) {
        assert (count >= 0L);
        this.buffer.getAndAddLong(this.offset + 32, count);
        return this;
    }

    @Override
    public long replyOpens() {
        return this.buffer.getLong(this.offset + 40);
    }

    @Override
    public long replyCloses() {
        return this.buffer.getLong(this.offset + 48);
    }

    public LoadEntry replyOpened(long count) {
        assert (count >= 0L);
        this.buffer.getAndAddLong(this.offset + 40, count);
        return this;
    }

    public LoadEntry replyClosed(long count) {
        assert (count >= 0L);
        this.buffer.getAndAddLong(this.offset + 48, count);
        return this;
    }

    @Override
    public long replyBytes() {
        return this.buffer.getLong(this.offset + 56);
    }

    public LoadEntry replyBytesWritten(long count) {
        assert (count >= 0L);
        this.buffer.getAndAddLong(this.offset + 56, count);
        return this;
    }

    @Override
    public long replyErrors() {
        return this.buffer.getLong(this.offset + 64);
    }

    public LoadEntry replyErrored(long count) {
        assert (count >= 0L);
        this.buffer.getAndAddLong(this.offset + 64, count);
        return this;
    }

    public static int sizeofAligned() {
        return SIZE_OF_ALIGNED;
    }

    public void init(long namespacedId) {
        this.buffer.setMemory(this.offset, this.offset + SIZE_OF_ALIGNED, (byte)0);
        this.buffer.putInt(this.offset + 0, NamespacedId.namespaceId(namespacedId));
        this.buffer.putInt(this.offset + 4, NamespacedId.localId(namespacedId));
    }
}

