/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.load;

import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.AtomicBuffer;
import org.reaktivity.reaktor.internal.load.LoadEntry;

public final class LoadManager {
    private final AtomicBuffer buffer;
    private final Long2ObjectHashMap<LoadEntry> entries;
    private int nextOffset;

    public LoadManager(AtomicBuffer buffer) {
        LoadEntry entry;
        this.buffer = buffer;
        int sizeofEntry = LoadEntry.sizeofAligned();
        Long2ObjectHashMap entries = new Long2ObjectHashMap();
        while (this.nextOffset < buffer.capacity() - sizeofEntry && (entry = new LoadEntry(buffer, this.nextOffset)).namespacedId() != 0L) {
            entries.put(entry.namespacedId(), (Object)entry);
            this.nextOffset += sizeofEntry;
        }
        this.entries = entries;
    }

    public LoadEntry entry(long namespacedId) {
        LoadEntry entry = (LoadEntry)this.entries.get(namespacedId);
        if (entry == null) {
            int sizeofEntry = LoadEntry.sizeofAligned();
            entry = new LoadEntry(this.buffer, this.nextOffset);
            entry.init(namespacedId);
            this.entries.put(namespacedId, (Object)entry);
            this.nextOffset += sizeofEntry;
            assert (this.nextOffset < this.buffer.capacity());
        }
        return entry;
    }
}

