/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import org.recast4j.recast.AreaModification;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.Telemetry;

public class Recast {
    void calcBounds(float[] verts, int nv, float[] bmin, float[] bmax) {
        int i;
        for (i = 0; i < 3; ++i) {
            bmin[i] = verts[i];
            bmax[i] = verts[i];
        }
        for (i = 1; i < nv; ++i) {
            for (int j = 0; j < 3; ++j) {
                bmin[j] = Math.min(bmin[j], verts[i * 3 + j]);
                bmax[j] = Math.max(bmax[j], verts[i * 3 + j]);
            }
        }
    }

    public static int[] calcGridSize(float[] bmin, float[] bmax, float cs) {
        return new int[]{(int)((bmax[0] - bmin[0]) / cs + 0.5f), (int)((bmax[2] - bmin[2]) / cs + 0.5f)};
    }

    public static int[] calcTileCount(float[] bmin, float[] bmax, float cs, int tileSizeX, int tileSizeZ) {
        int[] gwd = Recast.calcGridSize(bmin, bmax, cs);
        int gw = gwd[0];
        int gd = gwd[1];
        int tw = (gw + tileSizeX - 1) / tileSizeX;
        int td = (gd + tileSizeZ - 1) / tileSizeZ;
        return new int[]{tw, td};
    }

    public static int[] markWalkableTriangles(Telemetry ctx, float walkableSlopeAngle, float[] verts, int[] tris, int nt, AreaModification areaMod) {
        int[] areas = new int[nt];
        float walkableThr = (float)Math.cos((double)(walkableSlopeAngle / 180.0f) * Math.PI);
        float[] norm = new float[3];
        for (int i = 0; i < nt; ++i) {
            int tri = i * 3;
            Recast.calcTriNormal(verts, tris[tri], tris[tri + 1], tris[tri + 2], norm);
            if (!(norm[1] > walkableThr)) continue;
            areas[i] = areaMod.apply(areas[i]);
        }
        return areas;
    }

    static void calcTriNormal(float[] verts, int v0, int v1, int v2, float[] norm) {
        float[] e0 = new float[3];
        float[] e1 = new float[3];
        RecastVectors.sub(e0, verts, v1 * 3, v0 * 3);
        RecastVectors.sub(e1, verts, v2 * 3, v0 * 3);
        RecastVectors.cross(norm, e0, e1);
        RecastVectors.normalize(norm);
    }

    public static void clearUnwalkableTriangles(Telemetry ctx, float walkableSlopeAngle, float[] verts, int nv, int[] tris, int nt, int[] areas) {
        float walkableThr = (float)Math.cos((double)(walkableSlopeAngle / 180.0f) * Math.PI);
        float[] norm = new float[3];
        for (int i = 0; i < nt; ++i) {
            int tri = i * 3;
            Recast.calcTriNormal(verts, tris[tri], tris[tri + 1], tris[tri + 2], norm);
            if (!(norm[1] <= walkableThr)) continue;
            areas[i] = 0;
        }
    }
}

