/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.Arrays;
import org.recast4j.recast.AreaModification;
import org.recast4j.recast.CompactCell;
import org.recast4j.recast.CompactHeightfield;
import org.recast4j.recast.CompactSpan;
import org.recast4j.recast.RecastCommon;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.Telemetry;

public class RecastArea {
    public static void erodeWalkableArea(Telemetry ctx, int radius, CompactHeightfield chf) {
        int aai;
        int aay;
        int aax;
        int nd;
        int ai;
        int ay;
        int ax;
        int i;
        int y;
        int w = chf.width;
        int h = chf.height;
        ctx.startTimer("ERODE_AREA");
        int[] dist = new int[chf.spanCount];
        Arrays.fill(dist, 255);
        for (int y2 = 0; y2 < h; ++y2) {
            for (int x = 0; x < w; ++x) {
                CompactCell c = chf.cells[x + y2 * w];
                int ni = c.index + c.count;
                for (int i2 = c.index; i2 < ni; ++i2) {
                    if (chf.areas[i2] == 0) {
                        dist[i2] = 0;
                        continue;
                    }
                    CompactSpan s = chf.spans[i2];
                    int nc = 0;
                    for (int dir = 0; dir < 4; ++dir) {
                        if (RecastCommon.GetCon(s, dir) == 63) continue;
                        int nx = x + RecastCommon.GetDirOffsetX(dir);
                        int ny = y2 + RecastCommon.GetDirOffsetY(dir);
                        int nidx = chf.cells[nx + ny * w].index + RecastCommon.GetCon(s, dir);
                        if (chf.areas[nidx] == 0) continue;
                        ++nc;
                    }
                    if (nc == 4) continue;
                    dist[i2] = 0;
                }
            }
        }
        for (y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                CompactCell c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (i = c.index; i < ni; ++i) {
                    CompactSpan as;
                    CompactSpan s = chf.spans[i];
                    if (RecastCommon.GetCon(s, 0) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(0);
                        ay = y + RecastCommon.GetDirOffsetY(0);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 0);
                        as = chf.spans[ai];
                        nd = Math.min(dist[ai] + 2, 255);
                        if (nd < dist[i]) {
                            dist[i] = nd;
                        }
                        if (RecastCommon.GetCon(as, 3) != 63) {
                            aax = ax + RecastCommon.GetDirOffsetX(3);
                            aay = ay + RecastCommon.GetDirOffsetY(3);
                            aai = chf.cells[aax + aay * w].index + RecastCommon.GetCon(as, 3);
                            nd = Math.min(dist[aai] + 3, 255);
                            if (nd < dist[i]) {
                                dist[i] = nd;
                            }
                        }
                    }
                    if (RecastCommon.GetCon(s, 3) == 63) continue;
                    ax = x + RecastCommon.GetDirOffsetX(3);
                    ay = y + RecastCommon.GetDirOffsetY(3);
                    ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 3);
                    as = chf.spans[ai];
                    nd = Math.min(dist[ai] + 2, 255);
                    if (nd < dist[i]) {
                        dist[i] = nd;
                    }
                    if (RecastCommon.GetCon(as, 2) == 63) continue;
                    aax = ax + RecastCommon.GetDirOffsetX(2);
                    aay = ay + RecastCommon.GetDirOffsetY(2);
                    aai = chf.cells[aax + aay * w].index + RecastCommon.GetCon(as, 2);
                    nd = Math.min(dist[aai] + 3, 255);
                    if (nd >= dist[i]) continue;
                    dist[i] = nd;
                }
            }
        }
        for (y = h - 1; y >= 0; --y) {
            for (int x = w - 1; x >= 0; --x) {
                CompactCell c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (i = c.index; i < ni; ++i) {
                    CompactSpan as;
                    CompactSpan s = chf.spans[i];
                    if (RecastCommon.GetCon(s, 2) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(2);
                        ay = y + RecastCommon.GetDirOffsetY(2);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 2);
                        as = chf.spans[ai];
                        nd = Math.min(dist[ai] + 2, 255);
                        if (nd < dist[i]) {
                            dist[i] = nd;
                        }
                        if (RecastCommon.GetCon(as, 1) != 63) {
                            aax = ax + RecastCommon.GetDirOffsetX(1);
                            aay = ay + RecastCommon.GetDirOffsetY(1);
                            aai = chf.cells[aax + aay * w].index + RecastCommon.GetCon(as, 1);
                            nd = Math.min(dist[aai] + 3, 255);
                            if (nd < dist[i]) {
                                dist[i] = nd;
                            }
                        }
                    }
                    if (RecastCommon.GetCon(s, 1) == 63) continue;
                    ax = x + RecastCommon.GetDirOffsetX(1);
                    ay = y + RecastCommon.GetDirOffsetY(1);
                    ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 1);
                    as = chf.spans[ai];
                    nd = Math.min(dist[ai] + 2, 255);
                    if (nd < dist[i]) {
                        dist[i] = nd;
                    }
                    if (RecastCommon.GetCon(as, 0) == 63) continue;
                    aax = ax + RecastCommon.GetDirOffsetX(0);
                    aay = ay + RecastCommon.GetDirOffsetY(0);
                    aai = chf.cells[aax + aay * w].index + RecastCommon.GetCon(as, 0);
                    nd = Math.min(dist[aai] + 3, 255);
                    if (nd >= dist[i]) continue;
                    dist[i] = nd;
                }
            }
        }
        int thr = radius * 2;
        for (int i3 = 0; i3 < chf.spanCount; ++i3) {
            if (dist[i3] >= thr) continue;
            chf.areas[i3] = 0;
        }
        ctx.stopTimer("ERODE_AREA");
    }

    public boolean medianFilterWalkableArea(Telemetry ctx, CompactHeightfield chf) {
        int w = chf.width;
        int h = chf.height;
        ctx.startTimer("MEDIAN_AREA");
        int[] areas = new int[chf.spanCount];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                CompactCell c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni; ++i) {
                    CompactSpan s = chf.spans[i];
                    if (chf.areas[i] == 0) {
                        areas[i] = chf.areas[i];
                        continue;
                    }
                    int[] nei = new int[9];
                    for (int j = 0; j < 9; ++j) {
                        nei[j] = chf.areas[i];
                    }
                    for (int dir = 0; dir < 4; ++dir) {
                        int dir2;
                        CompactSpan as;
                        if (RecastCommon.GetCon(s, dir) == 63) continue;
                        int ax = x + RecastCommon.GetDirOffsetX(dir);
                        int ay = y + RecastCommon.GetDirOffsetY(dir);
                        int ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, dir);
                        if (chf.areas[ai] != 0) {
                            nei[dir * 2 + 0] = chf.areas[ai];
                        }
                        if (RecastCommon.GetCon(as = chf.spans[ai], dir2 = dir + 1 & 3) == 63) continue;
                        int ax2 = ax + RecastCommon.GetDirOffsetX(dir2);
                        int ay2 = ay + RecastCommon.GetDirOffsetY(dir2);
                        int ai2 = chf.cells[ax2 + ay2 * w].index + RecastCommon.GetCon(as, dir2);
                        if (chf.areas[ai2] == 0) continue;
                        nei[dir * 2 + 1] = chf.areas[ai2];
                    }
                    Arrays.sort(nei);
                    areas[i] = nei[4];
                }
            }
        }
        chf.areas = areas;
        ctx.stopTimer("MEDIAN_AREA");
        return true;
    }

    public void markBoxArea(Telemetry ctx, float[] bmin, float[] bmax, AreaModification areaMod, CompactHeightfield chf) {
        ctx.startTimer("MARK_BOX_AREA");
        int minx = (int)((bmin[0] - chf.bmin[0]) / chf.cs);
        int miny = (int)((bmin[1] - chf.bmin[1]) / chf.ch);
        int minz = (int)((bmin[2] - chf.bmin[2]) / chf.cs);
        int maxx = (int)((bmax[0] - chf.bmin[0]) / chf.cs);
        int maxy = (int)((bmax[1] - chf.bmin[1]) / chf.ch);
        int maxz = (int)((bmax[2] - chf.bmin[2]) / chf.cs);
        if (maxx < 0) {
            return;
        }
        if (minx >= chf.width) {
            return;
        }
        if (maxz < 0) {
            return;
        }
        if (minz >= chf.height) {
            return;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx >= chf.width) {
            maxx = chf.width - 1;
        }
        if (minz < 0) {
            minz = 0;
        }
        if (maxz >= chf.height) {
            maxz = chf.height - 1;
        }
        for (int z = minz; z <= maxz; ++z) {
            for (int x = minx; x <= maxx; ++x) {
                CompactCell c = chf.cells[x + z * chf.width];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni; ++i) {
                    CompactSpan s = chf.spans[i];
                    if (s.y < miny || s.y > maxy || chf.areas[i] == 0) continue;
                    chf.areas[i] = areaMod.apply(chf.areas[i]);
                }
            }
        }
        ctx.stopTimer("MARK_BOX_AREA");
    }

    static boolean pointInPoly(float[] verts, float[] p) {
        boolean c = false;
        int j = verts.length - 3;
        for (int i = 0; i < verts.length; i += 3) {
            int vj;
            int vi = i;
            if (verts[vi + 2] > p[2] != verts[(vj = j) + 2] > p[2] && p[0] < (verts[vj] - verts[vi]) * (p[2] - verts[vi + 2]) / (verts[vj + 2] - verts[vi + 2]) + verts[vi]) {
                c = !c;
            }
            j = i;
        }
        return c;
    }

    public static void markConvexPolyArea(Telemetry ctx, float[] verts, float hmin, float hmax, AreaModification areaMod, CompactHeightfield chf) {
        ctx.startTimer("MARK_CONVEXPOLY_AREA");
        float[] bmin = new float[3];
        float[] bmax = new float[3];
        RecastVectors.copy(bmin, verts, 0);
        RecastVectors.copy(bmax, verts, 0);
        for (int i = 3; i < verts.length; i += 3) {
            RecastVectors.min(bmin, verts, i);
            RecastVectors.max(bmax, verts, i);
        }
        bmin[1] = hmin;
        bmax[1] = hmax;
        int minx = (int)((bmin[0] - chf.bmin[0]) / chf.cs);
        int miny = (int)((bmin[1] - chf.bmin[1]) / chf.ch);
        int minz = (int)((bmin[2] - chf.bmin[2]) / chf.cs);
        int maxx = (int)((bmax[0] - chf.bmin[0]) / chf.cs);
        int maxy = (int)((bmax[1] - chf.bmin[1]) / chf.ch);
        int maxz = (int)((bmax[2] - chf.bmin[2]) / chf.cs);
        if (maxx < 0) {
            return;
        }
        if (minx >= chf.width) {
            return;
        }
        if (maxz < 0) {
            return;
        }
        if (minz >= chf.height) {
            return;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx >= chf.width) {
            maxx = chf.width - 1;
        }
        if (minz < 0) {
            minz = 0;
        }
        if (maxz >= chf.height) {
            maxz = chf.height - 1;
        }
        for (int z = minz; z <= maxz; ++z) {
            for (int x = minx; x <= maxx; ++x) {
                CompactCell c = chf.cells[x + z * chf.width];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni; ++i) {
                    float[] p;
                    CompactSpan s = chf.spans[i];
                    if (chf.areas[i] == 0 || s.y < miny || s.y > maxy || !RecastArea.pointInPoly(verts, p = new float[]{chf.bmin[0] + ((float)x + 0.5f) * chf.cs, 0.0f, chf.bmin[2] + ((float)z + 0.5f) * chf.cs})) continue;
                    chf.areas[i] = areaMod.apply(chf.areas[i]);
                }
            }
        }
        ctx.stopTimer("MARK_CONVEXPOLY_AREA");
    }

    int offsetPoly(float[] verts, int nverts, float offset, float[] outVerts, int maxOutVerts) {
        float MITER_LIMIT = 1.2f;
        int n = 0;
        for (int i = 0; i < nverts; ++i) {
            boolean bevel;
            float dy1;
            float dx1;
            float d1;
            int a = (i + nverts - 1) % nverts;
            int b = i;
            int c = (i + 1) % nverts;
            int va = a * 3;
            int vb = b * 3;
            int vc = c * 3;
            float dx0 = verts[vb] - verts[va];
            float dy0 = verts[vb + 2] - verts[va + 2];
            float d0 = dx0 * dx0 + dy0 * dy0;
            if (d0 > 1.0E-6f) {
                d0 = (float)(1.0 / Math.sqrt(d0));
                dx0 *= d0;
                dy0 *= d0;
            }
            if ((d1 = (dx1 = verts[vc] - verts[vb]) * dx1 + (dy1 = verts[vc + 2] - verts[vb + 2]) * dy1) > 1.0E-6f) {
                d1 = (float)(1.0 / Math.sqrt(d1));
                dx1 *= d1;
                dy1 *= d1;
            }
            float dlx0 = -dy0;
            float dly0 = dx0;
            float dlx1 = -dy1;
            float dly1 = dx1;
            float cross = dx1 * dy0 - dx0 * dy1;
            float dmx = (dlx0 + dlx1) * 0.5f;
            float dmy = (dly0 + dly1) * 0.5f;
            float dmr2 = dmx * dmx + dmy * dmy;
            boolean bl = bevel = dmr2 * MITER_LIMIT * MITER_LIMIT < 1.0f;
            if (dmr2 > 1.0E-6f) {
                float scale = 1.0f / dmr2;
                dmx *= scale;
                dmy *= scale;
            }
            if (bevel && cross < 0.0f) {
                if (n + 2 > maxOutVerts) {
                    return 0;
                }
                float d = (1.0f - (dx0 * dx1 + dy0 * dy1)) * 0.5f;
                outVerts[n * 3 + 0] = verts[vb] + (-dlx0 + dx0 * d) * offset;
                outVerts[n * 3 + 1] = verts[vb + 1];
                outVerts[n * 3 + 2] = verts[vb + 2] + (-dly0 + dy0 * d) * offset;
                outVerts[++n * 3 + 0] = verts[vb] + (-dlx1 - dx1 * d) * offset;
                outVerts[n * 3 + 1] = verts[vb + 1];
                outVerts[n * 3 + 2] = verts[vb + 2] + (-dly1 - dy1 * d) * offset;
                ++n;
                continue;
            }
            if (n + 1 > maxOutVerts) {
                return 0;
            }
            outVerts[n * 3 + 0] = verts[vb] - dmx * offset;
            outVerts[n * 3 + 1] = verts[vb + 1];
            outVerts[n * 3 + 2] = verts[vb + 2] - dmy * offset;
            ++n;
        }
        return n;
    }

    public void markCylinderArea(Telemetry ctx, float[] pos, float r, float h, AreaModification areaMod, CompactHeightfield chf) {
        ctx.startTimer("MARK_CYLINDER_AREA");
        float[] bmin = new float[3];
        float[] bmax = new float[3];
        bmin[0] = pos[0] - r;
        bmin[1] = pos[1];
        bmin[2] = pos[2] - r;
        bmax[0] = pos[0] + r;
        bmax[1] = pos[1] + h;
        bmax[2] = pos[2] + r;
        float r2 = r * r;
        int minx = (int)((bmin[0] - chf.bmin[0]) / chf.cs);
        int miny = (int)((bmin[1] - chf.bmin[1]) / chf.ch);
        int minz = (int)((bmin[2] - chf.bmin[2]) / chf.cs);
        int maxx = (int)((bmax[0] - chf.bmin[0]) / chf.cs);
        int maxy = (int)((bmax[1] - chf.bmin[1]) / chf.ch);
        int maxz = (int)((bmax[2] - chf.bmin[2]) / chf.cs);
        if (maxx < 0) {
            return;
        }
        if (minx >= chf.width) {
            return;
        }
        if (maxz < 0) {
            return;
        }
        if (minz >= chf.height) {
            return;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx >= chf.width) {
            maxx = chf.width - 1;
        }
        if (minz < 0) {
            minz = 0;
        }
        if (maxz >= chf.height) {
            maxz = chf.height - 1;
        }
        for (int z = minz; z <= maxz; ++z) {
            for (int x = minx; x <= maxx; ++x) {
                CompactCell c = chf.cells[x + z * chf.width];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni; ++i) {
                    float sz;
                    float dz;
                    float sx;
                    float dx;
                    CompactSpan s = chf.spans[i];
                    if (chf.areas[i] == 0 || s.y < miny || s.y > maxy || !((dx = (sx = chf.bmin[0] + ((float)x + 0.5f) * chf.cs) - pos[0]) * dx + (dz = (sz = chf.bmin[2] + ((float)z + 0.5f) * chf.cs) - pos[2]) * dz < r2)) continue;
                    chf.areas[i] = areaMod.apply(chf.areas[i]);
                }
            }
        }
        ctx.stopTimer("MARK_CYLINDER_AREA");
    }
}

