/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.recast4j.recast.CompactHeightfield;
import org.recast4j.recast.ContourSet;
import org.recast4j.recast.ConvexVolume;
import org.recast4j.recast.Heightfield;
import org.recast4j.recast.HeightfieldLayerSet;
import org.recast4j.recast.PolyMesh;
import org.recast4j.recast.PolyMeshDetail;
import org.recast4j.recast.Recast;
import org.recast4j.recast.RecastArea;
import org.recast4j.recast.RecastBuilderConfig;
import org.recast4j.recast.RecastCompact;
import org.recast4j.recast.RecastConfig;
import org.recast4j.recast.RecastConstants;
import org.recast4j.recast.RecastContour;
import org.recast4j.recast.RecastFilter;
import org.recast4j.recast.RecastLayers;
import org.recast4j.recast.RecastMesh;
import org.recast4j.recast.RecastMeshDetail;
import org.recast4j.recast.RecastRegion;
import org.recast4j.recast.RecastVoxelization;
import org.recast4j.recast.Telemetry;
import org.recast4j.recast.geom.ConvexVolumeProvider;
import org.recast4j.recast.geom.InputGeomProvider;

public class RecastBuilder {
    private final RecastBuilderProgressListener progressListener;

    public RecastBuilder() {
        this.progressListener = null;
    }

    public RecastBuilder(RecastBuilderProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public List<RecastBuilderResult> buildTiles(InputGeomProvider geom, RecastConfig cfg, Optional<Executor> executor) {
        float[] bmin = geom.getMeshBoundsMin();
        float[] bmax = geom.getMeshBoundsMax();
        int[] twh = Recast.calcTileCount(bmin, bmax, cfg.cs, cfg.tileSizeX, cfg.tileSizeZ);
        int tw = twh[0];
        int th = twh[1];
        List<RecastBuilderResult> result = null;
        result = executor.isPresent() ? this.buildMultiThread(geom, cfg, bmin, bmax, tw, th, executor.get()) : this.buildSingleThread(geom, cfg, bmin, bmax, tw, th);
        return result;
    }

    private List<RecastBuilderResult> buildSingleThread(InputGeomProvider geom, RecastConfig cfg, float[] bmin, float[] bmax, int tw, int th) {
        ArrayList<RecastBuilderResult> result = new ArrayList<RecastBuilderResult>(tw * th);
        AtomicInteger counter = new AtomicInteger();
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                result.add(this.buildTile(geom, cfg, bmin, bmax, x, y, counter, tw * th));
            }
        }
        return result;
    }

    private List<RecastBuilderResult> buildMultiThread(InputGeomProvider geom, RecastConfig cfg, float[] bmin, float[] bmax, int tw, int th, Executor executor) {
        ArrayList<RecastBuilderResult> result = new ArrayList<RecastBuilderResult>(tw * th);
        AtomicInteger counter = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(tw * th);
        for (int x = 0; x < tw; ++x) {
            int y = 0;
            while (y < th) {
                int tx = x;
                int ty = y++;
                executor.execute(() -> {
                    try {
                        RecastBuilderResult tile = this.buildTile(geom, cfg, bmin, bmax, tx, ty, counter, tw * th);
                        List list = result;
                        synchronized (list) {
                            result.add(tile);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    latch.countDown();
                });
            }
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    private RecastBuilderResult buildTile(InputGeomProvider geom, RecastConfig cfg, float[] bmin, float[] bmax, int tx, int ty, AtomicInteger counter, int total) {
        RecastBuilderResult result = this.build(geom, new RecastBuilderConfig(cfg, bmin, bmax, tx, ty));
        if (this.progressListener != null) {
            this.progressListener.onProgress(counter.incrementAndGet(), total);
        }
        return result;
    }

    public RecastBuilderResult build(InputGeomProvider geom, RecastBuilderConfig builderCfg) {
        RecastConfig cfg = builderCfg.cfg;
        Telemetry ctx = new Telemetry();
        Heightfield solid = RecastVoxelization.buildSolidHeightfield(geom, builderCfg, ctx);
        return this.build(builderCfg.tileX, builderCfg.tileZ, geom, cfg, solid, ctx);
    }

    public RecastBuilderResult build(int tileX, int tileZ, ConvexVolumeProvider geom, RecastConfig cfg, Heightfield solid, Telemetry ctx) {
        this.filterHeightfield(solid, cfg, ctx);
        CompactHeightfield chf = this.buildCompactHeightfield(geom, cfg, ctx, solid);
        if (cfg.partitionType == RecastConstants.PartitionType.WATERSHED) {
            RecastRegion.buildDistanceField(ctx, chf);
            RecastRegion.buildRegions(ctx, chf, cfg.minRegionArea, cfg.mergeRegionArea);
        } else if (cfg.partitionType == RecastConstants.PartitionType.MONOTONE) {
            RecastRegion.buildRegionsMonotone(ctx, chf, cfg.minRegionArea, cfg.mergeRegionArea);
        } else {
            RecastRegion.buildLayerRegions(ctx, chf, cfg.minRegionArea);
        }
        ContourSet cset = RecastContour.buildContours(ctx, chf, cfg.maxSimplificationError, cfg.maxEdgeLen, RecastConstants.RC_CONTOUR_TESS_WALL_EDGES);
        PolyMesh pmesh = RecastMesh.buildPolyMesh(ctx, cset, cfg.maxVertsPerPoly);
        PolyMeshDetail dmesh = cfg.buildMeshDetail ? RecastMeshDetail.buildPolyMeshDetail(ctx, pmesh, chf, cfg.detailSampleDist, cfg.detailSampleMaxError) : null;
        return new RecastBuilderResult(tileX, tileZ, solid, chf, cset, pmesh, dmesh, ctx);
    }

    private void filterHeightfield(Heightfield solid, RecastConfig cfg, Telemetry ctx) {
        if (cfg.filterLowHangingObstacles) {
            RecastFilter.filterLowHangingWalkableObstacles(ctx, cfg.walkableClimb, solid);
        }
        if (cfg.filterLedgeSpans) {
            RecastFilter.filterLedgeSpans(ctx, cfg.walkableHeight, cfg.walkableClimb, solid);
        }
        if (cfg.filterWalkableLowHeightSpans) {
            RecastFilter.filterWalkableLowHeightSpans(ctx, cfg.walkableHeight, solid);
        }
    }

    private CompactHeightfield buildCompactHeightfield(ConvexVolumeProvider volumeProvider, RecastConfig cfg, Telemetry ctx, Heightfield solid) {
        CompactHeightfield chf = RecastCompact.buildCompactHeightfield(ctx, cfg.walkableHeight, cfg.walkableClimb, solid);
        RecastArea.erodeWalkableArea(ctx, cfg.walkableRadius, chf);
        if (volumeProvider != null) {
            for (ConvexVolume vol : volumeProvider.convexVolumes()) {
                RecastArea.markConvexPolyArea(ctx, vol.verts, vol.hmin, vol.hmax, vol.areaMod, chf);
            }
        }
        return chf;
    }

    public HeightfieldLayerSet buildLayers(InputGeomProvider geom, RecastBuilderConfig builderCfg) {
        Telemetry ctx = new Telemetry();
        Heightfield solid = RecastVoxelization.buildSolidHeightfield(geom, builderCfg, ctx);
        this.filterHeightfield(solid, builderCfg.cfg, ctx);
        CompactHeightfield chf = this.buildCompactHeightfield(geom, builderCfg.cfg, ctx, solid);
        return RecastLayers.buildHeightfieldLayers(ctx, chf, builderCfg.cfg.walkableHeight);
    }

    public static interface RecastBuilderProgressListener {
        public void onProgress(int var1, int var2);
    }

    public static class RecastBuilderResult {
        public final int tileX;
        public final int tileZ;
        private final CompactHeightfield chf;
        private final ContourSet cs;
        private final PolyMesh pmesh;
        private final PolyMeshDetail dmesh;
        private final Heightfield solid;
        private final Telemetry telemetry;

        public RecastBuilderResult(int tileX, int tileZ, Heightfield solid, CompactHeightfield chf, ContourSet cs, PolyMesh pmesh, PolyMeshDetail dmesh, Telemetry ctx) {
            this.tileX = tileX;
            this.tileZ = tileZ;
            this.solid = solid;
            this.chf = chf;
            this.cs = cs;
            this.pmesh = pmesh;
            this.dmesh = dmesh;
            this.telemetry = ctx;
        }

        public PolyMesh getMesh() {
            return this.pmesh;
        }

        public PolyMeshDetail getMeshDetail() {
            return this.dmesh;
        }

        public CompactHeightfield getCompactHeightfield() {
            return this.chf;
        }

        public ContourSet getContourSet() {
            return this.cs;
        }

        public Heightfield getSolidHeightfield() {
            return this.solid;
        }

        public Telemetry getTelemetry() {
            return this.telemetry;
        }
    }
}

