/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import org.recast4j.recast.Recast;
import org.recast4j.recast.RecastConfig;
import org.recast4j.recast.RecastVectors;

public class RecastBuilderConfig {
    public final RecastConfig cfg;
    public final int tileX;
    public final int tileZ;
    public final int width;
    public final int height;
    public final float[] bmin = new float[3];
    public final float[] bmax = new float[3];

    public RecastBuilderConfig(RecastConfig cfg, float[] bmin, float[] bmax) {
        this(cfg, bmin, bmax, 0, 0);
    }

    public RecastBuilderConfig(RecastConfig cfg, float[] bmin, float[] bmax, int tileX, int tileZ) {
        this.tileX = tileX;
        this.tileZ = tileZ;
        this.cfg = cfg;
        RecastVectors.copy(this.bmin, bmin);
        RecastVectors.copy(this.bmax, bmax);
        if (cfg.useTiles) {
            float tsx = (float)cfg.tileSizeX * cfg.cs;
            float tsz = (float)cfg.tileSizeZ * cfg.cs;
            this.bmin[0] = this.bmin[0] + (float)tileX * tsx;
            this.bmin[2] = this.bmin[2] + (float)tileZ * tsz;
            this.bmax[0] = this.bmin[0] + tsx;
            this.bmax[2] = this.bmin[2] + tsz;
            this.bmin[0] = this.bmin[0] - (float)cfg.borderSize * cfg.cs;
            this.bmin[2] = this.bmin[2] - (float)cfg.borderSize * cfg.cs;
            this.bmax[0] = this.bmax[0] + (float)cfg.borderSize * cfg.cs;
            this.bmax[2] = this.bmax[2] + (float)cfg.borderSize * cfg.cs;
            this.width = cfg.tileSizeX + cfg.borderSize * 2;
            this.height = cfg.tileSizeZ + cfg.borderSize * 2;
        } else {
            int[] wh = Recast.calcGridSize(this.bmin, this.bmax, cfg.cs);
            this.width = wh[0];
            this.height = wh[1];
        }
    }
}

