/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import org.recast4j.recast.CompactCell;
import org.recast4j.recast.CompactHeightfield;
import org.recast4j.recast.CompactSpan;
import org.recast4j.recast.Heightfield;
import org.recast4j.recast.RecastCommon;
import org.recast4j.recast.RecastConstants;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.Span;
import org.recast4j.recast.Telemetry;

public class RecastCompact {
    private static final int MAX_LAYERS = 62;
    private static final int MAX_HEIGHT = RecastConstants.SPAN_MAX_HEIGHT;

    public static CompactHeightfield buildCompactHeightfield(Telemetry ctx, int walkableHeight, int walkableClimb, Heightfield hf) {
        CompactCell c;
        int i;
        ctx.startTimer("BUILD_COMPACTHEIGHTFIELD");
        CompactHeightfield chf = new CompactHeightfield();
        int w = hf.width;
        int h = hf.height;
        int spanCount = RecastCompact.getHeightFieldSpanCount(hf);
        chf.width = w;
        chf.height = h;
        chf.borderSize = hf.borderSize;
        chf.spanCount = spanCount;
        chf.walkableHeight = walkableHeight;
        chf.walkableClimb = walkableClimb;
        chf.maxRegions = 0;
        RecastVectors.copy(chf.bmin, hf.bmin);
        RecastVectors.copy(chf.bmax, hf.bmax);
        chf.bmax[1] = chf.bmax[1] + (float)walkableHeight * hf.ch;
        chf.cs = hf.cs;
        chf.ch = hf.ch;
        chf.cells = new CompactCell[w * h];
        chf.spans = new CompactSpan[spanCount];
        chf.areas = new int[spanCount];
        for (i = 0; i < chf.cells.length; ++i) {
            chf.cells[i] = new CompactCell();
        }
        for (i = 0; i < chf.spans.length; ++i) {
            chf.spans[i] = new CompactSpan();
        }
        int idx = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Span s = hf.spans[x + y * w];
                if (s == null) continue;
                c = chf.cells[x + y * w];
                c.index = idx;
                c.count = 0;
                while (s != null) {
                    if (s.area != 0) {
                        int bot = s.smax;
                        int top = s.next != null ? s.next.smin : MAX_HEIGHT;
                        chf.spans[idx].y = RecastCommon.clamp(bot, 0, MAX_HEIGHT);
                        chf.spans[idx].h = RecastCommon.clamp(top - bot, 0, MAX_HEIGHT);
                        chf.areas[idx] = s.area;
                        ++idx;
                        ++c.count;
                    }
                    s = s.next;
                }
            }
        }
        int tooHighNeighbour = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (int i2 = c.index; i2 < ni; ++i2) {
                    CompactSpan s = chf.spans[i2];
                    block8: for (int dir = 0; dir < 4; ++dir) {
                        RecastCommon.SetCon(s, dir, 63);
                        int nx = x + RecastCommon.GetDirOffsetX(dir);
                        int ny = y + RecastCommon.GetDirOffsetY(dir);
                        if (nx < 0 || ny < 0 || nx >= w || ny >= h) continue;
                        CompactCell nc = chf.cells[nx + ny * w];
                        int nk = nc.index + nc.count;
                        for (int k = nc.index; k < nk; ++k) {
                            CompactSpan ns = chf.spans[k];
                            int bot = Math.max(s.y, ns.y);
                            int top = Math.min(s.y + s.h, ns.y + ns.h);
                            if (top - bot < walkableHeight || Math.abs(ns.y - s.y) > walkableClimb) continue;
                            int lidx = k - nc.index;
                            if (lidx < 0 || lidx > 62) {
                                tooHighNeighbour = Math.max(tooHighNeighbour, lidx);
                                continue;
                            }
                            RecastCommon.SetCon(s, dir, lidx);
                            continue block8;
                        }
                    }
                }
            }
        }
        if (tooHighNeighbour > 62) {
            throw new RuntimeException("rcBuildCompactHeightfield: Heightfield has too many layers " + tooHighNeighbour + " (max: " + 62 + ")");
        }
        ctx.stopTimer("BUILD_COMPACTHEIGHTFIELD");
        return chf;
    }

    private static int getHeightFieldSpanCount(Heightfield hf) {
        int w = hf.width;
        int h = hf.height;
        int spanCount = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Span s = hf.spans[x + y * w];
                while (s != null) {
                    if (s.area != 0) {
                        ++spanCount;
                    }
                    s = s.next;
                }
            }
        }
        return spanCount;
    }
}

