/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import org.recast4j.recast.AreaModification;
import org.recast4j.recast.RecastConstants;

public class RecastConfig {
    public final RecastConstants.PartitionType partitionType;
    public final boolean useTiles;
    public final int tileSizeX;
    public final int tileSizeZ;
    public final float cs;
    public final float ch;
    public final float walkableSlopeAngle;
    public final int walkableHeight;
    public final int walkableClimb;
    public final int walkableRadius;
    public final int maxEdgeLen;
    public final float maxSimplificationError;
    public final int minRegionArea;
    public final int mergeRegionArea;
    public final int maxVertsPerPoly;
    public final float detailSampleDist;
    public final float detailSampleMaxError;
    public final AreaModification walkableAreaMod;
    public final boolean filterLowHangingObstacles;
    public final boolean filterLedgeSpans;
    public final boolean filterWalkableLowHeightSpans;
    public final boolean buildMeshDetail;
    public final int borderSize;
    public final float minRegionAreaWorld;
    public final float mergeRegionAreaWorld;
    public final float walkableHeightWorld;
    public final float walkableClimbWorld;
    public final float walkableRadiusWorld;
    public final float maxEdgeLenWorld;

    public RecastConfig(RecastConstants.PartitionType partitionType, float cellSize, float cellHeight, float agentHeight, float agentRadius, float agentMaxClimb, float agentMaxSlope, int regionMinSize, int regionMergeSize, float edgeMaxLen, float edgeMaxError, int vertsPerPoly, float detailSampleDist, float detailSampleMaxError, AreaModification walkableAreaMod) {
        this(partitionType, cellSize, cellHeight, agentMaxSlope, true, true, true, agentHeight, agentRadius, agentMaxClimb, regionMinSize, regionMergeSize, edgeMaxLen, edgeMaxError, vertsPerPoly, detailSampleDist, detailSampleMaxError, walkableAreaMod, true);
    }

    public RecastConfig(RecastConstants.PartitionType partitionType, float cellSize, float cellHeight, float agentMaxSlope, boolean filterLowHangingObstacles, boolean filterLedgeSpans, boolean filterWalkableLowHeightSpans, float agentHeight, float agentRadius, float agentMaxClimb, int regionMinSize, int regionMergeSize, float edgeMaxLen, float edgeMaxError, int vertsPerPoly, float detailSampleDist, float detailSampleMaxError, AreaModification walkableAreaMod, boolean buildMeshDetail) {
        this(false, 0, 0, 0, partitionType, cellSize, cellHeight, agentMaxSlope, filterLowHangingObstacles, filterLedgeSpans, filterWalkableLowHeightSpans, agentHeight, agentRadius, agentMaxClimb, (float)(regionMinSize * regionMinSize) * cellSize * cellSize, (float)(regionMergeSize * regionMergeSize) * cellSize * cellSize, edgeMaxLen, edgeMaxError, vertsPerPoly, buildMeshDetail, detailSampleDist, detailSampleMaxError, walkableAreaMod);
    }

    public RecastConfig(boolean useTiles, int tileSizeX, int tileSizeZ, int borderSize, RecastConstants.PartitionType partitionType, float cellSize, float cellHeight, float agentMaxSlope, boolean filterLowHangingObstacles, boolean filterLedgeSpans, boolean filterWalkableLowHeightSpans, float agentHeight, float agentRadius, float agentMaxClimb, float minRegionArea, float mergeRegionArea, float edgeMaxLen, float edgeMaxError, int vertsPerPoly, boolean buildMeshDetail, float detailSampleDist, float detailSampleMaxError, AreaModification walkableAreaMod) {
        this.useTiles = useTiles;
        this.tileSizeX = tileSizeX;
        this.tileSizeZ = tileSizeZ;
        this.borderSize = borderSize;
        this.partitionType = partitionType;
        this.cs = cellSize;
        this.ch = cellHeight;
        this.walkableSlopeAngle = agentMaxSlope;
        this.walkableHeight = (int)Math.ceil(agentHeight / this.ch);
        this.walkableHeightWorld = agentHeight;
        this.walkableClimb = (int)Math.floor(agentMaxClimb / this.ch);
        this.walkableClimbWorld = agentMaxClimb;
        this.walkableRadius = (int)Math.ceil(agentRadius / this.cs);
        this.walkableRadiusWorld = agentRadius;
        this.minRegionArea = Math.round(minRegionArea / (this.cs * this.cs));
        this.minRegionAreaWorld = minRegionArea;
        this.mergeRegionArea = Math.round(mergeRegionArea / (this.cs * this.cs));
        this.mergeRegionAreaWorld = mergeRegionArea;
        this.maxEdgeLen = (int)(edgeMaxLen / cellSize);
        this.maxEdgeLenWorld = edgeMaxLen;
        this.maxSimplificationError = edgeMaxError;
        this.maxVertsPerPoly = vertsPerPoly;
        this.detailSampleDist = detailSampleDist < 0.9f ? 0.0f : cellSize * detailSampleDist;
        this.detailSampleMaxError = cellHeight * detailSampleMaxError;
        this.walkableAreaMod = walkableAreaMod;
        this.filterLowHangingObstacles = filterLowHangingObstacles;
        this.filterLedgeSpans = filterLedgeSpans;
        this.filterWalkableLowHeightSpans = filterWalkableLowHeightSpans;
        this.buildMeshDetail = buildMeshDetail;
    }

    public static int calcBorder(float agentRadius, float cs) {
        return 3 + (int)Math.ceil(agentRadius / cs);
    }
}

