/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.recast4j.recast.CompactCell;
import org.recast4j.recast.CompactHeightfield;
import org.recast4j.recast.CompactSpan;
import org.recast4j.recast.Contour;
import org.recast4j.recast.ContourSet;
import org.recast4j.recast.RecastCommon;
import org.recast4j.recast.RecastConstants;
import org.recast4j.recast.RecastMesh;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.Telemetry;

public class RecastContour {
    private static CornerHeight getCornerHeight(int x, int y, int i, int dir, CompactHeightfield chf) {
        CompactSpan as2;
        int ai2;
        int ay2;
        int ax2;
        CompactSpan as;
        int ai;
        int ay;
        int ax;
        boolean isBorderVertex = false;
        CompactSpan s = chf.spans[i];
        int ch = s.y;
        int dirp = dir + 1 & 3;
        int[] regs = new int[]{0, 0, 0, 0};
        regs[0] = chf.spans[i].reg | chf.areas[i] << 16;
        if (RecastCommon.GetCon(s, dir) != 63) {
            ax = x + RecastCommon.GetDirOffsetX(dir);
            ay = y + RecastCommon.GetDirOffsetY(dir);
            ai = chf.cells[ax + ay * chf.width].index + RecastCommon.GetCon(s, dir);
            as = chf.spans[ai];
            ch = Math.max(ch, as.y);
            regs[1] = chf.spans[ai].reg | chf.areas[ai] << 16;
            if (RecastCommon.GetCon(as, dirp) != 63) {
                ax2 = ax + RecastCommon.GetDirOffsetX(dirp);
                ay2 = ay + RecastCommon.GetDirOffsetY(dirp);
                ai2 = chf.cells[ax2 + ay2 * chf.width].index + RecastCommon.GetCon(as, dirp);
                as2 = chf.spans[ai2];
                ch = Math.max(ch, as2.y);
                regs[2] = chf.spans[ai2].reg | chf.areas[ai2] << 16;
            }
        }
        if (RecastCommon.GetCon(s, dirp) != 63) {
            ax = x + RecastCommon.GetDirOffsetX(dirp);
            ay = y + RecastCommon.GetDirOffsetY(dirp);
            ai = chf.cells[ax + ay * chf.width].index + RecastCommon.GetCon(s, dirp);
            as = chf.spans[ai];
            ch = Math.max(ch, as.y);
            regs[3] = chf.spans[ai].reg | chf.areas[ai] << 16;
            if (RecastCommon.GetCon(as, dir) != 63) {
                ax2 = ax + RecastCommon.GetDirOffsetX(dir);
                ay2 = ay + RecastCommon.GetDirOffsetY(dir);
                ai2 = chf.cells[ax2 + ay2 * chf.width].index + RecastCommon.GetCon(as, dir);
                as2 = chf.spans[ai2];
                ch = Math.max(ch, as2.y);
                regs[2] = chf.spans[ai2].reg | chf.areas[ai2] << 16;
            }
        }
        for (int j = 0; j < 4; ++j) {
            boolean noZeros;
            int a = j;
            int b = j + 1 & 3;
            int c = j + 2 & 3;
            int d = j + 3 & 3;
            boolean twoSameExts = (regs[a] & regs[b] & RecastConstants.RC_BORDER_REG) != 0 && regs[a] == regs[b];
            boolean twoInts = ((regs[c] | regs[d]) & RecastConstants.RC_BORDER_REG) == 0;
            boolean intsSameArea = regs[c] >> 16 == regs[d] >> 16;
            boolean bl = noZeros = regs[a] != 0 && regs[b] != 0 && regs[c] != 0 && regs[d] != 0;
            if (!twoSameExts || !twoInts || !intsSameArea || !noZeros) continue;
            isBorderVertex = true;
            break;
        }
        return new CornerHeight(ch, isBorderVertex);
    }

    private static void walkContour(int x, int y, int i, CompactHeightfield chf, int[] flags, List<Integer> points) {
        int dir = 0;
        while ((flags[i] & 1 << dir) == 0) {
            ++dir;
        }
        int startDir = dir;
        int starti = i;
        int area = chf.areas[i];
        int iter = 0;
        while (++iter < 40000) {
            if ((flags[i] & 1 << dir) != 0) {
                boolean isAreaBorder = false;
                CornerHeight cornerHeight = RecastContour.getCornerHeight(x, y, i, dir, chf);
                boolean isBorderVertex = cornerHeight.borderVertex;
                int px = x;
                int py = cornerHeight.height;
                int pz = y;
                switch (dir) {
                    case 0: {
                        ++pz;
                        break;
                    }
                    case 1: {
                        ++px;
                        ++pz;
                        break;
                    }
                    case 2: {
                        ++px;
                    }
                }
                int r = 0;
                CompactSpan s = chf.spans[i];
                if (RecastCommon.GetCon(s, dir) != 63) {
                    int ax = x + RecastCommon.GetDirOffsetX(dir);
                    int ay = y + RecastCommon.GetDirOffsetY(dir);
                    int ai = chf.cells[ax + ay * chf.width].index + RecastCommon.GetCon(s, dir);
                    r = chf.spans[ai].reg;
                    if (area != chf.areas[ai]) {
                        isAreaBorder = true;
                    }
                }
                if (isBorderVertex) {
                    r |= RecastConstants.RC_BORDER_VERTEX;
                }
                if (isAreaBorder) {
                    r |= RecastConstants.RC_AREA_BORDER;
                }
                points.add(px);
                points.add(py);
                points.add(pz);
                points.add(r);
                int n = i;
                flags[n] = flags[n] & ~(1 << dir);
                dir = dir + 1 & 3;
            } else {
                int ni = -1;
                int nx = x + RecastCommon.GetDirOffsetX(dir);
                int ny = y + RecastCommon.GetDirOffsetY(dir);
                CompactSpan s = chf.spans[i];
                if (RecastCommon.GetCon(s, dir) != 63) {
                    CompactCell nc = chf.cells[nx + ny * chf.width];
                    ni = nc.index + RecastCommon.GetCon(s, dir);
                }
                if (ni == -1) {
                    return;
                }
                x = nx;
                y = ny;
                i = ni;
                dir = dir + 3 & 3;
            }
            if (starti != i || startDir != dir) continue;
            break;
        }
    }

    private static float distancePtSeg(int x, int z, int px, int pz, int qx, int qz) {
        float pqx = qx - px;
        float pqz = qz - pz;
        float dx = x - px;
        float dz = z - pz;
        float d = pqx * pqx + pqz * pqz;
        float t = pqx * dx + pqz * dz;
        if (d > 0.0f) {
            t /= d;
        }
        if (t < 0.0f) {
            t = 0.0f;
        } else if (t > 1.0f) {
            t = 1.0f;
        }
        dx = (float)px + t * pqx - (float)x;
        dz = (float)pz + t * pqz - (float)z;
        return dx * dx + dz * dz;
    }

    private static void simplifyContour(List<Integer> points, List<Integer> simplified, float maxError, int maxEdgeLen, int buildFlags) {
        int bi;
        int bz;
        int bx;
        int ai;
        int az;
        int ax;
        int ii;
        int i;
        boolean hasConnections = false;
        for (i = 0; i < points.size(); i += 4) {
            if ((points.get(i + 3) & RecastConstants.RC_CONTOUR_REG_MASK) == 0) continue;
            hasConnections = true;
            break;
        }
        if (hasConnections) {
            int ni = points.size() / 4;
            for (i = 0; i < ni; ++i) {
                boolean areaBorders;
                ii = (i + 1) % ni;
                boolean differentRegs = (points.get(i * 4 + 3) & RecastConstants.RC_CONTOUR_REG_MASK) != (points.get(ii * 4 + 3) & RecastConstants.RC_CONTOUR_REG_MASK);
                boolean bl = areaBorders = (points.get(i * 4 + 3) & RecastConstants.RC_AREA_BORDER) != (points.get(ii * 4 + 3) & RecastConstants.RC_AREA_BORDER);
                if (!differentRegs && !areaBorders) continue;
                simplified.add(points.get(i * 4 + 0));
                simplified.add(points.get(i * 4 + 1));
                simplified.add(points.get(i * 4 + 2));
                simplified.add(i);
            }
        }
        if (simplified.size() == 0) {
            int llx = points.get(0);
            int lly = points.get(1);
            int llz = points.get(2);
            int lli = 0;
            int urx = points.get(0);
            int ury = points.get(1);
            int urz = points.get(2);
            int uri = 0;
            for (int i2 = 0; i2 < points.size(); i2 += 4) {
                int x = points.get(i2 + 0);
                int y = points.get(i2 + 1);
                int z = points.get(i2 + 2);
                if (x < llx || x == llx && z < llz) {
                    llx = x;
                    lly = y;
                    llz = z;
                    lli = i2 / 4;
                }
                if (x <= urx && (x != urx || z <= urz)) continue;
                urx = x;
                ury = y;
                urz = z;
                uri = i2 / 4;
            }
            simplified.add(llx);
            simplified.add(lly);
            simplified.add(llz);
            simplified.add(lli);
            simplified.add(urx);
            simplified.add(ury);
            simplified.add(urz);
            simplified.add(uri);
        }
        int pn = points.size() / 4;
        int i3 = 0;
        while (i3 < simplified.size() / 4) {
            int endi;
            int ci;
            int cinc;
            ii = (i3 + 1) % (simplified.size() / 4);
            ax = simplified.get(i3 * 4 + 0);
            az = simplified.get(i3 * 4 + 2);
            ai = simplified.get(i3 * 4 + 3);
            bx = simplified.get(ii * 4 + 0);
            bz = simplified.get(ii * 4 + 2);
            bi = simplified.get(ii * 4 + 3);
            float maxd = 0.0f;
            int maxi = -1;
            if (bx > ax || bx == ax && bz > az) {
                cinc = 1;
                ci = (ai + cinc) % pn;
                endi = bi;
            } else {
                cinc = pn - 1;
                ci = (bi + cinc) % pn;
                endi = ai;
                int temp = ax;
                ax = bx;
                bx = temp;
                temp = az;
                az = bz;
                bz = temp;
            }
            if ((points.get(ci * 4 + 3) & RecastConstants.RC_CONTOUR_REG_MASK) == 0 || (points.get(ci * 4 + 3) & RecastConstants.RC_AREA_BORDER) != 0) {
                while (ci != endi) {
                    float d = RecastContour.distancePtSeg(points.get(ci * 4 + 0), points.get(ci * 4 + 2), ax, az, bx, bz);
                    if (d > maxd) {
                        maxd = d;
                        maxi = ci;
                    }
                    ci = (ci + cinc) % pn;
                }
            }
            if (maxi != -1 && maxd > maxError * maxError) {
                simplified.add((i3 + 1) * 4 + 0, points.get(maxi * 4 + 0));
                simplified.add((i3 + 1) * 4 + 1, points.get(maxi * 4 + 1));
                simplified.add((i3 + 1) * 4 + 2, points.get(maxi * 4 + 2));
                simplified.add((i3 + 1) * 4 + 3, maxi);
                continue;
            }
            ++i3;
        }
        if (maxEdgeLen > 0 && (buildFlags & (RecastConstants.RC_CONTOUR_TESS_WALL_EDGES | RecastConstants.RC_CONTOUR_TESS_AREA_EDGES)) != 0) {
            i3 = 0;
            while (i3 < simplified.size() / 4) {
                int dz;
                int dx;
                ii = (i3 + 1) % (simplified.size() / 4);
                ax = simplified.get(i3 * 4 + 0);
                az = simplified.get(i3 * 4 + 2);
                ai = simplified.get(i3 * 4 + 3);
                bx = simplified.get(ii * 4 + 0);
                bz = simplified.get(ii * 4 + 2);
                bi = simplified.get(ii * 4 + 3);
                int maxi = -1;
                int ci = (ai + 1) % pn;
                boolean tess = false;
                if ((buildFlags & RecastConstants.RC_CONTOUR_TESS_WALL_EDGES) != 0 && (points.get(ci * 4 + 3) & RecastConstants.RC_CONTOUR_REG_MASK) == 0) {
                    tess = true;
                }
                if ((buildFlags & RecastConstants.RC_CONTOUR_TESS_AREA_EDGES) != 0 && (points.get(ci * 4 + 3) & RecastConstants.RC_AREA_BORDER) != 0) {
                    tess = true;
                }
                if (tess && (dx = bx - ax) * dx + (dz = bz - az) * dz > maxEdgeLen * maxEdgeLen) {
                    int n;
                    int n2 = n = bi < ai ? bi + pn - ai : bi - ai;
                    if (n > 1) {
                        maxi = bx > ax || bx == ax && bz > az ? (ai + n / 2) % pn : (ai + (n + 1) / 2) % pn;
                    }
                }
                if (maxi != -1) {
                    simplified.add((i3 + 1) * 4 + 0, points.get(maxi * 4 + 0));
                    simplified.add((i3 + 1) * 4 + 1, points.get(maxi * 4 + 1));
                    simplified.add((i3 + 1) * 4 + 2, points.get(maxi * 4 + 2));
                    simplified.add((i3 + 1) * 4 + 3, maxi);
                    continue;
                }
                ++i3;
            }
        }
        for (i3 = 0; i3 < simplified.size() / 4; ++i3) {
            int ai2 = (simplified.get(i3 * 4 + 3) + 1) % pn;
            int bi2 = simplified.get(i3 * 4 + 3);
            simplified.set(i3 * 4 + 3, points.get(ai2 * 4 + 3) & (RecastConstants.RC_CONTOUR_REG_MASK | RecastConstants.RC_AREA_BORDER) | points.get(bi2 * 4 + 3) & RecastConstants.RC_BORDER_VERTEX);
        }
    }

    private static int calcAreaOfPolygon2D(int[] verts, int nverts) {
        int area = 0;
        int i = 0;
        int j = nverts - 1;
        while (i < nverts) {
            int vi = i * 4;
            int vj = j * 4;
            area += verts[vi + 0] * verts[vj + 2] - verts[vj + 0] * verts[vi + 2];
            j = i++;
        }
        return (area + 1) / 2;
    }

    private static boolean intersectSegCountour(int d0, int d1, int i, int n, int[] verts, int[] d0verts, int[] d1verts) {
        int[] pverts = new int[16];
        for (int g = 0; g < 4; ++g) {
            pverts[g] = d0verts[d0 + g];
            pverts[4 + g] = d1verts[d1 + g];
        }
        d0 = 0;
        d1 = 4;
        for (int k = 0; k < n; ++k) {
            int k1 = RecastMesh.next(k, n);
            if (i == k || i == k1) continue;
            int p0 = k * 4;
            int p1 = k1 * 4;
            for (int g = 0; g < 4; ++g) {
                pverts[8 + g] = verts[p0 + g];
                pverts[12 + g] = verts[p1 + g];
            }
            p0 = 8;
            p1 = 12;
            if (RecastMesh.vequal(pverts, d0, p0) || RecastMesh.vequal(pverts, d1, p0) || RecastMesh.vequal(pverts, d0, p1) || RecastMesh.vequal(pverts, d1, p1) || !RecastMesh.intersect(pverts, d0, d1, p0, p1)) continue;
            return true;
        }
        return false;
    }

    private static boolean inCone(int i, int n, int[] verts, int pj, int[] vertpj) {
        int pi = i * 4;
        int pi1 = RecastMesh.next(i, n) * 4;
        int pin1 = RecastMesh.prev(i, n) * 4;
        int[] pverts = new int[16];
        for (int g = 0; g < 4; ++g) {
            pverts[g] = verts[pi + g];
            pverts[4 + g] = verts[pi1 + g];
            pverts[8 + g] = verts[pin1 + g];
            pverts[12 + g] = vertpj[pj + g];
        }
        pi = 0;
        pi1 = 4;
        pin1 = 8;
        pj = 12;
        if (RecastMesh.leftOn(pverts, pin1, pi, pi1)) {
            return RecastMesh.left(pverts, pi, pj, pin1) && RecastMesh.left(pverts, pj, pi, pi1);
        }
        return !RecastMesh.leftOn(pverts, pi, pj, pi1) || !RecastMesh.leftOn(pverts, pj, pi, pin1);
    }

    private static void removeDegenerateSegments(List<Integer> simplified) {
        int npts = simplified.size() / 4;
        for (int i = 0; i < npts; ++i) {
            int ni = RecastMesh.next(i, npts);
            if (simplified.get(i * 4) != simplified.get(ni * 4) || simplified.get(i * 4 + 2) != simplified.get(ni * 4 + 2)) continue;
            simplified.remove(i * 4);
            simplified.remove(i * 4);
            simplified.remove(i * 4);
            simplified.remove(i * 4);
            --npts;
        }
    }

    private static void mergeContours(Contour ca, Contour cb, int ia, int ib) {
        int src;
        int dst;
        int i;
        int maxVerts = ca.nverts + cb.nverts + 2;
        int[] verts = new int[maxVerts * 4];
        int nv = 0;
        for (i = 0; i <= ca.nverts; ++i) {
            dst = nv * 4;
            src = (ia + i) % ca.nverts * 4;
            verts[dst + 0] = ca.verts[src + 0];
            verts[dst + 1] = ca.verts[src + 1];
            verts[dst + 2] = ca.verts[src + 2];
            verts[dst + 3] = ca.verts[src + 3];
            ++nv;
        }
        for (i = 0; i <= cb.nverts; ++i) {
            dst = nv * 4;
            src = (ib + i) % cb.nverts * 4;
            verts[dst + 0] = cb.verts[src + 0];
            verts[dst + 1] = cb.verts[src + 1];
            verts[dst + 2] = cb.verts[src + 2];
            verts[dst + 3] = cb.verts[src + 3];
            ++nv;
        }
        ca.verts = verts;
        ca.nverts = nv;
        cb.verts = null;
        cb.nverts = 0;
    }

    private static int[] findLeftMostVertex(Contour contour) {
        int minx = contour.verts[0];
        int minz = contour.verts[2];
        int leftmost = 0;
        for (int i = 1; i < contour.nverts; ++i) {
            int x = contour.verts[i * 4 + 0];
            int z = contour.verts[i * 4 + 2];
            if (x >= minx && (x != minx || z >= minz)) continue;
            minx = x;
            minz = z;
            leftmost = i;
        }
        return new int[]{minx, minz, leftmost};
    }

    private static void mergeRegionHoles(Telemetry ctx, ContourRegion region) {
        for (int i = 0; i < region.nholes; ++i) {
            int[] minleft = RecastContour.findLeftMostVertex(region.holes[i].contour);
            region.holes[i].minx = minleft[0];
            region.holes[i].minz = minleft[1];
            region.holes[i].leftmost = minleft[2];
        }
        Arrays.sort(region.holes, new CompareHoles());
        int maxVerts = region.outline.nverts;
        for (int i = 0; i < region.nholes; ++i) {
            maxVerts += region.holes[i].contour.nverts;
        }
        PotentialDiagonal[] diags = new PotentialDiagonal[maxVerts];
        for (int pd = 0; pd < maxVerts; ++pd) {
            diags[pd] = new PotentialDiagonal();
        }
        Contour outline = region.outline;
        for (int i = 0; i < region.nholes; ++i) {
            Contour hole = region.holes[i].contour;
            int index = -1;
            int bestVertex = region.holes[i].leftmost;
            for (int iter = 0; iter < hole.nverts; ++iter) {
                int j;
                int ndiags = 0;
                int corner = bestVertex * 4;
                for (j = 0; j < outline.nverts; ++j) {
                    if (!RecastContour.inCone(j, outline.nverts, outline.verts, corner, hole.verts)) continue;
                    int dx = outline.verts[j * 4 + 0] - hole.verts[corner + 0];
                    int dz = outline.verts[j * 4 + 2] - hole.verts[corner + 2];
                    diags[ndiags].vert = j;
                    diags[ndiags].dist = dx * dx + dz * dz;
                    ++ndiags;
                }
                Arrays.sort(diags, 0, ndiags, new CompareDiagDist());
                index = -1;
                for (j = 0; j < ndiags; ++j) {
                    int pt = diags[j].vert * 4;
                    boolean intersect = RecastContour.intersectSegCountour(pt, corner, diags[j].vert, outline.nverts, outline.verts, outline.verts, hole.verts);
                    for (int k = i; k < region.nholes && !intersect; intersect |= RecastContour.intersectSegCountour(pt, corner, -1, region.holes[k].contour.nverts, region.holes[k].contour.verts, outline.verts, hole.verts), ++k) {
                    }
                    if (intersect) continue;
                    index = diags[j].vert;
                    break;
                }
                if (index != -1) break;
                bestVertex = (bestVertex + 1) % hole.nverts;
            }
            if (index == -1) {
                ctx.warn("mergeHoles: Failed to find merge points for");
                continue;
            }
            RecastContour.mergeContours(region.outline, hole, index, bestVertex);
        }
    }

    public static ContourSet buildContours(Telemetry ctx, CompactHeightfield chf, float maxError, int maxEdgeLen, int buildFlags) {
        int w = chf.width;
        int h = chf.height;
        int borderSize = chf.borderSize;
        ContourSet cset = new ContourSet();
        ctx.startTimer("CONTOURS");
        RecastVectors.copy(cset.bmin, chf.bmin, 0);
        RecastVectors.copy(cset.bmax, chf.bmax, 0);
        if (borderSize > 0) {
            float pad = (float)borderSize * chf.cs;
            cset.bmin[0] = cset.bmin[0] + pad;
            cset.bmin[2] = cset.bmin[2] + pad;
            cset.bmax[0] = cset.bmax[0] - pad;
            cset.bmax[2] = cset.bmax[2] - pad;
        }
        cset.cs = chf.cs;
        cset.ch = chf.ch;
        cset.width = chf.width - chf.borderSize * 2;
        cset.height = chf.height - chf.borderSize * 2;
        cset.borderSize = chf.borderSize;
        cset.maxError = maxError;
        int[] flags = new int[chf.spanCount];
        ctx.startTimer("CONTOURS_TRACE");
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                CompactCell c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni; ++i) {
                    int res = 0;
                    CompactSpan s = chf.spans[i];
                    if (chf.spans[i].reg == 0 || (chf.spans[i].reg & RecastConstants.RC_BORDER_REG) != 0) {
                        flags[i] = 0;
                        continue;
                    }
                    for (int dir = 0; dir < 4; ++dir) {
                        int r = 0;
                        if (RecastCommon.GetCon(s, dir) != 63) {
                            int ax = x + RecastCommon.GetDirOffsetX(dir);
                            int ay = y + RecastCommon.GetDirOffsetY(dir);
                            int ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, dir);
                            r = chf.spans[ai].reg;
                        }
                        if (r != chf.spans[i].reg) continue;
                        res |= 1 << dir;
                    }
                    flags[i] = res ^ 0xF;
                }
            }
        }
        ctx.stopTimer("CONTOURS_TRACE");
        ArrayList<Integer> verts = new ArrayList<Integer>(256);
        ArrayList<Integer> simplified = new ArrayList<Integer>(64);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                CompactCell c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni; ++i) {
                    int j;
                    int l;
                    if (flags[i] == 0 || flags[i] == 15) {
                        flags[i] = 0;
                        continue;
                    }
                    int reg = chf.spans[i].reg;
                    if (reg == 0 || (reg & RecastConstants.RC_BORDER_REG) != 0) continue;
                    int area = chf.areas[i];
                    verts.clear();
                    simplified.clear();
                    ctx.startTimer("CONTOURS_WALK");
                    RecastContour.walkContour(x, y, i, chf, flags, verts);
                    ctx.stopTimer("CONTOURS_WALK");
                    ctx.startTimer("CONTOURS_SIMPLIFY");
                    RecastContour.simplifyContour(verts, simplified, maxError, maxEdgeLen, buildFlags);
                    RecastContour.removeDegenerateSegments(simplified);
                    ctx.stopTimer("CONTOURS_SIMPLIFY");
                    if (simplified.size() / 4 < 3) continue;
                    Contour cont = new Contour();
                    cset.conts.add(cont);
                    cont.nverts = simplified.size() / 4;
                    cont.verts = new int[simplified.size()];
                    for (l = 0; l < cont.verts.length; ++l) {
                        cont.verts[l] = (Integer)simplified.get(l);
                    }
                    if (borderSize > 0) {
                        for (j = 0; j < cont.nverts; ++j) {
                            int n = j * 4;
                            cont.verts[n] = cont.verts[n] - borderSize;
                            int n2 = j * 4 + 2;
                            cont.verts[n2] = cont.verts[n2] - borderSize;
                        }
                    }
                    cont.nrverts = verts.size() / 4;
                    cont.rverts = new int[verts.size()];
                    for (l = 0; l < cont.rverts.length; ++l) {
                        cont.rverts[l] = (Integer)verts.get(l);
                    }
                    if (borderSize > 0) {
                        for (j = 0; j < cont.nrverts; ++j) {
                            int n = j * 4;
                            cont.rverts[n] = cont.rverts[n] - borderSize;
                            int n3 = j * 4 + 2;
                            cont.rverts[n3] = cont.rverts[n3] - borderSize;
                        }
                    }
                    cont.reg = reg;
                    cont.area = area;
                }
            }
        }
        if (cset.conts.size() > 0) {
            int[] winding = new int[cset.conts.size()];
            int nholes = 0;
            for (int i = 0; i < cset.conts.size(); ++i) {
                Contour cont = cset.conts.get(i);
                int n = winding[i] = RecastContour.calcAreaOfPolygon2D(cont.verts, cont.nverts) < 0 ? -1 : 1;
                if (winding[i] >= 0) continue;
                ++nholes;
            }
            if (nholes > 0) {
                int i;
                int nregions = chf.maxRegions + 1;
                ContourRegion[] regions = new ContourRegion[nregions];
                for (i = 0; i < nregions; ++i) {
                    regions[i] = new ContourRegion();
                }
                for (i = 0; i < cset.conts.size(); ++i) {
                    Contour cont = cset.conts.get(i);
                    if (winding[i] > 0) {
                        if (regions[cont.reg].outline != null) {
                            throw new RuntimeException("rcBuildContours: Multiple outlines for region " + cont.reg + ".");
                        }
                        regions[cont.reg].outline = cont;
                        continue;
                    }
                    ++regions[cont.reg].nholes;
                }
                for (i = 0; i < nregions; ++i) {
                    if (regions[i].nholes <= 0) continue;
                    regions[i].holes = new ContourHole[regions[i].nholes];
                    for (int nh = 0; nh < regions[i].nholes; ++nh) {
                        regions[i].holes[nh] = new ContourHole();
                    }
                    regions[i].nholes = 0;
                }
                for (i = 0; i < cset.conts.size(); ++i) {
                    Contour cont = cset.conts.get(i);
                    ContourRegion reg = regions[cont.reg];
                    if (winding[i] >= 0) continue;
                    ++reg.nholes;
                    reg.holes[reg.nholes].contour = cont;
                }
                for (i = 0; i < nregions; ++i) {
                    ContourRegion reg = regions[i];
                    if (reg.nholes == 0) continue;
                    if (reg.outline != null) {
                        RecastContour.mergeRegionHoles(ctx, reg);
                        continue;
                    }
                    throw new RuntimeException("rcBuildContours: Bad outline for region " + i + ", contour simplification is likely too aggressive.");
                }
            }
        }
        ctx.stopTimer("CONTOURS");
        return cset;
    }

    private static class CornerHeight {
        public final int height;
        public final boolean borderVertex;

        public CornerHeight(int height, boolean borderVertex) {
            this.height = height;
            this.borderVertex = borderVertex;
        }
    }

    private static class ContourRegion {
        public Contour outline;
        public ContourHole[] holes;
        public int nholes;

        private ContourRegion() {
        }
    }

    private static class ContourHole {
        public int leftmost;
        public int minx;
        public int minz;
        public Contour contour;

        private ContourHole() {
        }
    }

    private static class CompareHoles
    implements Comparator<ContourHole> {
        private CompareHoles() {
        }

        @Override
        public int compare(ContourHole a, ContourHole b) {
            if (a.minx == b.minx) {
                return Integer.compare(a.minz, b.minz);
            }
            return Integer.compare(a.minx, b.minx);
        }
    }

    private static class PotentialDiagonal {
        public int dist;
        public int vert;

        private PotentialDiagonal() {
        }
    }

    private static class CompareDiagDist
    implements Comparator<PotentialDiagonal> {
        private CompareDiagDist() {
        }

        @Override
        public int compare(PotentialDiagonal va, PotentialDiagonal vb) {
            PotentialDiagonal a = va;
            PotentialDiagonal b = vb;
            return Integer.compare(a.dist, b.dist);
        }
    }
}

