/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.function.Function;
import org.recast4j.recast.Heightfield;
import org.recast4j.recast.RecastCommon;
import org.recast4j.recast.RecastConstants;
import org.recast4j.recast.RecastRasterization;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.Telemetry;

public class RecastFilledVolumeRasterization {
    private static final float EPSILON = 1.0E-5f;
    private static final int[] BOX_EDGES = new int[]{0, 1, 0, 2, 0, 4, 1, 3, 1, 5, 2, 3, 2, 6, 3, 7, 4, 5, 4, 6, 5, 7, 6, 7};

    public static void rasterizeSphere(Heightfield hf, float[] center, float radius, int area, int flagMergeThr, Telemetry ctx) {
        ctx.startTimer("RASTERIZE_SPHERE");
        float[] bounds = new float[]{center[0] - radius, center[1] - radius, center[2] - radius, center[0] + radius, center[1] + radius, center[2] + radius};
        RecastFilledVolumeRasterization.rasterizationFilledShape(hf, bounds, area, flagMergeThr, rectangle -> RecastFilledVolumeRasterization.intersectSphere(rectangle, center, radius * radius));
        ctx.stopTimer("RASTERIZE_SPHERE");
    }

    public static void rasterizeCapsule(Heightfield hf, float[] start, float[] end, float radius, int area, int flagMergeThr, Telemetry ctx) {
        ctx.startTimer("RASTERIZE_CAPSULE");
        float[] bounds = new float[]{Math.min(start[0], end[0]) - radius, Math.min(start[1], end[1]) - radius, Math.min(start[2], end[2]) - radius, Math.max(start[0], end[0]) + radius, Math.max(start[1], end[1]) + radius, Math.max(start[2], end[2]) + radius};
        float[] axis = new float[]{end[0] - start[0], end[1] - start[1], end[2] - start[2]};
        RecastFilledVolumeRasterization.rasterizationFilledShape(hf, bounds, area, flagMergeThr, rectangle -> RecastFilledVolumeRasterization.intersectCapsule(rectangle, start, end, axis, radius * radius));
        ctx.stopTimer("RASTERIZE_CAPSULE");
    }

    public static void rasterizeCylinder(Heightfield hf, float[] start, float[] end, float radius, int area, int flagMergeThr, Telemetry ctx) {
        ctx.startTimer("RASTERIZE_CYLINDER");
        float[] bounds = new float[]{Math.min(start[0], end[0]) - radius, Math.min(start[1], end[1]) - radius, Math.min(start[2], end[2]) - radius, Math.max(start[0], end[0]) + radius, Math.max(start[1], end[1]) + radius, Math.max(start[2], end[2]) + radius};
        float[] axis = new float[]{end[0] - start[0], end[1] - start[1], end[2] - start[2]};
        RecastFilledVolumeRasterization.rasterizationFilledShape(hf, bounds, area, flagMergeThr, rectangle -> RecastFilledVolumeRasterization.intersectCylinder(rectangle, start, end, axis, radius * radius));
        ctx.stopTimer("RASTERIZE_CYLINDER");
    }

    public static void rasterizeBox(Heightfield hf, float[] center, float[][] halfEdges, int area, int flagMergeThr, Telemetry ctx) {
        ctx.startTimer("RASTERIZE_BOX");
        float[][] normals = new float[][]{{halfEdges[0][0], halfEdges[0][1], halfEdges[0][2]}, {halfEdges[1][0], halfEdges[1][1], halfEdges[1][2]}, {halfEdges[2][0], halfEdges[2][1], halfEdges[2][2]}};
        RecastVectors.normalize(normals[0]);
        RecastVectors.normalize(normals[1]);
        RecastVectors.normalize(normals[2]);
        float[] vertices = new float[24];
        float[] bounds = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (int i = 0; i < 8; ++i) {
            float s0 = (i & 1) != 0 ? 1.0f : -1.0f;
            float s1 = (i & 2) != 0 ? 1.0f : -1.0f;
            float s2 = (i & 4) != 0 ? 1.0f : -1.0f;
            vertices[i * 3 + 0] = center[0] + s0 * halfEdges[0][0] + s1 * halfEdges[1][0] + s2 * halfEdges[2][0];
            vertices[i * 3 + 1] = center[1] + s0 * halfEdges[0][1] + s1 * halfEdges[1][1] + s2 * halfEdges[2][1];
            vertices[i * 3 + 2] = center[2] + s0 * halfEdges[0][2] + s1 * halfEdges[1][2] + s2 * halfEdges[2][2];
            bounds[0] = Math.min(bounds[0], vertices[i * 3 + 0]);
            bounds[1] = Math.min(bounds[1], vertices[i * 3 + 1]);
            bounds[2] = Math.min(bounds[2], vertices[i * 3 + 2]);
            bounds[3] = Math.max(bounds[3], vertices[i * 3 + 0]);
            bounds[4] = Math.max(bounds[4], vertices[i * 3 + 1]);
            bounds[5] = Math.max(bounds[5], vertices[i * 3 + 2]);
        }
        float[][] planes = new float[6][4];
        for (int i = 0; i < 6; ++i) {
            float m = i < 3 ? -1.0f : 1.0f;
            int vi = i < 3 ? 0 : 7;
            planes[i][0] = m * normals[i % 3][0];
            planes[i][1] = m * normals[i % 3][1];
            planes[i][2] = m * normals[i % 3][2];
            planes[i][3] = vertices[vi * 3] * planes[i][0] + vertices[vi * 3 + 1] * planes[i][1] + vertices[vi * 3 + 2] * planes[i][2];
        }
        RecastFilledVolumeRasterization.rasterizationFilledShape(hf, bounds, area, flagMergeThr, rectangle -> RecastFilledVolumeRasterization.intersectBox(rectangle, vertices, planes));
        ctx.stopTimer("RASTERIZE_BOX");
    }

    public static void rasterizeConvex(Heightfield hf, float[] vertices, int[] triangles, int area, int flagMergeThr, Telemetry ctx) {
        ctx.startTimer("RASTERIZE_CONVEX");
        float[] bounds = new float[]{vertices[0], vertices[1], vertices[2], vertices[0], vertices[1], vertices[2]};
        for (int i = 0; i < vertices.length; i += 3) {
            bounds[0] = Math.min(bounds[0], vertices[i + 0]);
            bounds[1] = Math.min(bounds[1], vertices[i + 1]);
            bounds[2] = Math.min(bounds[2], vertices[i + 2]);
            bounds[3] = Math.max(bounds[3], vertices[i + 0]);
            bounds[4] = Math.max(bounds[4], vertices[i + 1]);
            bounds[5] = Math.max(bounds[5], vertices[i + 2]);
        }
        float[][] planes = new float[triangles.length][4];
        float[][] triBounds = new float[triangles.length / 3][4];
        int i = 0;
        int j = 0;
        while (i < triangles.length) {
            int a = triangles[i] * 3;
            int b = triangles[i + 1] * 3;
            int c = triangles[i + 2] * 3;
            float[] ab = new float[]{vertices[b] - vertices[a], vertices[b + 1] - vertices[a + 1], vertices[b + 2] - vertices[a + 2]};
            float[] ac = new float[]{vertices[c] - vertices[a], vertices[c + 1] - vertices[a + 1], vertices[c + 2] - vertices[a + 2]};
            float[] bc = new float[]{vertices[c] - vertices[b], vertices[c + 1] - vertices[b + 1], vertices[c + 2] - vertices[b + 2]};
            float[] ca = new float[]{vertices[a] - vertices[c], vertices[a + 1] - vertices[c + 1], vertices[a + 2] - vertices[c + 2]};
            RecastFilledVolumeRasterization.plane(planes, i, ab, ac, vertices, a);
            RecastFilledVolumeRasterization.plane(planes, i + 1, planes[i], bc, vertices, b);
            RecastFilledVolumeRasterization.plane(planes, i + 2, planes[i], ca, vertices, c);
            float s = 1.0f / (vertices[a] * planes[i + 1][0] + vertices[a + 1] * planes[i + 1][1] + vertices[a + 2] * planes[i + 1][2] - planes[i + 1][3]);
            float[] fArray = planes[i + 1];
            fArray[0] = fArray[0] * s;
            float[] fArray2 = planes[i + 1];
            fArray2[1] = fArray2[1] * s;
            float[] fArray3 = planes[i + 1];
            fArray3[2] = fArray3[2] * s;
            float[] fArray4 = planes[i + 1];
            fArray4[3] = fArray4[3] * s;
            s = 1.0f / (vertices[b] * planes[i + 2][0] + vertices[b + 1] * planes[i + 2][1] + vertices[b + 2] * planes[i + 2][2] - planes[i + 2][3]);
            float[] fArray5 = planes[i + 2];
            fArray5[0] = fArray5[0] * s;
            float[] fArray6 = planes[i + 2];
            fArray6[1] = fArray6[1] * s;
            float[] fArray7 = planes[i + 2];
            fArray7[2] = fArray7[2] * s;
            float[] fArray8 = planes[i + 2];
            fArray8[3] = fArray8[3] * s;
            triBounds[j][0] = Math.min(Math.min(vertices[a], vertices[b]), vertices[c]);
            triBounds[j][1] = Math.min(Math.min(vertices[a + 2], vertices[b + 2]), vertices[c + 2]);
            triBounds[j][2] = Math.max(Math.max(vertices[a], vertices[b]), vertices[c]);
            triBounds[j][3] = Math.max(Math.max(vertices[a + 2], vertices[b + 2]), vertices[c + 2]);
            i += 3;
            ++j;
        }
        RecastFilledVolumeRasterization.rasterizationFilledShape(hf, bounds, area, flagMergeThr, rectangle -> RecastFilledVolumeRasterization.intersectConvex(rectangle, triangles, vertices, planes, triBounds));
        ctx.stopTimer("RASTERIZE_CONVEX");
    }

    private static void plane(float[][] planes, int p, float[] v1, float[] v2, float[] vertices, int vert) {
        RecastVectors.cross(planes[p], v1, v2);
        planes[p][3] = planes[p][0] * vertices[vert] + planes[p][1] * vertices[vert + 1] + planes[p][2] * vertices[vert + 2];
    }

    private static void rasterizationFilledShape(Heightfield hf, float[] bounds, int area, int flagMergeThr, Function<float[], float[]> intersection) {
        if (!RecastFilledVolumeRasterization.overlapBounds(hf.bmin, hf.bmax, bounds)) {
            return;
        }
        bounds[3] = Math.min(bounds[3], hf.bmax[0]);
        bounds[5] = Math.min(bounds[5], hf.bmax[2]);
        bounds[0] = Math.max(bounds[0], hf.bmin[0]);
        bounds[2] = Math.max(bounds[2], hf.bmin[2]);
        if (bounds[3] <= bounds[0] || bounds[4] <= bounds[1] || bounds[5] <= bounds[2]) {
            return;
        }
        float ics = 1.0f / hf.cs;
        float ich = 1.0f / hf.ch;
        int xMin = (int)((bounds[0] - hf.bmin[0]) * ics);
        int zMin = (int)((bounds[2] - hf.bmin[2]) * ics);
        int xMax = Math.min(hf.width - 1, (int)((bounds[3] - hf.bmin[0]) * ics));
        int zMax = Math.min(hf.height - 1, (int)((bounds[5] - hf.bmin[2]) * ics));
        float[] rectangle = new float[5];
        rectangle[4] = hf.bmin[1];
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                int smax;
                int smin;
                rectangle[0] = (float)x * hf.cs + hf.bmin[0];
                rectangle[1] = (float)z * hf.cs + hf.bmin[2];
                rectangle[2] = rectangle[0] + hf.cs;
                rectangle[3] = rectangle[1] + hf.cs;
                float[] h = intersection.apply(rectangle);
                if (h == null || (smin = (int)Math.floor((h[0] - hf.bmin[1]) * ich)) == (smax = (int)Math.ceil((h[1] - hf.bmin[1]) * ich))) continue;
                int ismin = RecastCommon.clamp(smin, 0, RecastConstants.SPAN_MAX_HEIGHT);
                int ismax = RecastCommon.clamp(smax, ismin + 1, RecastConstants.SPAN_MAX_HEIGHT);
                RecastRasterization.addSpan(hf, x, z, ismin, ismax, area, flagMergeThr);
            }
        }
    }

    private static float[] intersectSphere(float[] rectangle, float[] center, float radiusSqr) {
        float x = Math.max(rectangle[0], Math.min(center[0], rectangle[2]));
        float y = rectangle[4];
        float z = Math.max(rectangle[1], Math.min(center[2], rectangle[3]));
        float mx = x - center[0];
        float my = y - center[1];
        float mz = z - center[2];
        float b = my;
        float c = RecastFilledVolumeRasterization.lenSqr(mx, my, mz) - radiusSqr;
        if (c > 0.0f && b > 0.0f) {
            return null;
        }
        float discr = b * b - c;
        if (discr < 0.0f) {
            return null;
        }
        float discrSqrt = (float)Math.sqrt(discr);
        float tmin = -b - discrSqrt;
        float tmax = -b + discrSqrt;
        if (tmin < 0.0f) {
            tmin = 0.0f;
        }
        return new float[]{y + tmin, y + tmax};
    }

    private static float[] intersectCapsule(float[] rectangle, float[] start, float[] end, float[] axis, float radiusSqr) {
        float[] s = RecastFilledVolumeRasterization.mergeIntersections(RecastFilledVolumeRasterization.intersectSphere(rectangle, start, radiusSqr), RecastFilledVolumeRasterization.intersectSphere(rectangle, end, radiusSqr));
        float axisLen2dSqr = axis[0] * axis[0] + axis[2] * axis[2];
        if (axisLen2dSqr > 1.0E-5f) {
            s = RecastFilledVolumeRasterization.slabsCylinderIntersection(rectangle, start, end, axis, radiusSqr, s);
        }
        return s;
    }

    private static float[] intersectCylinder(float[] rectangle, float[] start, float[] end, float[] axis, float radiusSqr) {
        float[] s = RecastFilledVolumeRasterization.mergeIntersections(RecastFilledVolumeRasterization.rayCylinderIntersection(new float[]{RecastFilledVolumeRasterization.clamp(start[0], rectangle[0], rectangle[2]), rectangle[4], RecastFilledVolumeRasterization.clamp(start[2], rectangle[1], rectangle[3])}, start, axis, radiusSqr), RecastFilledVolumeRasterization.rayCylinderIntersection(new float[]{RecastFilledVolumeRasterization.clamp(end[0], rectangle[0], rectangle[2]), rectangle[4], RecastFilledVolumeRasterization.clamp(end[2], rectangle[1], rectangle[3])}, start, axis, radiusSqr));
        float axisLen2dSqr = axis[0] * axis[0] + axis[2] * axis[2];
        if (axisLen2dSqr > 1.0E-5f) {
            s = RecastFilledVolumeRasterization.slabsCylinderIntersection(rectangle, start, end, axis, radiusSqr, s);
        }
        if (axis[1] * axis[1] > 1.0E-5f) {
            int i;
            float[][] rectangleOnStartPlane = new float[4][3];
            float[][] rectangleOnEndPlane = new float[4][3];
            float ds = RecastVectors.dot(axis, start);
            float de = RecastVectors.dot(axis, end);
            for (i = 0; i < 4; ++i) {
                float x = rectangle[i + 1 & 2];
                float z = rectangle[(i & 2) + 1];
                float[] a = new float[]{x, rectangle[4], z};
                float dotAxisA = RecastVectors.dot(axis, a);
                float t = (ds - dotAxisA) / axis[1];
                rectangleOnStartPlane[i][0] = x;
                rectangleOnStartPlane[i][1] = rectangle[4] + t;
                rectangleOnStartPlane[i][2] = z;
                t = (de - dotAxisA) / axis[1];
                rectangleOnEndPlane[i][0] = x;
                rectangleOnEndPlane[i][1] = rectangle[4] + t;
                rectangleOnEndPlane[i][2] = z;
            }
            for (i = 0; i < 4; ++i) {
                s = RecastFilledVolumeRasterization.cylinderCapIntersection(start, radiusSqr, s, i, rectangleOnStartPlane);
                s = RecastFilledVolumeRasterization.cylinderCapIntersection(end, radiusSqr, s, i, rectangleOnEndPlane);
            }
        }
        return s;
    }

    private static float[] cylinderCapIntersection(float[] start, float radiusSqr, float[] s, int i, float[][] rectangleOnPlane) {
        float c;
        int j = (i + 1) % 4;
        float[] m = new float[]{rectangleOnPlane[i][0] - start[0], rectangleOnPlane[i][1] - start[1], rectangleOnPlane[i][2] - start[2]};
        float[] d = new float[]{rectangleOnPlane[j][0] - rectangleOnPlane[i][0], rectangleOnPlane[j][1] - rectangleOnPlane[i][1], rectangleOnPlane[j][2] - rectangleOnPlane[i][2]};
        float dl = RecastVectors.dot(d, d);
        float b = RecastVectors.dot(m, d) / dl;
        float discr = b * b - (c = (RecastVectors.dot(m, m) - radiusSqr) / dl);
        if (discr > 1.0E-5f) {
            float discrSqrt = (float)Math.sqrt(discr);
            float t1 = -b - discrSqrt;
            float t2 = -b + discrSqrt;
            if (t1 <= 1.0f && t2 >= 0.0f) {
                t1 = Math.max(0.0f, t1);
                t2 = Math.min(1.0f, t2);
                float y1 = rectangleOnPlane[i][1] + t1 * d[1];
                float y2 = rectangleOnPlane[i][1] + t2 * d[1];
                float[] y = new float[]{Math.min(y1, y2), Math.max(y1, y2)};
                s = RecastFilledVolumeRasterization.mergeIntersections(s, y);
            }
        }
        return s;
    }

    private static float[] slabsCylinderIntersection(float[] rectangle, float[] start, float[] end, float[] axis, float radiusSqr, float[] s) {
        if (Math.min(start[0], end[0]) < rectangle[0]) {
            s = RecastFilledVolumeRasterization.mergeIntersections(s, RecastFilledVolumeRasterization.xSlabCylinderIntersection(rectangle, start, axis, radiusSqr, rectangle[0]));
        }
        if (Math.max(start[0], end[0]) > rectangle[2]) {
            s = RecastFilledVolumeRasterization.mergeIntersections(s, RecastFilledVolumeRasterization.xSlabCylinderIntersection(rectangle, start, axis, radiusSqr, rectangle[2]));
        }
        if (Math.min(start[2], end[2]) < rectangle[1]) {
            s = RecastFilledVolumeRasterization.mergeIntersections(s, RecastFilledVolumeRasterization.zSlabCylinderIntersection(rectangle, start, axis, radiusSqr, rectangle[1]));
        }
        if (Math.max(start[2], end[2]) > rectangle[3]) {
            s = RecastFilledVolumeRasterization.mergeIntersections(s, RecastFilledVolumeRasterization.zSlabCylinderIntersection(rectangle, start, axis, radiusSqr, rectangle[3]));
        }
        return s;
    }

    private static float[] xSlabCylinderIntersection(float[] rectangle, float[] start, float[] axis, float radiusSqr, float x) {
        return RecastFilledVolumeRasterization.rayCylinderIntersection(RecastFilledVolumeRasterization.xSlabRayIntersection(rectangle, start, axis, x), start, axis, radiusSqr);
    }

    private static float[] xSlabRayIntersection(float[] rectangle, float[] start, float[] direction, float x) {
        float t = (x - start[0]) / direction[0];
        float z = RecastFilledVolumeRasterization.clamp(start[2] + t * direction[2], rectangle[1], rectangle[3]);
        return new float[]{x, rectangle[4], z};
    }

    private static float[] zSlabCylinderIntersection(float[] rectangle, float[] start, float[] axis, float radiusSqr, float z) {
        return RecastFilledVolumeRasterization.rayCylinderIntersection(RecastFilledVolumeRasterization.zSlabRayIntersection(rectangle, start, axis, z), start, axis, radiusSqr);
    }

    private static float[] zSlabRayIntersection(float[] rectangle, float[] start, float[] direction, float z) {
        float t = (z - start[2]) / direction[2];
        float x = RecastFilledVolumeRasterization.clamp(start[0] + t * direction[0], rectangle[0], rectangle[2]);
        return new float[]{x, rectangle[4], z};
    }

    private static float[] rayCylinderIntersection(float[] point, float[] start, float[] axis, float radiusSqr) {
        float[] d = axis;
        float[] m = new float[]{point[0] - start[0], point[1] - start[1], point[2] - start[2]};
        float md = RecastVectors.dot(m, d);
        float nd = axis[1];
        float dd = RecastVectors.dot(d, d);
        float nn = 1.0f;
        float mn = m[1];
        float a = dd - nd * nd;
        float k = RecastVectors.dot(m, m) - radiusSqr;
        float c = dd * k - md * md;
        if (Math.abs(a) < 1.0E-5f) {
            if (c > 0.0f) {
                return null;
            }
            float t1 = -mn / nn;
            float t2 = (nd - mn) / nn;
            return new float[]{point[1] + Math.min(t1, t2), point[1] + Math.max(t1, t2)};
        }
        float b = dd * mn - nd * md;
        float discr = b * b - a * c;
        if (discr < 0.0f) {
            return null;
        }
        float discSqrt = (float)Math.sqrt(discr);
        float t1 = (-b - discSqrt) / a;
        float t2 = (-b + discSqrt) / a;
        if (md + t1 * nd < 0.0f ? k + (t1 = -md / nd) * (2.0f * mn + t1 * nn) > 0.0f : md + t1 * nd > dd && k + dd - 2.0f * md + (t1 = (dd - md) / nd) * (2.0f * (mn - nd) + t1 * nn) > 0.0f) {
            return null;
        }
        if (md + t2 * nd < 0.0f ? k + (t2 = -md / nd) * (2.0f * mn + t2 * nn) > 0.0f : md + t2 * nd > dd && k + dd - 2.0f * md + (t2 = (dd - md) / nd) * (2.0f * (mn - nd) + t2 * nn) > 0.0f) {
            return null;
        }
        return new float[]{point[1] + Math.min(t1, t2), point[1] + Math.max(t1, t2)};
    }

    private static float[] intersectBox(float[] rectangle, float[] vertices, float[][] planes) {
        int i;
        float yMin = Float.POSITIVE_INFINITY;
        float yMax = Float.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < 8; ++i2) {
            int vi = i2 * 3;
            if (!(vertices[vi] >= rectangle[0]) || !(vertices[vi] < rectangle[2]) || !(vertices[vi + 2] >= rectangle[1]) || !(vertices[vi + 2] < rectangle[3])) continue;
            yMin = Math.min(yMin, vertices[vi + 1]);
            yMax = Math.max(yMax, vertices[vi + 1]);
        }
        float[] point = new float[]{0.0f, rectangle[1], 0.0f};
        for (i = 0; i < 4; ++i) {
            point[0] = (i & 1) == 0 ? rectangle[0] : rectangle[2];
            point[2] = (i & 2) == 0 ? rectangle[1] : rectangle[3];
            for (int j = 0; j < 6; ++j) {
                if (!(Math.abs(planes[j][1]) > 1.0E-5f)) continue;
                float dotNormalPoint = RecastVectors.dot(planes[j], point);
                float t = (planes[j][3] - dotNormalPoint) / planes[j][1];
                float y = point[1] + t;
                boolean valid = true;
                for (int k = 0; k < 6; ++k) {
                    if (k == j || !(point[0] * planes[k][0] + y * planes[k][1] + point[2] * planes[k][2] > planes[k][3])) continue;
                    valid = false;
                    break;
                }
                if (!valid) continue;
                yMin = Math.min(yMin, y);
                yMax = Math.max(yMax, y);
            }
        }
        for (i = 0; i < BOX_EDGES.length; i += 2) {
            Float iy;
            int vi = BOX_EDGES[i] * 3;
            int vj = BOX_EDGES[i + 1] * 3;
            float x = vertices[vi];
            float z = vertices[vi + 2];
            float y = vertices[vi + 1];
            float dx = vertices[vj] - x;
            float dy = vertices[vj + 1] - y;
            float dz = vertices[vj + 2] - z;
            if (Math.abs(dx) > 1.0E-5f) {
                iy = RecastFilledVolumeRasterization.xSlabSegmentIntersection(rectangle, x, y, z, dx, dy, dz, rectangle[0]);
                if (iy != null) {
                    yMin = Math.min(yMin, iy.floatValue());
                    yMax = Math.max(yMax, iy.floatValue());
                }
                if ((iy = RecastFilledVolumeRasterization.xSlabSegmentIntersection(rectangle, x, y, z, dx, dy, dz, rectangle[2])) != null) {
                    yMin = Math.min(yMin, iy.floatValue());
                    yMax = Math.max(yMax, iy.floatValue());
                }
            }
            if (!(Math.abs(dz) > 1.0E-5f)) continue;
            iy = RecastFilledVolumeRasterization.zSlabSegmentIntersection(rectangle, x, y, z, dx, dy, dz, rectangle[1]);
            if (iy != null) {
                yMin = Math.min(yMin, iy.floatValue());
                yMax = Math.max(yMax, iy.floatValue());
            }
            if ((iy = RecastFilledVolumeRasterization.zSlabSegmentIntersection(rectangle, x, y, z, dx, dy, dz, rectangle[3])) == null) continue;
            yMin = Math.min(yMin, iy.floatValue());
            yMax = Math.max(yMax, iy.floatValue());
        }
        if (yMin <= yMax) {
            return new float[]{yMin, yMax};
        }
        return null;
    }

    private static float[] intersectConvex(float[] rectangle, int[] triangles, float[] verts, float[][] planes, float[][] triBounds) {
        float imin = Float.POSITIVE_INFINITY;
        float imax = Float.NEGATIVE_INFINITY;
        int tr = 0;
        for (int tri = 0; tri < triangles.length; tri += 3) {
            if (!(triBounds[tr][0] > rectangle[2] || triBounds[tr][2] < rectangle[0] || triBounds[tr][1] > rectangle[3] || triBounds[tr][3] < rectangle[1] || Math.abs(planes[tri][1]) < 1.0E-5f)) {
                for (int i = 0; i < 3; ++i) {
                    Float iy;
                    int vi = triangles[tri + i] * 3;
                    int vj = triangles[tri + (i + 1) % 3] * 3;
                    float x = verts[vi];
                    float z = verts[vi + 2];
                    if (x >= rectangle[0] && x <= rectangle[2] && z >= rectangle[1] && z <= rectangle[3]) {
                        imin = Math.min(imin, verts[vi + 1]);
                        imax = Math.max(imax, verts[vi + 1]);
                    }
                    float y = verts[vi + 1];
                    float dx = verts[vj] - x;
                    float dy = verts[vj + 1] - y;
                    float dz = verts[vj + 2] - z;
                    if (Math.abs(dx) > 1.0E-5f) {
                        iy = RecastFilledVolumeRasterization.xSlabSegmentIntersection(rectangle, x, y, z, dx, dy, dz, rectangle[0]);
                        if (iy != null) {
                            imin = Math.min(imin, iy.floatValue());
                            imax = Math.max(imax, iy.floatValue());
                        }
                        if ((iy = RecastFilledVolumeRasterization.xSlabSegmentIntersection(rectangle, x, y, z, dx, dy, dz, rectangle[2])) != null) {
                            imin = Math.min(imin, iy.floatValue());
                            imax = Math.max(imax, iy.floatValue());
                        }
                    }
                    if (!(Math.abs(dz) > 1.0E-5f)) continue;
                    iy = RecastFilledVolumeRasterization.zSlabSegmentIntersection(rectangle, x, y, z, dx, dy, dz, rectangle[1]);
                    if (iy != null) {
                        imin = Math.min(imin, iy.floatValue());
                        imax = Math.max(imax, iy.floatValue());
                    }
                    if ((iy = RecastFilledVolumeRasterization.zSlabSegmentIntersection(rectangle, x, y, z, dx, dy, dz, rectangle[3])) == null) continue;
                    imin = Math.min(imin, iy.floatValue());
                    imax = Math.max(imax, iy.floatValue());
                }
                float[] point = new float[]{0.0f, rectangle[1], 0.0f};
                for (int i = 0; i < 4; ++i) {
                    point[0] = (i & 1) == 0 ? rectangle[0] : rectangle[2];
                    point[2] = (i & 2) == 0 ? rectangle[1] : rectangle[3];
                    Float y = RecastFilledVolumeRasterization.rayTriangleIntersection(point, tri, planes);
                    if (y == null) continue;
                    imin = Math.min(imin, y.floatValue());
                    imax = Math.max(imax, y.floatValue());
                }
            }
            ++tr;
        }
        if (imin < imax) {
            return new float[]{imin, imax};
        }
        return null;
    }

    private static Float xSlabSegmentIntersection(float[] rectangle, float x, float y, float z, float dx, float dy, float dz, float slabX) {
        float t;
        float iz;
        float x2 = x + dx;
        if ((x < slabX && x2 > slabX || x > slabX && x2 < slabX) && (iz = z + dz * (t = (slabX - x) / dx)) >= rectangle[1] && iz <= rectangle[3]) {
            return Float.valueOf(y + dy * t);
        }
        return null;
    }

    private static Float zSlabSegmentIntersection(float[] rectangle, float x, float y, float z, float dx, float dy, float dz, float slabZ) {
        float t;
        float ix;
        float z2 = z + dz;
        if ((z < slabZ && z2 > slabZ || z > slabZ && z2 < slabZ) && (ix = x + dx * (t = (slabZ - z) / dz)) >= rectangle[0] && ix <= rectangle[2]) {
            return Float.valueOf(y + dy * t);
        }
        return null;
    }

    private static Float rayTriangleIntersection(float[] point, int plane, float[][] planes) {
        float t = (planes[plane][3] - RecastVectors.dot(planes[plane], point)) / planes[plane][1];
        float[] s = new float[]{point[0], point[1] + t, point[2]};
        float u = RecastVectors.dot(s, planes[plane + 1]) - planes[plane + 1][3];
        if (u < 0.0f || u > 1.0f) {
            return null;
        }
        float v = RecastVectors.dot(s, planes[plane + 2]) - planes[plane + 2][3];
        if (v < 0.0f) {
            return null;
        }
        float w = 1.0f - u - v;
        if (w < 0.0f) {
            return null;
        }
        return Float.valueOf(s[1]);
    }

    private static float[] mergeIntersections(float[] s1, float[] s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return new float[]{Math.min(s1[0], s2[0]), Math.max(s1[1], s2[1])};
    }

    private static float lenSqr(float dx, float dy, float dz) {
        return dx * dx + dy * dy + dz * dz;
    }

    public static float clamp(float v, float min, float max) {
        return Math.max(Math.min(max, v), min);
    }

    private static boolean overlapBounds(float[] amin, float[] amax, float[] bounds) {
        boolean overlap = true;
        overlap = amin[0] > bounds[3] || amax[0] < bounds[0] ? false : overlap;
        overlap = amin[1] > bounds[4] ? false : overlap;
        overlap = amin[2] > bounds[5] || amax[2] < bounds[2] ? false : overlap;
        return overlap;
    }
}

