/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import org.recast4j.recast.Heightfield;
import org.recast4j.recast.RecastCommon;
import org.recast4j.recast.RecastConstants;
import org.recast4j.recast.Span;
import org.recast4j.recast.Telemetry;

public class RecastFilter {
    public static void filterLowHangingWalkableObstacles(Telemetry ctx, int walkableClimb, Heightfield solid) {
        ctx.startTimer("FILTER_LOW_OBSTACLES");
        int w = solid.width;
        int h = solid.height;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Span ps = null;
                boolean previousWalkable = false;
                int previousArea = 0;
                Span s = solid.spans[x + y * w];
                while (s != null) {
                    boolean walkable;
                    boolean bl = walkable = s.area != 0;
                    if (!walkable && previousWalkable && Math.abs(s.smax - ps.smax) <= walkableClimb) {
                        s.area = previousArea;
                    }
                    previousWalkable = walkable;
                    previousArea = s.area;
                    ps = s;
                    s = s.next;
                }
            }
        }
        ctx.stopTimer("FILTER_LOW_OBSTACLES");
    }

    public static void filterLedgeSpans(Telemetry ctx, int walkableHeight, int walkableClimb, Heightfield solid) {
        ctx.startTimer("FILTER_LEDGE");
        int w = solid.width;
        int h = solid.height;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Span s = solid.spans[x + y * w];
                while (s != null) {
                    if (s.area != 0) {
                        int bot = s.smax;
                        int top = s.next != null ? s.next.smin : RecastConstants.SPAN_MAX_HEIGHT;
                        int minh = RecastConstants.SPAN_MAX_HEIGHT;
                        int asmin = s.smax;
                        int asmax = s.smax;
                        for (int dir = 0; dir < 4; ++dir) {
                            int ntop;
                            int dx = x + RecastCommon.GetDirOffsetX(dir);
                            int dy = y + RecastCommon.GetDirOffsetY(dir);
                            if (dx < 0 || dy < 0 || dx >= w || dy >= h) {
                                minh = Math.min(minh, -walkableClimb - bot);
                                continue;
                            }
                            Span ns = solid.spans[dx + dy * w];
                            int nbot = -walkableClimb;
                            int n = ntop = ns != null ? ns.smin : RecastConstants.SPAN_MAX_HEIGHT;
                            if (Math.min(top, ntop) - Math.max(bot, nbot) > walkableHeight) {
                                minh = Math.min(minh, nbot - bot);
                            }
                            ns = solid.spans[dx + dy * w];
                            while (ns != null) {
                                nbot = ns.smax;
                                int n2 = ntop = ns.next != null ? ns.next.smin : RecastConstants.SPAN_MAX_HEIGHT;
                                if (Math.min(top, ntop) - Math.max(bot, nbot) > walkableHeight) {
                                    minh = Math.min(minh, nbot - bot);
                                    if (Math.abs(nbot - bot) <= walkableClimb) {
                                        if (nbot < asmin) {
                                            asmin = nbot;
                                        }
                                        if (nbot > asmax) {
                                            asmax = nbot;
                                        }
                                    }
                                }
                                ns = ns.next;
                            }
                        }
                        if (minh < -walkableClimb) {
                            s.area = 0;
                        }
                        if (asmax - asmin > walkableClimb) {
                            s.area = 0;
                        }
                    }
                    s = s.next;
                }
            }
        }
        ctx.stopTimer("FILTER_LEDGE");
    }

    public static void filterWalkableLowHeightSpans(Telemetry ctx, int walkableHeight, Heightfield solid) {
        ctx.startTimer("FILTER_WALKABLE");
        int w = solid.width;
        int h = solid.height;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Span s = solid.spans[x + y * w];
                while (s != null) {
                    int top;
                    int bot = s.smax;
                    int n = top = s.next != null ? s.next.smin : RecastConstants.SPAN_MAX_HEIGHT;
                    if (top - bot < walkableHeight) {
                        s.area = 0;
                    }
                    s = s.next;
                }
            }
        }
        ctx.stopTimer("FILTER_WALKABLE");
    }
}

