/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.recast4j.recast.CompactCell;
import org.recast4j.recast.CompactHeightfield;
import org.recast4j.recast.CompactSpan;
import org.recast4j.recast.HeightfieldLayerSet;
import org.recast4j.recast.RecastCommon;
import org.recast4j.recast.RecastRegion;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.Telemetry;

public class RecastLayers {
    static final int RC_MAX_LAYERS = 63;
    static final int RC_MAX_NEIS = 16;

    private static void addUnique(List<Integer> a, int v) {
        if (!a.contains(v)) {
            a.add(v);
        }
    }

    private static boolean contains(List<Integer> a, int v) {
        return a.contains(v);
    }

    private static boolean overlapRange(int amin, int amax, int bmin, int bmax) {
        return amin <= bmax && amax >= bmin;
    }

    public static HeightfieldLayerSet buildHeightfieldLayers(Telemetry ctx, CompactHeightfield chf, int walkableHeight) {
        int i;
        int i2;
        int i3;
        ctx.startTimer("RC_TIMER_BUILD_LAYERS");
        int w = chf.width;
        int h = chf.height;
        int borderSize = chf.borderSize;
        int[] srcReg = new int[chf.spanCount];
        Arrays.fill(srcReg, 255);
        int nsweeps = chf.width;
        RecastRegion.SweepSpan[] sweeps = new RecastRegion.SweepSpan[nsweeps];
        for (int i4 = 0; i4 < sweeps.length; ++i4) {
            sweeps[i4] = new RecastRegion.SweepSpan();
        }
        int[] prevCount = new int[256];
        int regId = 0;
        for (int y = borderSize; y < h - borderSize; ++y) {
            int i5;
            int ni;
            CompactCell c;
            int x;
            Arrays.fill(prevCount, 0, regId, 0);
            int sweepId = 0;
            for (x = borderSize; x < w - borderSize; ++x) {
                c = chf.cells[x + y * w];
                ni = c.index + c.count;
                for (i5 = c.index; i5 < ni; ++i5) {
                    int ai;
                    int ay;
                    int ax;
                    CompactSpan s = chf.spans[i5];
                    if (chf.areas[i5] == 0) continue;
                    int sid = 255;
                    if (RecastCommon.GetCon(s, 0) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(0);
                        ay = y + RecastCommon.GetDirOffsetY(0);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 0);
                        if (chf.areas[ai] != 0 && srcReg[ai] != 255) {
                            sid = srcReg[ai];
                        }
                    }
                    if (sid == 255) {
                        sid = sweepId++;
                        sweeps[sid].nei = 255;
                        sweeps[sid].ns = 0;
                    }
                    if (RecastCommon.GetCon(s, 3) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(3);
                        ay = y + RecastCommon.GetDirOffsetY(3);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 3);
                        int nr = srcReg[ai];
                        if (nr != 255) {
                            if (sweeps[sid].ns == 0) {
                                sweeps[sid].nei = nr;
                            }
                            if (sweeps[sid].nei == nr) {
                                ++sweeps[sid].ns;
                                int n = nr;
                                prevCount[n] = prevCount[n] + 1;
                            } else {
                                sweeps[sid].nei = 255;
                            }
                        }
                    }
                    srcReg[i5] = sid;
                }
            }
            for (i3 = 0; i3 < sweepId; ++i3) {
                if (sweeps[i3].nei != 255 && prevCount[sweeps[i3].nei] == sweeps[i3].ns) {
                    sweeps[i3].id = sweeps[i3].nei;
                    continue;
                }
                if (regId == 255) {
                    throw new RuntimeException("rcBuildHeightfieldLayers: Region ID overflow.");
                }
                sweeps[i3].id = regId++;
            }
            for (x = borderSize; x < w - borderSize; ++x) {
                c = chf.cells[x + y * w];
                ni = c.index + c.count;
                for (i5 = c.index; i5 < ni; ++i5) {
                    if (srcReg[i5] == 255) continue;
                    srcReg[i5] = sweeps[srcReg[i5]].id;
                }
            }
        }
        int nregs = regId;
        LayerRegion[] regs = new LayerRegion[nregs];
        for (i3 = 0; i3 < nregs; ++i3) {
            regs[i3] = new LayerRegion(i3);
        }
        ArrayList<Integer> lregs = new ArrayList<Integer>();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int i6;
                CompactCell c = chf.cells[x + y * w];
                lregs.clear();
                int ni = c.index + c.count;
                for (i6 = c.index; i6 < ni; ++i6) {
                    CompactSpan s = chf.spans[i6];
                    int ri = srcReg[i6];
                    if (ri == 255) continue;
                    regs[ri].ymin = Math.min(regs[ri].ymin, s.y);
                    regs[ri].ymax = Math.max(regs[ri].ymax, s.y);
                    lregs.add(ri);
                    for (int dir = 0; dir < 4; ++dir) {
                        if (RecastCommon.GetCon(s, dir) == 63) continue;
                        int ax = x + RecastCommon.GetDirOffsetX(dir);
                        int ay = y + RecastCommon.GetDirOffsetY(dir);
                        int ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, dir);
                        int rai = srcReg[ai];
                        if (rai == 255 || rai == ri) continue;
                        RecastLayers.addUnique(regs[ri].neis, rai);
                    }
                }
                for (i6 = 0; i6 < lregs.size() - 1; ++i6) {
                    for (int j = i6 + 1; j < lregs.size(); ++j) {
                        if (((Integer)lregs.get(i6)).intValue() == ((Integer)lregs.get(j)).intValue()) continue;
                        LayerRegion ri = regs[(Integer)lregs.get(i6)];
                        LayerRegion rj = regs[(Integer)lregs.get(j)];
                        RecastLayers.addUnique(ri.layers, (Integer)lregs.get(j));
                        RecastLayers.addUnique(rj.layers, (Integer)lregs.get(i6));
                    }
                }
            }
        }
        int layerId = 0;
        ArrayList<Integer> stack = new ArrayList<Integer>();
        for (int i7 = 0; i7 < nregs; ++i7) {
            LayerRegion root = regs[i7];
            if (root.layerId != 255) continue;
            root.layerId = layerId;
            root.base = true;
            stack.add(i7);
            while (!stack.isEmpty()) {
                LayerRegion reg = regs[(Integer)stack.remove(0)];
                for (int nei : reg.neis) {
                    LayerRegion regn = regs[nei];
                    if (regn.layerId != 255 || RecastLayers.contains(root.layers, nei)) continue;
                    int ymin = Math.min(root.ymin, regn.ymin);
                    int ymax = Math.max(root.ymax, regn.ymax);
                    if (ymax - ymin >= 255) continue;
                    stack.add(nei);
                    regn.layerId = layerId;
                    for (int layer : regn.layers) {
                        RecastLayers.addUnique(root.layers, layer);
                    }
                    root.ymin = Math.min(root.ymin, regn.ymin);
                    root.ymax = Math.max(root.ymax, regn.ymax);
                }
            }
            ++layerId;
        }
        int mergeHeight = walkableHeight * 4;
        block18: for (int i8 = 0; i8 < nregs; ++i8) {
            LayerRegion ri = regs[i8];
            if (!ri.base) continue;
            int newId = ri.layerId;
            block19: while (true) {
                LayerRegion rj;
                int j;
                int oldId = 255;
                for (j = 0; j < nregs; ++j) {
                    if (i8 == j) continue;
                    rj = regs[j];
                    if (!rj.base || !RecastLayers.overlapRange(ri.ymin, ri.ymax + mergeHeight, rj.ymin, rj.ymax + mergeHeight)) continue;
                    int ymin = Math.min(ri.ymin, rj.ymin);
                    int ymax = Math.max(ri.ymax, rj.ymax);
                    if (ymax - ymin >= 255) continue;
                    boolean overlap = false;
                    for (int k = 0; k < nregs; ++k) {
                        if (regs[k].layerId != rj.layerId || !RecastLayers.contains(ri.layers, k)) continue;
                        overlap = true;
                        break;
                    }
                    if (overlap) continue;
                    oldId = rj.layerId;
                    break;
                }
                if (oldId == 255) continue block18;
                j = 0;
                while (true) {
                    if (j >= nregs) continue block19;
                    rj = regs[j];
                    if (rj.layerId == oldId) {
                        rj.base = false;
                        rj.layerId = newId;
                        for (int layer : rj.layers) {
                            RecastLayers.addUnique(ri.layers, layer);
                        }
                        ri.ymin = Math.min(ri.ymin, rj.ymin);
                        ri.ymax = Math.max(ri.ymax, rj.ymax);
                    }
                    ++j;
                }
                break;
            }
        }
        int[] remap = new int[256];
        layerId = 0;
        for (i2 = 0; i2 < nregs; ++i2) {
            remap[regs[i2].layerId] = 1;
        }
        for (i2 = 0; i2 < 256; ++i2) {
            remap[i2] = remap[i2] != 0 ? layerId++ : 255;
        }
        for (i2 = 0; i2 < nregs; ++i2) {
            regs[i2].layerId = remap[regs[i2].layerId];
        }
        if (layerId == 0) {
            return null;
        }
        int lw = w - borderSize * 2;
        int lh = h - borderSize * 2;
        float[] bmin = new float[3];
        float[] bmax = new float[3];
        RecastVectors.copy(bmin, chf.bmin);
        RecastVectors.copy(bmax, chf.bmax);
        bmin[0] = bmin[0] + (float)borderSize * chf.cs;
        bmin[2] = bmin[2] + (float)borderSize * chf.cs;
        bmax[0] = bmax[0] - (float)borderSize * chf.cs;
        bmax[2] = bmax[2] - (float)borderSize * chf.cs;
        HeightfieldLayerSet lset = new HeightfieldLayerSet();
        lset.layers = new HeightfieldLayerSet.HeightfieldLayer[layerId];
        for (i = 0; i < lset.layers.length; ++i) {
            lset.layers[i] = new HeightfieldLayerSet.HeightfieldLayer();
        }
        for (i = 0; i < lset.layers.length; ++i) {
            int curId = i;
            HeightfieldLayerSet.HeightfieldLayer layer = lset.layers[i];
            int gridSize = lw * lh;
            layer.heights = new int[gridSize];
            Arrays.fill(layer.heights, 255);
            layer.areas = new int[gridSize];
            layer.cons = new int[gridSize];
            int hmin = 0;
            int hmax = 0;
            for (int j = 0; j < nregs; ++j) {
                if (!regs[j].base || regs[j].layerId != curId) continue;
                hmin = regs[j].ymin;
                hmax = regs[j].ymax;
            }
            layer.width = lw;
            layer.height = lh;
            layer.cs = chf.cs;
            layer.ch = chf.ch;
            RecastVectors.copy(layer.bmin, bmin);
            RecastVectors.copy(layer.bmax, bmax);
            layer.bmin[1] = bmin[1] + (float)hmin * chf.ch;
            layer.bmax[1] = bmin[1] + (float)hmax * chf.ch;
            layer.hmin = hmin;
            layer.hmax = hmax;
            layer.minx = layer.width;
            layer.maxx = 0;
            layer.miny = layer.height;
            layer.maxy = 0;
            for (int y = 0; y < lh; ++y) {
                for (int x = 0; x < lw; ++x) {
                    int cx = borderSize + x;
                    int cy = borderSize + y;
                    CompactCell c = chf.cells[cx + cy * w];
                    int nj = c.index + c.count;
                    for (int j = c.index; j < nj; ++j) {
                        int lid;
                        CompactSpan s = chf.spans[j];
                        if (srcReg[j] == 255 || (lid = regs[srcReg[j]].layerId) != curId) continue;
                        layer.minx = Math.min(layer.minx, x);
                        layer.maxx = Math.max(layer.maxx, x);
                        layer.miny = Math.min(layer.miny, y);
                        layer.maxy = Math.max(layer.maxy, y);
                        int idx = x + y * lw;
                        layer.heights[idx] = (char)(s.y - hmin);
                        layer.areas[idx] = chf.areas[j];
                        int portal = 0;
                        int con = 0;
                        for (int dir = 0; dir < 4; ++dir) {
                            int alid;
                            if (RecastCommon.GetCon(s, dir) == 63) continue;
                            int ax = cx + RecastCommon.GetDirOffsetX(dir);
                            int ay = cy + RecastCommon.GetDirOffsetY(dir);
                            int ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, dir);
                            int n = alid = srcReg[ai] != 255 ? regs[srcReg[ai]].layerId : 255;
                            if (chf.areas[ai] != 0 && lid != alid) {
                                portal = (char)(portal | 1 << dir);
                                CompactSpan as = chf.spans[ai];
                                if (as.y > hmin) {
                                    layer.heights[idx] = Math.max(layer.heights[idx], (char)(as.y - hmin));
                                }
                            }
                            if (chf.areas[ai] == 0 || lid != alid) continue;
                            int nx = ax - borderSize;
                            int ny = ay - borderSize;
                            if (nx < 0 || ny < 0 || nx >= lw || ny >= lh) continue;
                            con = (char)(con | 1 << dir);
                        }
                        layer.cons[idx] = portal << 4 | con;
                    }
                }
            }
            if (layer.minx > layer.maxx) {
                layer.maxx = 0;
                layer.minx = 0;
            }
            if (layer.miny <= layer.maxy) continue;
            layer.maxy = 0;
            layer.miny = 0;
        }
        return lset;
    }

    static class LayerRegion {
        int id;
        int layerId;
        boolean base;
        int ymin;
        int ymax;
        List<Integer> layers;
        List<Integer> neis;

        LayerRegion(int i) {
            this.id = i;
            this.ymin = 65535;
            this.layerId = 255;
            this.layers = new ArrayList<Integer>();
            this.neis = new ArrayList<Integer>();
        }
    }
}

