/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.Arrays;
import org.recast4j.recast.Contour;
import org.recast4j.recast.ContourSet;
import org.recast4j.recast.PolyMesh;
import org.recast4j.recast.RecastConstants;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.Telemetry;

public class RecastMesh {
    private static final int MAX_MESH_VERTS_POLY = 65535;
    static int VERTEX_BUCKET_COUNT = 4096;

    private static void buildMeshAdjacency(int[] polys, int npolys, int nverts, int vertsPerPoly) {
        int v1;
        int v0;
        int j;
        int t;
        int i;
        int maxEdgeCount = npolys * vertsPerPoly;
        int[] firstEdge = new int[nverts + maxEdgeCount];
        int nextEdge = nverts;
        int edgeCount = 0;
        Edge[] edges = new Edge[maxEdgeCount];
        for (i = 0; i < nverts; ++i) {
            firstEdge[i] = RecastConstants.RC_MESH_NULL_IDX;
        }
        for (i = 0; i < npolys; ++i) {
            t = i * vertsPerPoly * 2;
            for (j = 0; j < vertsPerPoly && polys[t + j] != RecastConstants.RC_MESH_NULL_IDX; ++j) {
                Edge edge;
                v0 = polys[t + j];
                int n = v1 = j + 1 >= vertsPerPoly || polys[t + j + 1] == RecastConstants.RC_MESH_NULL_IDX ? polys[t + 0] : polys[t + j + 1];
                if (v0 >= v1) continue;
                edges[edgeCount] = edge = new Edge();
                edge.vert[0] = v0;
                edge.vert[1] = v1;
                edge.poly[0] = i;
                edge.polyEdge[0] = j;
                edge.poly[1] = i;
                edge.polyEdge[1] = 0;
                firstEdge[nextEdge + edgeCount] = firstEdge[v0];
                firstEdge[v0] = edgeCount++;
            }
        }
        for (i = 0; i < npolys; ++i) {
            t = i * vertsPerPoly * 2;
            block4: for (j = 0; j < vertsPerPoly && polys[t + j] != RecastConstants.RC_MESH_NULL_IDX; ++j) {
                v0 = polys[t + j];
                int n = v1 = j + 1 >= vertsPerPoly || polys[t + j + 1] == RecastConstants.RC_MESH_NULL_IDX ? polys[t + 0] : polys[t + j + 1];
                if (v0 <= v1) continue;
                int e = firstEdge[v1];
                while (e != RecastConstants.RC_MESH_NULL_IDX) {
                    Edge edge = edges[e];
                    if (edge.vert[1] == v0 && edge.poly[0] == edge.poly[1]) {
                        edge.poly[1] = i;
                        edge.polyEdge[1] = j;
                        continue block4;
                    }
                    e = firstEdge[nextEdge + e];
                }
            }
        }
        for (i = 0; i < edgeCount; ++i) {
            Edge e = edges[i];
            if (e.poly[0] == e.poly[1]) continue;
            int p0 = e.poly[0] * vertsPerPoly * 2;
            int p1 = e.poly[1] * vertsPerPoly * 2;
            polys[p0 + vertsPerPoly + e.polyEdge[0]] = e.poly[1];
            polys[p1 + vertsPerPoly + e.polyEdge[1]] = e.poly[0];
        }
    }

    private static int computeVertexHash(int x, int y, int z) {
        int h1 = -1918454973;
        int h2 = -669632447;
        int h3 = -887442657;
        int n = h1 * x + h2 * y + h3 * z;
        return n & VERTEX_BUCKET_COUNT - 1;
    }

    private static int[] addVertex(int x, int y, int z, int[] verts, int[] firstVert, int[] nextVert, int nv) {
        int v;
        int bucket = RecastMesh.computeVertexHash(x, 0, z);
        int i = firstVert[bucket];
        while (i != -1) {
            v = i * 3;
            if (verts[v + 0] == x && Math.abs(verts[v + 1] - y) <= 2 && verts[v + 2] == z) {
                return new int[]{i, nv};
            }
            i = nextVert[i];
        }
        i = nv++;
        v = i * 3;
        verts[v + 0] = x;
        verts[v + 1] = y;
        verts[v + 2] = z;
        nextVert[i] = firstVert[bucket];
        firstVert[bucket] = i;
        return new int[]{i, nv};
    }

    static int prev(int i, int n) {
        return i - 1 >= 0 ? i - 1 : n - 1;
    }

    static int next(int i, int n) {
        return i + 1 < n ? i + 1 : 0;
    }

    private static int area2(int[] verts, int a, int b, int c) {
        return (verts[b + 0] - verts[a + 0]) * (verts[c + 2] - verts[a + 2]) - (verts[c + 0] - verts[a + 0]) * (verts[b + 2] - verts[a + 2]);
    }

    static boolean left(int[] verts, int a, int b, int c) {
        return RecastMesh.area2(verts, a, b, c) < 0;
    }

    static boolean leftOn(int[] verts, int a, int b, int c) {
        return RecastMesh.area2(verts, a, b, c) <= 0;
    }

    private static boolean collinear(int[] verts, int a, int b, int c) {
        return RecastMesh.area2(verts, a, b, c) == 0;
    }

    private static boolean intersectProp(int[] verts, int a, int b, int c, int d) {
        if (RecastMesh.collinear(verts, a, b, c) || RecastMesh.collinear(verts, a, b, d) || RecastMesh.collinear(verts, c, d, a) || RecastMesh.collinear(verts, c, d, b)) {
            return false;
        }
        return RecastMesh.left(verts, a, b, c) ^ RecastMesh.left(verts, a, b, d) && RecastMesh.left(verts, c, d, a) ^ RecastMesh.left(verts, c, d, b);
    }

    private static boolean between(int[] verts, int a, int b, int c) {
        if (!RecastMesh.collinear(verts, a, b, c)) {
            return false;
        }
        if (verts[a + 0] != verts[b + 0]) {
            return verts[a + 0] <= verts[c + 0] && verts[c + 0] <= verts[b + 0] || verts[a + 0] >= verts[c + 0] && verts[c + 0] >= verts[b + 0];
        }
        return verts[a + 2] <= verts[c + 2] && verts[c + 2] <= verts[b + 2] || verts[a + 2] >= verts[c + 2] && verts[c + 2] >= verts[b + 2];
    }

    static boolean intersect(int[] verts, int a, int b, int c, int d) {
        if (RecastMesh.intersectProp(verts, a, b, c, d)) {
            return true;
        }
        return RecastMesh.between(verts, a, b, c) || RecastMesh.between(verts, a, b, d) || RecastMesh.between(verts, c, d, a) || RecastMesh.between(verts, c, d, b);
    }

    static boolean vequal(int[] verts, int a, int b) {
        return verts[a + 0] == verts[b + 0] && verts[a + 2] == verts[b + 2];
    }

    private static boolean diagonalie(int i, int j, int n, int[] verts, int[] indices) {
        int d0 = (indices[i] & 0xFFFFFFF) * 4;
        int d1 = (indices[j] & 0xFFFFFFF) * 4;
        for (int k = 0; k < n; ++k) {
            int k1 = RecastMesh.next(k, n);
            if (k == i || k1 == i || k == j || k1 == j) continue;
            int p0 = (indices[k] & 0xFFFFFFF) * 4;
            int p1 = (indices[k1] & 0xFFFFFFF) * 4;
            if (RecastMesh.vequal(verts, d0, p0) || RecastMesh.vequal(verts, d1, p0) || RecastMesh.vequal(verts, d0, p1) || RecastMesh.vequal(verts, d1, p1) || !RecastMesh.intersect(verts, d0, d1, p0, p1)) continue;
            return false;
        }
        return true;
    }

    private static boolean inCone(int i, int j, int n, int[] verts, int[] indices) {
        int pi = (indices[i] & 0xFFFFFFF) * 4;
        int pj = (indices[j] & 0xFFFFFFF) * 4;
        int pi1 = (indices[RecastMesh.next(i, n)] & 0xFFFFFFF) * 4;
        int pin1 = (indices[RecastMesh.prev(i, n)] & 0xFFFFFFF) * 4;
        if (RecastMesh.leftOn(verts, pin1, pi, pi1)) {
            return RecastMesh.left(verts, pi, pj, pin1) && RecastMesh.left(verts, pj, pi, pi1);
        }
        return !RecastMesh.leftOn(verts, pi, pj, pi1) || !RecastMesh.leftOn(verts, pj, pi, pin1);
    }

    private static boolean diagonal(int i, int j, int n, int[] verts, int[] indices) {
        return RecastMesh.inCone(i, j, n, verts, indices) && RecastMesh.diagonalie(i, j, n, verts, indices);
    }

    private static boolean diagonalieLoose(int i, int j, int n, int[] verts, int[] indices) {
        int d0 = (indices[i] & 0xFFFFFFF) * 4;
        int d1 = (indices[j] & 0xFFFFFFF) * 4;
        for (int k = 0; k < n; ++k) {
            int k1 = RecastMesh.next(k, n);
            if (k == i || k1 == i || k == j || k1 == j) continue;
            int p0 = (indices[k] & 0xFFFFFFF) * 4;
            int p1 = (indices[k1] & 0xFFFFFFF) * 4;
            if (RecastMesh.vequal(verts, d0, p0) || RecastMesh.vequal(verts, d1, p0) || RecastMesh.vequal(verts, d0, p1) || RecastMesh.vequal(verts, d1, p1) || !RecastMesh.intersectProp(verts, d0, d1, p0, p1)) continue;
            return false;
        }
        return true;
    }

    private static boolean inConeLoose(int i, int j, int n, int[] verts, int[] indices) {
        int pi = (indices[i] & 0xFFFFFFF) * 4;
        int pj = (indices[j] & 0xFFFFFFF) * 4;
        int pi1 = (indices[RecastMesh.next(i, n)] & 0xFFFFFFF) * 4;
        int pin1 = (indices[RecastMesh.prev(i, n)] & 0xFFFFFFF) * 4;
        if (RecastMesh.leftOn(verts, pin1, pi, pi1)) {
            return RecastMesh.leftOn(verts, pi, pj, pin1) && RecastMesh.leftOn(verts, pj, pi, pi1);
        }
        return !RecastMesh.leftOn(verts, pi, pj, pi1) || !RecastMesh.leftOn(verts, pj, pi, pin1);
    }

    private static boolean diagonalLoose(int i, int j, int n, int[] verts, int[] indices) {
        return RecastMesh.inConeLoose(i, j, n, verts, indices) && RecastMesh.diagonalieLoose(i, j, n, verts, indices);
    }

    private static int triangulate(int n, int[] verts, int[] indices, int[] tris) {
        int ntris = 0;
        for (int i = 0; i < n; ++i) {
            int i1 = RecastMesh.next(i, n);
            int i2 = RecastMesh.next(i1, n);
            if (!RecastMesh.diagonal(i, i2, n, verts, indices)) continue;
            int n2 = i1;
            indices[n2] = indices[n2] | Integer.MIN_VALUE;
        }
        while (n > 3) {
            int i2;
            int i1;
            int i;
            int minLen = -1;
            int mini = -1;
            for (i = 0; i < n; ++i) {
                i1 = RecastMesh.next(i, n);
                if ((indices[i1] & Integer.MIN_VALUE) == 0) continue;
                int p0 = (indices[i] & 0xFFFFFFF) * 4;
                int p2 = (indices[RecastMesh.next(i1, n)] & 0xFFFFFFF) * 4;
                int dx = verts[p2 + 0] - verts[p0 + 0];
                int dy = verts[p2 + 2] - verts[p0 + 2];
                int len = dx * dx + dy * dy;
                if (minLen >= 0 && len >= minLen) continue;
                minLen = len;
                mini = i;
            }
            if (mini == -1) {
                minLen = -1;
                mini = -1;
                for (i = 0; i < n; ++i) {
                    i1 = RecastMesh.next(i, n);
                    i2 = RecastMesh.next(i1, n);
                    if (!RecastMesh.diagonalLoose(i, i2, n, verts, indices)) continue;
                    int p0 = (indices[i] & 0xFFFFFFF) * 4;
                    int p2 = (indices[RecastMesh.next(i2, n)] & 0xFFFFFFF) * 4;
                    int dx = verts[p2 + 0] - verts[p0 + 0];
                    int dy = verts[p2 + 2] - verts[p0 + 2];
                    int len = dx * dx + dy * dy;
                    if (minLen >= 0 && len >= minLen) continue;
                    minLen = len;
                    mini = i;
                }
                if (mini == -1) {
                    return -ntris;
                }
            }
            i = mini;
            i1 = RecastMesh.next(i, n);
            i2 = RecastMesh.next(i1, n);
            tris[ntris * 3] = indices[i] & 0xFFFFFFF;
            tris[ntris * 3 + 1] = indices[i1] & 0xFFFFFFF;
            tris[ntris * 3 + 2] = indices[i2] & 0xFFFFFFF;
            ++ntris;
            --n;
            for (int k = i1; k < n; ++k) {
                indices[k] = indices[k + 1];
            }
            if (i1 >= n) {
                i1 = 0;
            }
            if (RecastMesh.diagonal(RecastMesh.prev(i = RecastMesh.prev(i1, n), n), i1, n, verts, indices)) {
                int n3 = i;
                indices[n3] = indices[n3] | Integer.MIN_VALUE;
            } else {
                int n4 = i;
                indices[n4] = indices[n4] & 0xFFFFFFF;
            }
            if (RecastMesh.diagonal(i, RecastMesh.next(i1, n), n, verts, indices)) {
                int n5 = i1;
                indices[n5] = indices[n5] | Integer.MIN_VALUE;
                continue;
            }
            int n6 = i1;
            indices[n6] = indices[n6] & 0xFFFFFFF;
        }
        tris[ntris * 3] = indices[0] & 0xFFFFFFF;
        tris[ntris * 3 + 1] = indices[1] & 0xFFFFFFF;
        tris[ntris * 3 + 2] = indices[2] & 0xFFFFFFF;
        return ++ntris;
    }

    private static int countPolyVerts(int[] p, int j, int nvp) {
        for (int i = 0; i < nvp; ++i) {
            if (p[i + j] != RecastConstants.RC_MESH_NULL_IDX) continue;
            return i;
        }
        return nvp;
    }

    private static boolean uleft(int[] verts, int a, int b, int c) {
        return (verts[b + 0] - verts[a + 0]) * (verts[c + 2] - verts[a + 2]) - (verts[c + 0] - verts[a + 0]) * (verts[b + 2] - verts[a + 2]) < 0;
    }

    private static int[] getPolyMergeValue(int[] polys, int pa, int pb, int[] verts, int nvp) {
        int nb;
        int ea = -1;
        int eb = -1;
        int na = RecastMesh.countPolyVerts(polys, pa, nvp);
        if (na + (nb = RecastMesh.countPolyVerts(polys, pb, nvp)) - 2 > nvp) {
            return new int[]{-1, ea, eb};
        }
        block0: for (int i = 0; i < na; ++i) {
            int va0 = polys[pa + i];
            int va1 = polys[pa + (i + 1) % na];
            if (va0 > va1) {
                int temp = va0;
                va0 = va1;
                va1 = temp;
            }
            for (int j = 0; j < nb; ++j) {
                int vb0 = polys[pb + j];
                int vb1 = polys[pb + (j + 1) % nb];
                if (vb0 > vb1) {
                    int temp = vb0;
                    vb0 = vb1;
                    vb1 = temp;
                }
                if (va0 != vb0 || va1 != vb1) continue;
                ea = i;
                eb = j;
                continue block0;
            }
        }
        if (ea == -1 || eb == -1) {
            return new int[]{-1, ea, eb};
        }
        int va = polys[pa + (ea + na - 1) % na];
        int vb = polys[pa + ea];
        int vc = polys[pb + (eb + 2) % nb];
        if (!RecastMesh.uleft(verts, va * 3, vb * 3, vc * 3)) {
            return new int[]{-1, ea, eb};
        }
        va = polys[pb + (eb + nb - 1) % nb];
        vb = polys[pb + eb];
        vc = polys[pa + (ea + 2) % na];
        if (!RecastMesh.uleft(verts, va * 3, vb * 3, vc * 3)) {
            return new int[]{-1, ea, eb};
        }
        va = polys[pa + ea];
        vb = polys[pa + (ea + 1) % na];
        int dx = verts[va * 3 + 0] - verts[vb * 3 + 0];
        int dy = verts[va * 3 + 2] - verts[vb * 3 + 2];
        return new int[]{dx * dx + dy * dy, ea, eb};
    }

    private static void mergePolyVerts(int[] polys, int pa, int pb, int ea, int eb, int tmp, int nvp) {
        int i;
        int na = RecastMesh.countPolyVerts(polys, pa, nvp);
        int nb = RecastMesh.countPolyVerts(polys, pb, nvp);
        Arrays.fill(polys, tmp, tmp + nvp, RecastConstants.RC_MESH_NULL_IDX);
        int n = 0;
        for (i = 0; i < na - 1; ++i) {
            polys[tmp + n] = polys[pa + (ea + 1 + i) % na];
            ++n;
        }
        for (i = 0; i < nb - 1; ++i) {
            polys[tmp + n] = polys[pb + (eb + 1 + i) % nb];
            ++n;
        }
        System.arraycopy(polys, tmp, polys, pa, nvp);
    }

    private static int pushFront(int v, int[] arr, int an) {
        for (int i = ++an - 1; i > 0; --i) {
            arr[i] = arr[i - 1];
        }
        arr[0] = v;
        return an;
    }

    private static int pushBack(int v, int[] arr, int an) {
        arr[an] = v;
        return ++an;
    }

    private static boolean canRemoveVertex(Telemetry ctx, PolyMesh mesh, int rem) {
        int nvp = mesh.nvp;
        int numTouchedVerts = 0;
        int numRemainingEdges = 0;
        for (int i = 0; i < mesh.npolys; ++i) {
            int p = i * nvp * 2;
            int nv = RecastMesh.countPolyVerts(mesh.polys, p, nvp);
            int numRemoved = 0;
            int numVerts = 0;
            for (int j = 0; j < nv; ++j) {
                if (mesh.polys[p + j] == rem) {
                    ++numTouchedVerts;
                    ++numRemoved;
                }
                ++numVerts;
            }
            if (numRemoved == 0) continue;
            numRemainingEdges += numVerts - (numRemoved + 1);
        }
        if (numRemainingEdges <= 2) {
            return false;
        }
        int maxEdges = numTouchedVerts * 2;
        int nedges = 0;
        int[] edges = new int[maxEdges * 3];
        for (int i = 0; i < mesh.npolys; ++i) {
            int p = i * nvp * 2;
            int nv = RecastMesh.countPolyVerts(mesh.polys, p, nvp);
            int j = 0;
            int k = nv - 1;
            while (j < nv) {
                if (mesh.polys[p + j] == rem || mesh.polys[p + k] == rem) {
                    int a = mesh.polys[p + j];
                    int b = mesh.polys[p + k];
                    if (b == rem) {
                        int temp = a;
                        a = b;
                        b = temp;
                    }
                    boolean exists = false;
                    for (int m = 0; m < nedges; ++m) {
                        int e = m * 3;
                        if (edges[e + 1] != b) continue;
                        int n = e + 2;
                        edges[n] = edges[n] + 1;
                        exists = true;
                    }
                    if (!exists) {
                        int e = nedges * 3;
                        edges[e + 0] = a;
                        edges[e + 1] = b;
                        edges[e + 2] = 1;
                        ++nedges;
                    }
                }
                k = j++;
            }
        }
        int numOpenEdges = 0;
        for (int i = 0; i < nedges; ++i) {
            if (edges[i * 3 + 2] >= 2) continue;
            ++numOpenEdges;
        }
        return numOpenEdges <= 2;
    }

    private static void removeVertex(Telemetry ctx, PolyMesh mesh, int rem, int maxTris) {
        int nv;
        int p;
        int i;
        int nvp = mesh.nvp;
        int numRemovedVerts = 0;
        for (int i2 = 0; i2 < mesh.npolys; ++i2) {
            int p2 = i2 * nvp * 2;
            int nv2 = RecastMesh.countPolyVerts(mesh.polys, p2, nvp);
            for (int j = 0; j < nv2; ++j) {
                if (mesh.polys[p2 + j] != rem) continue;
                ++numRemovedVerts;
            }
        }
        int nedges = 0;
        int[] edges = new int[numRemovedVerts * nvp * 4];
        int nhole = 0;
        int[] hole = new int[numRemovedVerts * nvp];
        int nhreg = 0;
        int[] hreg = new int[numRemovedVerts * nvp];
        int nharea = 0;
        int[] harea = new int[numRemovedVerts * nvp];
        for (i = 0; i < mesh.npolys; ++i) {
            int j;
            p = i * nvp * 2;
            nv = RecastMesh.countPolyVerts(mesh.polys, p, nvp);
            boolean hasRem = false;
            for (j = 0; j < nv; ++j) {
                if (mesh.polys[p + j] != rem) continue;
                hasRem = true;
            }
            if (!hasRem) continue;
            j = 0;
            int k = nv - 1;
            while (j < nv) {
                if (mesh.polys[p + j] != rem && mesh.polys[p + k] != rem) {
                    int e = nedges * 4;
                    edges[e + 0] = mesh.polys[p + k];
                    edges[e + 1] = mesh.polys[p + j];
                    edges[e + 2] = mesh.regs[i];
                    edges[e + 3] = mesh.areas[i];
                    ++nedges;
                }
                k = j++;
            }
            int p2 = (mesh.npolys - 1) * nvp * 2;
            if (p != p2) {
                System.arraycopy(mesh.polys, p2, mesh.polys, p, nvp);
            }
            Arrays.fill(mesh.polys, p + nvp, p + nvp + nvp, RecastConstants.RC_MESH_NULL_IDX);
            mesh.regs[i] = mesh.regs[mesh.npolys - 1];
            mesh.areas[i] = mesh.areas[mesh.npolys - 1];
            --mesh.npolys;
            --i;
        }
        for (i = rem; i < mesh.nverts - 1; ++i) {
            mesh.verts[i * 3 + 0] = mesh.verts[(i + 1) * 3 + 0];
            mesh.verts[i * 3 + 1] = mesh.verts[(i + 1) * 3 + 1];
            mesh.verts[i * 3 + 2] = mesh.verts[(i + 1) * 3 + 2];
        }
        --mesh.nverts;
        for (i = 0; i < mesh.npolys; ++i) {
            p = i * nvp * 2;
            nv = RecastMesh.countPolyVerts(mesh.polys, p, nvp);
            for (int j = 0; j < nv; ++j) {
                if (mesh.polys[p + j] <= rem) continue;
                int n = p + j;
                mesh.polys[n] = mesh.polys[n] - 1;
            }
        }
        for (i = 0; i < nedges; ++i) {
            if (edges[i * 4 + 0] > rem) {
                int n = i * 4 + 0;
                edges[n] = edges[n] - 1;
            }
            if (edges[i * 4 + 1] <= rem) continue;
            int n = i * 4 + 1;
            edges[n] = edges[n] - 1;
        }
        if (nedges == 0) {
            return;
        }
        nhole = RecastMesh.pushBack(edges[0], hole, nhole);
        nhreg = RecastMesh.pushBack(edges[2], hreg, nhreg);
        nharea = RecastMesh.pushBack(edges[3], harea, nharea);
        while (nedges != 0) {
            boolean match = false;
            for (int i3 = 0; i3 < nedges; ++i3) {
                int ea = edges[i3 * 4 + 0];
                int eb = edges[i3 * 4 + 1];
                int r = edges[i3 * 4 + 2];
                int a = edges[i3 * 4 + 3];
                boolean add = false;
                if (hole[0] == eb) {
                    nhole = RecastMesh.pushFront(ea, hole, nhole);
                    nhreg = RecastMesh.pushFront(r, hreg, nhreg);
                    nharea = RecastMesh.pushFront(a, harea, nharea);
                    add = true;
                } else if (hole[nhole - 1] == ea) {
                    nhole = RecastMesh.pushBack(eb, hole, nhole);
                    nhreg = RecastMesh.pushBack(r, hreg, nhreg);
                    nharea = RecastMesh.pushBack(a, harea, nharea);
                    add = true;
                }
                if (!add) continue;
                edges[i3 * 4 + 0] = edges[(nedges - 1) * 4 + 0];
                edges[i3 * 4 + 1] = edges[(nedges - 1) * 4 + 1];
                edges[i3 * 4 + 2] = edges[(nedges - 1) * 4 + 2];
                edges[i3 * 4 + 3] = edges[(nedges - 1) * 4 + 3];
                --nedges;
                match = true;
                --i3;
            }
            if (match) continue;
            break;
        }
        int[] tris = new int[nhole * 3];
        int[] tverts = new int[nhole * 4];
        int[] thole = new int[nhole];
        for (int i4 = 0; i4 < nhole; ++i4) {
            int pi = hole[i4];
            tverts[i4 * 4 + 0] = mesh.verts[pi * 3 + 0];
            tverts[i4 * 4 + 1] = mesh.verts[pi * 3 + 1];
            tverts[i4 * 4 + 2] = mesh.verts[pi * 3 + 2];
            tverts[i4 * 4 + 3] = 0;
            thole[i4] = i4;
        }
        int ntris = RecastMesh.triangulate(nhole, tverts, thole, tris);
        if (ntris < 0) {
            ntris = -ntris;
            ctx.warn("removeVertex: triangulate() returned bad results.");
        }
        int[] polys = new int[(ntris + 1) * nvp];
        int[] pregs = new int[ntris];
        int[] pareas = new int[ntris];
        int tmpPoly = ntris * nvp;
        int npolys = 0;
        Arrays.fill(polys, 0, ntris * nvp, RecastConstants.RC_MESH_NULL_IDX);
        for (int j = 0; j < ntris; ++j) {
            int t = j * 3;
            if (tris[t + 0] == tris[t + 1] || tris[t + 0] == tris[t + 2] || tris[t + 1] == tris[t + 2]) continue;
            polys[npolys * nvp + 0] = hole[tris[t + 0]];
            polys[npolys * nvp + 1] = hole[tris[t + 1]];
            polys[npolys * nvp + 2] = hole[tris[t + 2]];
            pregs[npolys] = hreg[tris[t + 0]] != hreg[tris[t + 1]] || hreg[tris[t + 1]] != hreg[tris[t + 2]] ? RecastConstants.RC_MULTIPLE_REGS : hreg[tris[t + 0]];
            pareas[npolys] = harea[tris[t + 0]];
            ++npolys;
        }
        if (npolys == 0) {
            return;
        }
        if (nvp > 3) {
            while (true) {
                int last;
                int bestMergeVal = 0;
                int bestPa = 0;
                int bestPb = 0;
                int bestEa = 0;
                int bestEb = 0;
                for (int j = 0; j < npolys - 1; ++j) {
                    int pj = j * nvp;
                    for (int k = j + 1; k < npolys; ++k) {
                        int pk = k * nvp;
                        int[] veaeb = RecastMesh.getPolyMergeValue(polys, pj, pk, mesh.verts, nvp);
                        int v = veaeb[0];
                        int ea = veaeb[1];
                        int eb = veaeb[2];
                        if (v <= bestMergeVal) continue;
                        bestMergeVal = v;
                        bestPa = j;
                        bestPb = k;
                        bestEa = ea;
                        bestEb = eb;
                    }
                }
                if (bestMergeVal <= 0) break;
                int pa = bestPa * nvp;
                int pb = bestPb * nvp;
                RecastMesh.mergePolyVerts(polys, pa, pb, bestEa, bestEb, tmpPoly, nvp);
                if (pregs[bestPa] != pregs[bestPb]) {
                    pregs[bestPa] = RecastConstants.RC_MULTIPLE_REGS;
                }
                if (pb != (last = (npolys - 1) * nvp)) {
                    System.arraycopy(polys, last, polys, pb, nvp);
                }
                pregs[bestPb] = pregs[npolys - 1];
                pareas[bestPb] = pareas[npolys - 1];
                --npolys;
            }
        }
        for (int i5 = 0; i5 < npolys && mesh.npolys < maxTris; ++i5) {
            int p3 = mesh.npolys * nvp * 2;
            Arrays.fill(mesh.polys, p3, p3 + nvp * 2, RecastConstants.RC_MESH_NULL_IDX);
            for (int j = 0; j < nvp; ++j) {
                mesh.polys[p3 + j] = polys[i5 * nvp + j];
            }
            mesh.regs[mesh.npolys] = pregs[i5];
            mesh.areas[mesh.npolys] = pareas[i5];
            ++mesh.npolys;
            if (mesh.npolys <= maxTris) continue;
            throw new RuntimeException("removeVertex: Too many polygons " + mesh.npolys + " (max:" + maxTris + ".");
        }
    }

    public static PolyMesh buildPolyMesh(Telemetry ctx, ContourSet cset, int nvp) {
        int j;
        int i;
        ctx.startTimer("POLYMESH");
        PolyMesh mesh = new PolyMesh();
        RecastVectors.copy(mesh.bmin, cset.bmin, 0);
        RecastVectors.copy(mesh.bmax, cset.bmax, 0);
        mesh.cs = cset.cs;
        mesh.ch = cset.ch;
        mesh.borderSize = cset.borderSize;
        mesh.maxEdgeError = cset.maxError;
        int maxVertices = 0;
        int maxTris = 0;
        int maxVertsPerCont = 0;
        for (int i2 = 0; i2 < cset.conts.size(); ++i2) {
            if (cset.conts.get((int)i2).nverts < 3) continue;
            maxVertices += cset.conts.get((int)i2).nverts;
            maxTris += cset.conts.get((int)i2).nverts - 2;
            maxVertsPerCont = Math.max(maxVertsPerCont, cset.conts.get((int)i2).nverts);
        }
        if (maxVertices >= 65534) {
            throw new RuntimeException("rcBuildPolyMesh: Too many vertices " + maxVertices);
        }
        int[] vflags = new int[maxVertices];
        mesh.verts = new int[maxVertices * 3];
        mesh.polys = new int[maxTris * nvp * 2];
        Arrays.fill(mesh.polys, RecastConstants.RC_MESH_NULL_IDX);
        mesh.regs = new int[maxTris];
        mesh.areas = new int[maxTris];
        mesh.nverts = 0;
        mesh.npolys = 0;
        mesh.nvp = nvp;
        mesh.maxpolys = maxTris;
        int[] nextVert = new int[maxVertices];
        int[] firstVert = new int[VERTEX_BUCKET_COUNT];
        for (int i3 = 0; i3 < VERTEX_BUCKET_COUNT; ++i3) {
            firstVert[i3] = -1;
        }
        int[] indices = new int[maxVertsPerCont];
        int[] tris = new int[maxVertsPerCont * 3];
        int[] polys = new int[(maxVertsPerCont + 1) * nvp];
        int tmpPoly = maxVertsPerCont * nvp;
        for (i = 0; i < cset.conts.size(); ++i) {
            Contour cont = cset.conts.get(i);
            if (cont.nverts < 3) continue;
            for (int j2 = 0; j2 < cont.nverts; ++j2) {
                indices[j2] = j2;
            }
            int ntris = RecastMesh.triangulate(cont.nverts, cont.verts, indices, tris);
            if (ntris <= 0) {
                ctx.warn("buildPolyMesh: Bad triangulation Contour " + i + ".");
                ntris = -ntris;
            }
            for (int j3 = 0; j3 < cont.nverts; ++j3) {
                int v = j3 * 4;
                int[] inv = RecastMesh.addVertex(cont.verts[v + 0], cont.verts[v + 1], cont.verts[v + 2], mesh.verts, firstVert, nextVert, mesh.nverts);
                indices[j3] = inv[0];
                mesh.nverts = inv[1];
                if ((cont.verts[v + 3] & RecastConstants.RC_BORDER_VERTEX) == 0) continue;
                vflags[indices[j3]] = 1;
            }
            int npolys = 0;
            Arrays.fill(polys, RecastConstants.RC_MESH_NULL_IDX);
            for (j = 0; j < ntris; ++j) {
                int t = j * 3;
                if (tris[t + 0] == tris[t + 1] || tris[t + 0] == tris[t + 2] || tris[t + 1] == tris[t + 2]) continue;
                polys[npolys * nvp + 0] = indices[tris[t + 0]];
                polys[npolys * nvp + 1] = indices[tris[t + 1]];
                polys[npolys * nvp + 2] = indices[tris[t + 2]];
                ++npolys;
            }
            if (npolys == 0) continue;
            if (nvp > 3) {
                while (true) {
                    int bestMergeVal = 0;
                    int bestPa = 0;
                    int bestPb = 0;
                    int bestEa = 0;
                    int bestEb = 0;
                    for (int j4 = 0; j4 < npolys - 1; ++j4) {
                        int pj = j4 * nvp;
                        for (int k = j4 + 1; k < npolys; ++k) {
                            int pk = k * nvp;
                            int[] veaeb = RecastMesh.getPolyMergeValue(polys, pj, pk, mesh.verts, nvp);
                            int v = veaeb[0];
                            int ea = veaeb[1];
                            int eb = veaeb[2];
                            if (v <= bestMergeVal) continue;
                            bestMergeVal = v;
                            bestPa = j4;
                            bestPb = k;
                            bestEa = ea;
                            bestEb = eb;
                        }
                    }
                    if (bestMergeVal <= 0) break;
                    int pa = bestPa * nvp;
                    int pb = bestPb * nvp;
                    RecastMesh.mergePolyVerts(polys, pa, pb, bestEa, bestEb, tmpPoly, nvp);
                    int lastPoly = (npolys - 1) * nvp;
                    if (pb != lastPoly) {
                        System.arraycopy(polys, lastPoly, polys, pb, nvp);
                    }
                    --npolys;
                }
            }
            for (j = 0; j < npolys; ++j) {
                int p = mesh.npolys * nvp * 2;
                int q = j * nvp;
                for (int k = 0; k < nvp; ++k) {
                    mesh.polys[p + k] = polys[q + k];
                }
                mesh.regs[mesh.npolys] = cont.reg;
                mesh.areas[mesh.npolys] = cont.area;
                ++mesh.npolys;
                if (mesh.npolys <= maxTris) continue;
                throw new RuntimeException("rcBuildPolyMesh: Too many polygons " + mesh.npolys + " (max:" + maxTris + ").");
            }
        }
        for (i = 0; i < mesh.nverts; ++i) {
            if (vflags[i] == 0 || !RecastMesh.canRemoveVertex(ctx, mesh, i)) continue;
            RecastMesh.removeVertex(ctx, mesh, i, maxTris);
            for (int j5 = i; j5 < mesh.nverts; ++j5) {
                vflags[j5] = vflags[j5 + 1];
            }
            --i;
        }
        RecastMesh.buildMeshAdjacency(mesh.polys, mesh.npolys, mesh.nverts, nvp);
        if (mesh.borderSize > 0) {
            int w = cset.width;
            int h = cset.height;
            for (int i4 = 0; i4 < mesh.npolys; ++i4) {
                int p = i4 * 2 * nvp;
                for (j = 0; j < nvp && mesh.polys[p + j] != RecastConstants.RC_MESH_NULL_IDX; ++j) {
                    if (mesh.polys[p + nvp + j] != RecastConstants.RC_MESH_NULL_IDX) continue;
                    int nj = j + 1;
                    if (nj >= nvp || mesh.polys[p + nj] == RecastConstants.RC_MESH_NULL_IDX) {
                        nj = 0;
                    }
                    int va = mesh.polys[p + j] * 3;
                    int vb = mesh.polys[p + nj] * 3;
                    if (mesh.verts[va + 0] == 0 && mesh.verts[vb + 0] == 0) {
                        mesh.polys[p + nvp + j] = 32768;
                        continue;
                    }
                    if (mesh.verts[va + 2] == h && mesh.verts[vb + 2] == h) {
                        mesh.polys[p + nvp + j] = 32769;
                        continue;
                    }
                    if (mesh.verts[va + 0] == w && mesh.verts[vb + 0] == w) {
                        mesh.polys[p + nvp + j] = 32770;
                        continue;
                    }
                    if (mesh.verts[va + 2] != 0 || mesh.verts[vb + 2] != 0) continue;
                    mesh.polys[p + nvp + j] = 32771;
                }
            }
        }
        mesh.flags = new int[mesh.npolys];
        if (mesh.nverts > 65535) {
            throw new RuntimeException("rcBuildPolyMesh: The resulting mesh has too many vertices " + mesh.nverts + " (max " + 65535 + "). Data can be corrupted.");
        }
        if (mesh.npolys > 65535) {
            throw new RuntimeException("rcBuildPolyMesh: The resulting mesh has too many polygons " + mesh.npolys + " (max " + 65535 + "). Data can be corrupted.");
        }
        ctx.stopTimer("POLYMESH");
        return mesh;
    }

    public static PolyMesh mergePolyMeshes(Telemetry ctx, PolyMesh[] meshes, int nmeshes) {
        if (nmeshes == 0 || meshes == null) {
            return null;
        }
        ctx.startTimer("MERGE_POLYMESH");
        PolyMesh mesh = new PolyMesh();
        mesh.nvp = meshes[0].nvp;
        mesh.cs = meshes[0].cs;
        mesh.ch = meshes[0].ch;
        RecastVectors.copy(mesh.bmin, meshes[0].bmin, 0);
        RecastVectors.copy(mesh.bmax, meshes[0].bmax, 0);
        int maxVerts = 0;
        int maxPolys = 0;
        int maxVertsPerMesh = 0;
        for (int i = 0; i < nmeshes; ++i) {
            RecastVectors.min(mesh.bmin, meshes[i].bmin, 0);
            RecastVectors.max(mesh.bmax, meshes[i].bmax, 0);
            maxVertsPerMesh = Math.max(maxVertsPerMesh, meshes[i].nverts);
            maxVerts += meshes[i].nverts;
            maxPolys += meshes[i].npolys;
        }
        mesh.nverts = 0;
        mesh.verts = new int[maxVerts * 3];
        mesh.npolys = 0;
        mesh.polys = new int[maxPolys * 2 * mesh.nvp];
        Arrays.fill(mesh.polys, 0, mesh.polys.length, RecastConstants.RC_MESH_NULL_IDX);
        mesh.regs = new int[maxPolys];
        mesh.areas = new int[maxPolys];
        mesh.flags = new int[maxPolys];
        int[] nextVert = new int[maxVerts];
        int[] firstVert = new int[VERTEX_BUCKET_COUNT];
        for (int i = 0; i < VERTEX_BUCKET_COUNT; ++i) {
            firstVert[i] = -1;
        }
        int[] vremap = new int[maxVertsPerMesh];
        for (int i = 0; i < nmeshes; ++i) {
            int j;
            PolyMesh pmesh = meshes[i];
            int ox = (int)Math.floor((pmesh.bmin[0] - mesh.bmin[0]) / mesh.cs + 0.5f);
            int oz = (int)Math.floor((pmesh.bmin[2] - mesh.bmin[2]) / mesh.cs + 0.5f);
            boolean isMinX = ox == 0;
            boolean isMinZ = oz == 0;
            boolean isMaxX = Math.floor((mesh.bmax[0] - pmesh.bmax[0]) / mesh.cs + 0.5f) == 0.0;
            boolean isMaxZ = Math.floor((mesh.bmax[2] - pmesh.bmax[2]) / mesh.cs + 0.5f) == 0.0;
            boolean isOnBorder = isMinX || isMinZ || isMaxX || isMaxZ;
            for (j = 0; j < pmesh.nverts; ++j) {
                int v = j * 3;
                int[] inv = RecastMesh.addVertex(pmesh.verts[v + 0] + ox, pmesh.verts[v + 1], pmesh.verts[v + 2] + oz, mesh.verts, firstVert, nextVert, mesh.nverts);
                vremap[j] = inv[0];
                mesh.nverts = inv[1];
            }
            for (j = 0; j < pmesh.npolys; ++j) {
                int k;
                int tgt = mesh.npolys * 2 * mesh.nvp;
                int src = j * 2 * mesh.nvp;
                mesh.regs[mesh.npolys] = pmesh.regs[j];
                mesh.areas[mesh.npolys] = pmesh.areas[j];
                mesh.flags[mesh.npolys] = pmesh.flags[j];
                ++mesh.npolys;
                for (k = 0; k < mesh.nvp && pmesh.polys[src + k] != RecastConstants.RC_MESH_NULL_IDX; ++k) {
                    mesh.polys[tgt + k] = vremap[pmesh.polys[src + k]];
                }
                if (!isOnBorder) continue;
                block12: for (k = mesh.nvp; k < mesh.nvp * 2; ++k) {
                    if ((pmesh.polys[src + k] & 0x8000) == 0 || pmesh.polys[src + k] == 65535) continue;
                    int dir = pmesh.polys[src + k] & 0xF;
                    switch (dir) {
                        case 0: {
                            if (!isMinX) continue block12;
                            mesh.polys[tgt + k] = pmesh.polys[src + k];
                            continue block12;
                        }
                        case 1: {
                            if (!isMaxZ) continue block12;
                            mesh.polys[tgt + k] = pmesh.polys[src + k];
                            continue block12;
                        }
                        case 2: {
                            if (!isMaxX) continue block12;
                            mesh.polys[tgt + k] = pmesh.polys[src + k];
                            continue block12;
                        }
                        case 3: {
                            if (!isMinZ) continue block12;
                            mesh.polys[tgt + k] = pmesh.polys[src + k];
                        }
                    }
                }
            }
        }
        RecastMesh.buildMeshAdjacency(mesh.polys, mesh.npolys, mesh.nverts, mesh.nvp);
        if (mesh.nverts > 65535) {
            throw new RuntimeException("rcBuildPolyMesh: The resulting mesh has too many vertices " + mesh.nverts + " (max " + 65535 + "). Data can be corrupted.");
        }
        if (mesh.npolys > 65535) {
            throw new RuntimeException("rcBuildPolyMesh: The resulting mesh has too many polygons " + mesh.npolys + " (max " + 65535 + "). Data can be corrupted.");
        }
        ctx.stopTimer("MERGE_POLYMESH");
        return mesh;
    }

    public static PolyMesh copyPolyMesh(Telemetry ctx, PolyMesh src) {
        PolyMesh dst = new PolyMesh();
        dst.nverts = src.nverts;
        dst.npolys = src.npolys;
        dst.maxpolys = src.npolys;
        dst.nvp = src.nvp;
        RecastVectors.copy(dst.bmin, src.bmin, 0);
        RecastVectors.copy(dst.bmax, src.bmax, 0);
        dst.cs = src.cs;
        dst.ch = src.ch;
        dst.borderSize = src.borderSize;
        dst.maxEdgeError = src.maxEdgeError;
        dst.verts = new int[src.nverts * 3];
        System.arraycopy(src.verts, 0, dst.verts, 0, dst.verts.length);
        dst.polys = new int[src.npolys * 2 * src.nvp];
        System.arraycopy(src.polys, 0, dst.polys, 0, dst.polys.length);
        dst.regs = new int[src.npolys];
        System.arraycopy(src.regs, 0, dst.regs, 0, dst.regs.length);
        dst.areas = new int[src.npolys];
        System.arraycopy(src.areas, 0, dst.areas, 0, dst.areas.length);
        dst.flags = new int[src.npolys];
        System.arraycopy(src.flags, 0, dst.flags, 0, dst.flags.length);
        return dst;
    }

    private static class Edge {
        int[] vert = new int[2];
        int[] polyEdge = new int[2];
        int[] poly = new int[2];

        private Edge() {
        }
    }
}

