/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.recast4j.recast.CompactCell;
import org.recast4j.recast.CompactHeightfield;
import org.recast4j.recast.CompactSpan;
import org.recast4j.recast.PolyMesh;
import org.recast4j.recast.PolyMeshDetail;
import org.recast4j.recast.RecastCommon;
import org.recast4j.recast.RecastConstants;
import org.recast4j.recast.RecastMesh;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.Telemetry;

public class RecastMeshDetail {
    static int MAX_VERTS = 127;
    static int MAX_TRIS = 255;
    static int MAX_VERTS_PER_EDGE = 32;
    static int RC_UNSET_HEIGHT = RecastConstants.SPAN_MAX_HEIGHT;
    static int EV_UNDEF = -1;
    static int EV_HULL = -2;
    static final int RETRACT_SIZE = 256;

    private static float vdot2(float[] a, float[] b) {
        return a[0] * b[0] + a[2] * b[2];
    }

    private static float vdistSq2(float[] verts, int p, int q) {
        float dx = verts[q + 0] - verts[p + 0];
        float dy = verts[q + 2] - verts[p + 2];
        return dx * dx + dy * dy;
    }

    private static float vdist2(float[] verts, int p, int q) {
        return (float)Math.sqrt(RecastMeshDetail.vdistSq2(verts, p, q));
    }

    private static float vdistSq2(float[] p, float[] q) {
        float dx = q[0] - p[0];
        float dy = q[2] - p[2];
        return dx * dx + dy * dy;
    }

    private static float vdist2(float[] p, float[] q) {
        return (float)Math.sqrt(RecastMeshDetail.vdistSq2(p, q));
    }

    private static float vdistSq2(float[] p, float[] verts, int q) {
        float dx = verts[q + 0] - p[0];
        float dy = verts[q + 2] - p[2];
        return dx * dx + dy * dy;
    }

    private static float vdist2(float[] p, float[] verts, int q) {
        return (float)Math.sqrt(RecastMeshDetail.vdistSq2(p, verts, q));
    }

    private static float vcross2(float[] verts, int p1, int p2, int p3) {
        float u1 = verts[p2 + 0] - verts[p1 + 0];
        float v1 = verts[p2 + 2] - verts[p1 + 2];
        float u2 = verts[p3 + 0] - verts[p1 + 0];
        float v2 = verts[p3 + 2] - verts[p1 + 2];
        return u1 * v2 - v1 * u2;
    }

    private static float vcross2(float[] p1, float[] p2, float[] p3) {
        float u1 = p2[0] - p1[0];
        float v1 = p2[2] - p1[2];
        float u2 = p3[0] - p1[0];
        float v2 = p3[2] - p1[2];
        return u1 * v2 - v1 * u2;
    }

    private static boolean circumCircle(float[] verts, int p1, int p2, int p3, float[] c, AtomicReference<Float> r) {
        float EPS = 1.0E-6f;
        float[] v1 = new float[3];
        float[] v2 = new float[3];
        float[] v3 = new float[3];
        RecastVectors.sub(v2, verts, p2, p1);
        RecastVectors.sub(v3, verts, p3, p1);
        float cp = RecastMeshDetail.vcross2(v1, v2, v3);
        if (Math.abs(cp) > EPS) {
            float v1Sq = RecastMeshDetail.vdot2(v1, v1);
            float v2Sq = RecastMeshDetail.vdot2(v2, v2);
            float v3Sq = RecastMeshDetail.vdot2(v3, v3);
            c[0] = (v1Sq * (v2[2] - v3[2]) + v2Sq * (v3[2] - v1[2]) + v3Sq * (v1[2] - v2[2])) / (2.0f * cp);
            c[1] = 0.0f;
            c[2] = (v1Sq * (v3[0] - v2[0]) + v2Sq * (v1[0] - v3[0]) + v3Sq * (v2[0] - v1[0])) / (2.0f * cp);
            r.set(Float.valueOf(RecastMeshDetail.vdist2(c, v1)));
            RecastVectors.add(c, c, verts, p1);
            return true;
        }
        RecastVectors.copy(c, verts, p1);
        r.set(Float.valueOf(0.0f));
        return false;
    }

    private static float distPtTri(float[] p, float[] verts, int a, int b, int c) {
        float[] v0 = new float[3];
        float[] v1 = new float[3];
        float[] v2 = new float[3];
        RecastVectors.sub(v0, verts, c, a);
        RecastVectors.sub(v1, verts, b, a);
        RecastVectors.sub(v2, p, verts, a);
        float dot00 = RecastMeshDetail.vdot2(v0, v0);
        float dot01 = RecastMeshDetail.vdot2(v0, v1);
        float dot02 = RecastMeshDetail.vdot2(v0, v2);
        float dot11 = RecastMeshDetail.vdot2(v1, v1);
        float dot12 = RecastMeshDetail.vdot2(v1, v2);
        float invDenom = 1.0f / (dot00 * dot11 - dot01 * dot01);
        float u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        float v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        float EPS = 1.0E-4f;
        if (u >= -EPS && v >= -EPS && u + v <= 1.0f + EPS) {
            float y = verts[a + 1] + v0[1] * u + v1[1] * v;
            return Math.abs(y - p[1]);
        }
        return Float.MAX_VALUE;
    }

    private static float distancePtSeg(float[] verts, int pt, int p, int q) {
        float pqx = verts[q + 0] - verts[p + 0];
        float pqy = verts[q + 1] - verts[p + 1];
        float pqz = verts[q + 2] - verts[p + 2];
        float dx = verts[pt + 0] - verts[p + 0];
        float dy = verts[pt + 1] - verts[p + 1];
        float dz = verts[pt + 2] - verts[p + 2];
        float d = pqx * pqx + pqy * pqy + pqz * pqz;
        float t = pqx * dx + pqy * dy + pqz * dz;
        if (d > 0.0f) {
            t /= d;
        }
        if (t < 0.0f) {
            t = 0.0f;
        } else if (t > 1.0f) {
            t = 1.0f;
        }
        dx = verts[p + 0] + t * pqx - verts[pt + 0];
        dy = verts[p + 1] + t * pqy - verts[pt + 1];
        dz = verts[p + 2] + t * pqz - verts[pt + 2];
        return dx * dx + dy * dy + dz * dz;
    }

    private static float distancePtSeg2d(float[] verts, int pt, float[] poly, int p, int q) {
        float pqx = poly[q + 0] - poly[p + 0];
        float pqz = poly[q + 2] - poly[p + 2];
        float dx = verts[pt + 0] - poly[p + 0];
        float dz = verts[pt + 2] - poly[p + 2];
        float d = pqx * pqx + pqz * pqz;
        float t = pqx * dx + pqz * dz;
        if (d > 0.0f) {
            t /= d;
        }
        if (t < 0.0f) {
            t = 0.0f;
        } else if (t > 1.0f) {
            t = 1.0f;
        }
        dx = poly[p + 0] + t * pqx - verts[pt + 0];
        dz = poly[p + 2] + t * pqz - verts[pt + 2];
        return dx * dx + dz * dz;
    }

    private static float distToTriMesh(float[] p, float[] verts, int nverts, List<Integer> tris, int ntris) {
        float dmin = Float.MAX_VALUE;
        for (int i = 0; i < ntris; ++i) {
            int vc;
            int vb;
            int va = tris.get(i * 4 + 0) * 3;
            float d = RecastMeshDetail.distPtTri(p, verts, va, vb = tris.get(i * 4 + 1) * 3, vc = tris.get(i * 4 + 2) * 3);
            if (!(d < dmin)) continue;
            dmin = d;
        }
        if (dmin == Float.MAX_VALUE) {
            return -1.0f;
        }
        return dmin;
    }

    private static float distToPoly(int nvert, float[] verts, float[] p) {
        float dmin = Float.MAX_VALUE;
        boolean c = false;
        int i = 0;
        int j = nvert - 1;
        while (i < nvert) {
            int vj;
            int vi = i * 3;
            if (verts[vi + 2] > p[2] != verts[(vj = j * 3) + 2] > p[2] && p[0] < (verts[vj + 0] - verts[vi + 0]) * (p[2] - verts[vi + 2]) / (verts[vj + 2] - verts[vi + 2]) + verts[vi + 0]) {
                c = !c;
            }
            dmin = Math.min(dmin, RecastMeshDetail.distancePtSeg2d(p, 0, verts, vj, vi));
            j = i++;
        }
        return c ? -dmin : dmin;
    }

    private static int getHeight(float fx, float fy, float fz, float cs, float ics, float ch, int radius, HeightPatch hp) {
        int ix = (int)Math.floor(fx * ics + 0.01f);
        int iz = (int)Math.floor(fz * ics + 0.01f);
        int h = hp.data[(ix = RecastCommon.clamp(ix - hp.xmin, 0, hp.width - 1)) + (iz = RecastCommon.clamp(iz - hp.ymin, 0, hp.height - 1)) * hp.width];
        if (h == RC_UNSET_HEIGHT) {
            int x = 1;
            int z = 0;
            int dx = 1;
            int dz = 0;
            int maxSize = radius * 2 + 1;
            int maxIter = maxSize * maxSize - 1;
            int nextRingIterStart = 8;
            int nextRingIters = 16;
            float dmin = Float.MAX_VALUE;
            for (int i = 0; i < maxIter; ++i) {
                float d;
                int nh;
                int nx = ix + x;
                int nz = iz + z;
                if (nx >= 0 && nz >= 0 && nx < hp.width && nz < hp.height && (nh = hp.data[nx + nz * hp.width]) != RC_UNSET_HEIGHT && (d = Math.abs((float)nh * ch - fy)) < dmin) {
                    h = nh;
                    dmin = d;
                }
                if (i + 1 == nextRingIterStart) {
                    if (h != RC_UNSET_HEIGHT) break;
                    nextRingIterStart += nextRingIters;
                    nextRingIters += 8;
                }
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    int tmp = dx;
                    dx = -dz;
                    dz = tmp;
                }
                x += dx;
                z += dz;
            }
        }
        return h;
    }

    private static int findEdge(List<Integer> edges, int s, int t) {
        for (int i = 0; i < edges.size() / 4; ++i) {
            int e = i * 4;
            if ((edges.get(e + 0) != s || edges.get(e + 1) != t) && (edges.get(e + 0) != t || edges.get(e + 1) != s)) continue;
            return i;
        }
        return EV_UNDEF;
    }

    private static void addEdge(Telemetry ctx, List<Integer> edges, int maxEdges, int s, int t, int l, int r) {
        if (edges.size() / 4 >= maxEdges) {
            throw new RuntimeException("addEdge: Too many edges (" + edges.size() / 4 + "/" + maxEdges + ").");
        }
        int e = RecastMeshDetail.findEdge(edges, s, t);
        if (e == EV_UNDEF) {
            edges.add(s);
            edges.add(t);
            edges.add(l);
            edges.add(r);
        }
    }

    private static void updateLeftFace(List<Integer> edges, int e, int s, int t, int f) {
        if (edges.get(e + 0) == s && edges.get(e + 1) == t && edges.get(e + 2) == EV_UNDEF) {
            edges.set(e + 2, f);
        } else if (edges.get(e + 1) == s && edges.get(e + 0) == t && edges.get(e + 3) == EV_UNDEF) {
            edges.set(e + 3, f);
        }
    }

    private static boolean overlapSegSeg2d(float[] verts, int a, int b, int c, int d) {
        float a4;
        float a3;
        float a2;
        float a1 = RecastMeshDetail.vcross2(verts, a, b, d);
        return a1 * (a2 = RecastMeshDetail.vcross2(verts, a, b, c)) < 0.0f && (a3 = RecastMeshDetail.vcross2(verts, c, d, a)) * (a4 = a3 + a2 - a1) < 0.0f;
    }

    private static boolean overlapEdges(float[] pts, List<Integer> edges, int s1, int t1) {
        for (int i = 0; i < edges.size() / 4; ++i) {
            int s0 = edges.get(i * 4 + 0);
            int t0 = edges.get(i * 4 + 1);
            if (s0 == s1 || s0 == t1 || t0 == s1 || t0 == t1 || !RecastMeshDetail.overlapSegSeg2d(pts, s0 * 3, t0 * 3, s1 * 3, t1 * 3)) continue;
            return true;
        }
        return false;
    }

    static int completeFacet(Telemetry ctx, float[] pts, int npts, List<Integer> edges, int maxEdges, int nfaces, int e) {
        int t;
        int s;
        float EPS = 1.0E-5f;
        int edge = e * 4;
        if (edges.get(edge + 2) == EV_UNDEF) {
            s = edges.get(edge + 0);
            t = edges.get(edge + 1);
        } else if (edges.get(edge + 3) == EV_UNDEF) {
            s = edges.get(edge + 1);
            t = edges.get(edge + 0);
        } else {
            return nfaces;
        }
        int pt = npts;
        float[] c = new float[3];
        AtomicReference<Float> r = new AtomicReference<Float>(Float.valueOf(-1.0f));
        for (int u = 0; u < npts; ++u) {
            if (u == s || u == t || !(RecastMeshDetail.vcross2(pts, s * 3, t * 3, u * 3) > EPS)) continue;
            if (r.get().floatValue() < 0.0f) {
                pt = u;
                RecastMeshDetail.circumCircle(pts, s * 3, t * 3, u * 3, c, r);
                continue;
            }
            float d = RecastMeshDetail.vdist2(c, pts, u * 3);
            float tol = 0.001f;
            if (d > r.get().floatValue() * (1.0f + tol)) continue;
            if (d < r.get().floatValue() * (1.0f - tol)) {
                pt = u;
                RecastMeshDetail.circumCircle(pts, s * 3, t * 3, u * 3, c, r);
                continue;
            }
            if (RecastMeshDetail.overlapEdges(pts, edges, s, u) || RecastMeshDetail.overlapEdges(pts, edges, t, u)) continue;
            pt = u;
            RecastMeshDetail.circumCircle(pts, s * 3, t * 3, u * 3, c, r);
        }
        if (pt < npts) {
            RecastMeshDetail.updateLeftFace(edges, e * 4, s, t, nfaces);
            e = RecastMeshDetail.findEdge(edges, pt, s);
            if (e == EV_UNDEF) {
                RecastMeshDetail.addEdge(ctx, edges, maxEdges, pt, s, nfaces, EV_UNDEF);
            } else {
                RecastMeshDetail.updateLeftFace(edges, e * 4, pt, s, nfaces);
            }
            e = RecastMeshDetail.findEdge(edges, t, pt);
            if (e == EV_UNDEF) {
                RecastMeshDetail.addEdge(ctx, edges, maxEdges, t, pt, nfaces, EV_UNDEF);
            } else {
                RecastMeshDetail.updateLeftFace(edges, e * 4, t, pt, nfaces);
            }
            ++nfaces;
        } else {
            RecastMeshDetail.updateLeftFace(edges, e * 4, s, t, EV_HULL);
        }
        return nfaces;
    }

    private static void delaunayHull(Telemetry ctx, int npts, float[] pts, int nhull, int[] hull, List<Integer> tris) {
        int i;
        int nfaces = 0;
        int maxEdges = npts * 10;
        ArrayList<Integer> edges = new ArrayList<Integer>(64);
        int i2 = 0;
        int j = nhull - 1;
        while (i2 < nhull) {
            RecastMeshDetail.addEdge(ctx, edges, maxEdges, hull[j], hull[i2], EV_HULL, EV_UNDEF);
            j = i2++;
        }
        for (int currentEdge = 0; currentEdge < edges.size() / 4; ++currentEdge) {
            if ((Integer)edges.get(currentEdge * 4 + 2) == EV_UNDEF) {
                nfaces = RecastMeshDetail.completeFacet(ctx, pts, npts, edges, maxEdges, nfaces, currentEdge);
            }
            if ((Integer)edges.get(currentEdge * 4 + 3) != EV_UNDEF) continue;
            nfaces = RecastMeshDetail.completeFacet(ctx, pts, npts, edges, maxEdges, nfaces, currentEdge);
        }
        tris.clear();
        for (i = 0; i < nfaces * 4; ++i) {
            tris.add(-1);
        }
        for (i = 0; i < edges.size() / 4; ++i) {
            int t;
            int e = i * 4;
            if ((Integer)edges.get(e + 3) >= 0) {
                t = (Integer)edges.get(e + 3) * 4;
                if (tris.get(t + 0) == -1) {
                    tris.set(t + 0, (Integer)edges.get(e + 0));
                    tris.set(t + 1, (Integer)edges.get(e + 1));
                } else if (tris.get(t + 0) == edges.get(e + 1)) {
                    tris.set(t + 2, (Integer)edges.get(e + 0));
                } else if (tris.get(t + 1) == edges.get(e + 0)) {
                    tris.set(t + 2, (Integer)edges.get(e + 1));
                }
            }
            if ((Integer)edges.get(e + 2) < 0) continue;
            t = (Integer)edges.get(e + 2) * 4;
            if (tris.get(t + 0) == -1) {
                tris.set(t + 0, (Integer)edges.get(e + 1));
                tris.set(t + 1, (Integer)edges.get(e + 0));
                continue;
            }
            if (tris.get(t + 0) == edges.get(e + 0)) {
                tris.set(t + 2, (Integer)edges.get(e + 1));
                continue;
            }
            if (tris.get(t + 1) != edges.get(e + 1)) continue;
            tris.set(t + 2, (Integer)edges.get(e + 0));
        }
        for (i = 0; i < tris.size() / 4; ++i) {
            int t = i * 4;
            if (tris.get(t + 0) != -1 && tris.get(t + 1) != -1 && tris.get(t + 2) != -1) continue;
            System.err.println("Dangling! " + tris.get(t) + " " + tris.get(t + 1) + "  " + tris.get(t + 2));
            tris.set(t + 0, tris.get(tris.size() - 4));
            tris.set(t + 1, tris.get(tris.size() - 3));
            tris.set(t + 2, tris.get(tris.size() - 2));
            tris.set(t + 3, tris.get(tris.size() - 1));
            tris.remove(tris.size() - 1);
            tris.remove(tris.size() - 1);
            tris.remove(tris.size() - 1);
            tris.remove(tris.size() - 1);
            --i;
        }
    }

    private static float polyMinExtent(float[] verts, int nverts) {
        float minDist = Float.MAX_VALUE;
        for (int i = 0; i < nverts; ++i) {
            int ni = (i + 1) % nverts;
            int p1 = i * 3;
            int p2 = ni * 3;
            float maxEdgeDist = 0.0f;
            for (int j = 0; j < nverts; ++j) {
                if (j == i || j == ni) continue;
                float d = RecastMeshDetail.distancePtSeg2d(verts, j * 3, verts, p1, p2);
                maxEdgeDist = Math.max(maxEdgeDist, d);
            }
            minDist = Math.min(minDist, maxEdgeDist);
        }
        return (float)Math.sqrt(minDist);
    }

    private static void triangulateHull(int nverts, float[] verts, int nhull, int[] hull, int nin, List<Integer> tris) {
        int start = 0;
        int left = 1;
        int right = nhull - 1;
        float dmin = Float.MAX_VALUE;
        for (int i = 0; i < nhull; ++i) {
            if (hull[i] >= nin) continue;
            int pi = RecastMesh.prev(i, nhull);
            int ni = RecastMesh.next(i, nhull);
            int pv = hull[pi] * 3;
            int cv = hull[i] * 3;
            int nv = hull[ni] * 3;
            float d = RecastMeshDetail.vdist2(verts, pv, cv) + RecastMeshDetail.vdist2(verts, cv, nv) + RecastMeshDetail.vdist2(verts, nv, pv);
            if (!(d < dmin)) continue;
            start = i;
            left = ni;
            right = pi;
            dmin = d;
        }
        tris.add(hull[start]);
        tris.add(hull[left]);
        tris.add(hull[right]);
        tris.add(0);
        while (RecastMesh.next(left, nhull) != right) {
            float dright;
            int nleft = RecastMesh.next(left, nhull);
            int nright = RecastMesh.prev(right, nhull);
            int cvleft = hull[left] * 3;
            int nvleft = hull[nleft] * 3;
            int cvright = hull[right] * 3;
            int nvright = hull[nright] * 3;
            float dleft = RecastMeshDetail.vdist2(verts, cvleft, nvleft) + RecastMeshDetail.vdist2(verts, nvleft, cvright);
            if (dleft < (dright = RecastMeshDetail.vdist2(verts, cvright, nvright) + RecastMeshDetail.vdist2(verts, cvleft, nvright))) {
                tris.add(hull[left]);
                tris.add(hull[nleft]);
                tris.add(hull[right]);
                tris.add(0);
                left = nleft;
                continue;
            }
            tris.add(hull[left]);
            tris.add(hull[nright]);
            tris.add(hull[right]);
            tris.add(0);
            right = nright;
        }
    }

    private static float getJitterX(int i) {
        return (float)(i * -1918454973 & 0xFFFF) / 65535.0f * 2.0f - 1.0f;
    }

    private static float getJitterY(int i) {
        return (float)(i * -669632447 & 0xFFFF) / 65535.0f * 2.0f - 1.0f;
    }

    static int buildPolyDetail(Telemetry ctx, float[] in, int nin, float sampleDist, float sampleMaxError, int heightSearchRadius, CompactHeightfield chf, HeightPatch hp, float[] verts, List<Integer> tris) {
        int ntris;
        ArrayList<Integer> samples = new ArrayList<Integer>(512);
        int nverts = 0;
        float[] edge = new float[(MAX_VERTS_PER_EDGE + 1) * 3];
        int[] hull = new int[MAX_VERTS];
        int nhull = 0;
        nverts = nin;
        for (int i = 0; i < nin; ++i) {
            RecastVectors.copy(verts, i * 3, in, i * 3);
        }
        tris.clear();
        float cs = chf.cs;
        float ics = 1.0f / cs;
        float minExtent = RecastMeshDetail.polyMinExtent(verts, nverts);
        if (sampleDist > 0.0f) {
            int i = 0;
            int j = nin - 1;
            while (i < nin) {
                int vj = j * 3;
                int vi = i * 3;
                boolean swapped = false;
                if (Math.abs(in[vj + 0] - in[vi + 0]) < 1.0E-6f) {
                    if (in[vj + 2] > in[vi + 2]) {
                        int temp = vi;
                        vi = vj;
                        vj = temp;
                        swapped = true;
                    }
                } else if (in[vj + 0] > in[vi + 0]) {
                    int temp = vi;
                    vi = vj;
                    vj = temp;
                    swapped = true;
                }
                float dx = in[vi + 0] - in[vj + 0];
                float dy = in[vi + 1] - in[vj + 1];
                float dz = in[vi + 2] - in[vj + 2];
                float d = (float)Math.sqrt(dx * dx + dz * dz);
                int nn = 1 + (int)Math.floor(d / sampleDist);
                if (nn >= MAX_VERTS_PER_EDGE) {
                    nn = MAX_VERTS_PER_EDGE - 1;
                }
                if (nverts + nn >= MAX_VERTS) {
                    nn = MAX_VERTS - 1 - nverts;
                }
                for (int k = 0; k <= nn; ++k) {
                    float u = (float)k / (float)nn;
                    int pos = k * 3;
                    edge[pos + 0] = in[vj + 0] + dx * u;
                    edge[pos + 1] = in[vj + 1] + dy * u;
                    edge[pos + 2] = in[vj + 2] + dz * u;
                    edge[pos + 1] = (float)RecastMeshDetail.getHeight(edge[pos + 0], edge[pos + 1], edge[pos + 2], cs, ics, chf.ch, heightSearchRadius, hp) * chf.ch;
                }
                int[] idx = new int[MAX_VERTS_PER_EDGE];
                idx[0] = 0;
                idx[1] = nn;
                int nidx = 2;
                int k = 0;
                while (k < nidx - 1) {
                    int m;
                    int a = idx[k];
                    int b = idx[k + 1];
                    int va = a * 3;
                    int vb = b * 3;
                    float maxd = 0.0f;
                    int maxi = -1;
                    for (m = a + 1; m < b; ++m) {
                        float dev = RecastMeshDetail.distancePtSeg(edge, m * 3, va, vb);
                        if (!(dev > maxd)) continue;
                        maxd = dev;
                        maxi = m;
                    }
                    if (maxi != -1 && maxd > sampleMaxError * sampleMaxError) {
                        for (m = nidx; m > k; --m) {
                            idx[m] = idx[m - 1];
                        }
                        idx[k + 1] = maxi;
                        ++nidx;
                        continue;
                    }
                    ++k;
                }
                hull[nhull++] = j;
                if (swapped) {
                    for (k = nidx - 2; k > 0; --k) {
                        RecastVectors.copy(verts, nverts * 3, edge, idx[k] * 3);
                        hull[nhull++] = nverts++;
                    }
                } else {
                    for (k = 1; k < nidx - 1; ++k) {
                        RecastVectors.copy(verts, nverts * 3, edge, idx[k] * 3);
                        hull[nhull++] = nverts++;
                    }
                }
                j = i++;
            }
        }
        if (minExtent < sampleDist * 2.0f) {
            RecastMeshDetail.triangulateHull(nverts, verts, nhull, hull, nin, tris);
            return nverts;
        }
        RecastMeshDetail.triangulateHull(nverts, verts, nhull, hull, nin, tris);
        if (tris.size() == 0) {
            throw new RuntimeException("buildPolyDetail: Could not triangulate polygon (" + nverts + ") verts).");
        }
        if (sampleDist > 0.0f) {
            float[] bmin = new float[3];
            float[] bmax = new float[3];
            RecastVectors.copy(bmin, in, 0);
            RecastVectors.copy(bmax, in, 0);
            for (int i = 1; i < nin; ++i) {
                RecastVectors.min(bmin, in, i * 3);
                RecastVectors.max(bmax, in, i * 3);
            }
            int x0 = (int)Math.floor(bmin[0] / sampleDist);
            int x1 = (int)Math.ceil(bmax[0] / sampleDist);
            int z0 = (int)Math.floor(bmin[2] / sampleDist);
            int z1 = (int)Math.ceil(bmax[2] / sampleDist);
            samples.clear();
            for (int z = z0; z < z1; ++z) {
                for (int x = x0; x < x1; ++x) {
                    float[] pt = new float[]{(float)x * sampleDist, (bmax[1] + bmin[1]) * 0.5f, (float)z * sampleDist};
                    if (RecastMeshDetail.distToPoly(nin, in, pt) > -sampleDist / 2.0f) continue;
                    samples.add(x);
                    samples.add(RecastMeshDetail.getHeight(pt[0], pt[1], pt[2], cs, ics, chf.ch, heightSearchRadius, hp));
                    samples.add(z);
                    samples.add(0);
                }
            }
            int nsamples = samples.size() / 4;
            for (int iter = 0; iter < nsamples && nverts < MAX_VERTS; ++iter) {
                float[] bestpt = new float[3];
                float bestd = 0.0f;
                int besti = -1;
                for (int i = 0; i < nsamples; ++i) {
                    int s = i * 4;
                    if ((Integer)samples.get(s + 3) != 0) continue;
                    float[] pt = new float[]{(float)((Integer)samples.get(s + 0)).intValue() * sampleDist + RecastMeshDetail.getJitterX(i) * cs * 0.1f, (float)((Integer)samples.get(s + 1)).intValue() * chf.ch, (float)((Integer)samples.get(s + 2)).intValue() * sampleDist + RecastMeshDetail.getJitterY(i) * cs * 0.1f};
                    float d = RecastMeshDetail.distToTriMesh(pt, verts, nverts, tris, tris.size() / 4);
                    if (d < 0.0f || !(d > bestd)) continue;
                    bestd = d;
                    besti = i;
                    bestpt = pt;
                }
                if (bestd <= sampleMaxError || besti == -1) break;
                samples.set(besti * 4 + 3, 1);
                RecastVectors.copy(verts, nverts * 3, bestpt, 0);
                RecastMeshDetail.delaunayHull(ctx, ++nverts, verts, nhull, hull, tris);
            }
        }
        if ((ntris = tris.size() / 4) > MAX_TRIS) {
            List<Integer> subList = tris.subList(0, MAX_TRIS * 4);
            tris.clear();
            tris.addAll(subList);
            throw new RuntimeException("rcBuildPolyMeshDetail: Shrinking triangle count from " + ntris + " to max " + MAX_TRIS);
        }
        return nverts;
    }

    static void seedArrayWithPolyCenter(Telemetry ctx, CompactHeightfield chf, int[] meshpoly, int poly, int npoly, int[] verts, int bs, HeightPatch hp, List<Integer> array) {
        int[] offset = new int[]{0, 0, -1, -1, 0, -1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 1, -1, 0};
        int startCellX = 0;
        int startCellY = 0;
        int startSpanIndex = -1;
        int dmin = RC_UNSET_HEIGHT;
        for (int j = 0; j < npoly && dmin > 0; ++j) {
            for (int k = 0; k < 9 && dmin > 0; ++k) {
                int ax = verts[meshpoly[poly + j] * 3 + 0] + offset[k * 2 + 0];
                int ay = verts[meshpoly[poly + j] * 3 + 1];
                int az = verts[meshpoly[poly + j] * 3 + 2] + offset[k * 2 + 1];
                if (ax < hp.xmin || ax >= hp.xmin + hp.width || az < hp.ymin || az >= hp.ymin + hp.height) continue;
                CompactCell c = chf.cells[ax + bs + (az + bs) * chf.width];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni && dmin > 0; ++i) {
                    CompactSpan s = chf.spans[i];
                    int d = Math.abs(ay - s.y);
                    if (d >= dmin) continue;
                    startCellX = ax;
                    startCellY = az;
                    startSpanIndex = i;
                    dmin = d;
                }
            }
        }
        int pcx = 0;
        int pcy = 0;
        for (int j = 0; j < npoly; ++j) {
            pcx += verts[meshpoly[poly + j] * 3 + 0];
            pcy += verts[meshpoly[poly + j] * 3 + 2];
        }
        pcx /= npoly;
        pcy /= npoly;
        array.clear();
        array.add(startCellX);
        array.add(startCellY);
        array.add(startSpanIndex);
        int[] dirs = new int[]{0, 1, 2, 3};
        Arrays.fill(hp.data, 0, hp.width * hp.height, 0);
        int cx = -1;
        int cy = -1;
        int ci = -1;
        while (true) {
            if (array.size() < 3) {
                ctx.warn("Walk towards polygon center failed to reach center");
                break;
            }
            ci = array.remove(array.size() - 1);
            cy = array.remove(array.size() - 1);
            cx = array.remove(array.size() - 1);
            if (cx == pcx && cy == pcy) break;
            int directDir = cx == pcx ? RecastCommon.rcGetDirForOffset(0, pcy > cy ? 1 : -1) : RecastCommon.rcGetDirForOffset(pcx > cx ? 1 : -1, 0);
            int tmp = dirs[3];
            dirs[3] = dirs[directDir];
            dirs[directDir] = tmp;
            CompactSpan cs = chf.spans[ci];
            for (int i = 0; i < 4; ++i) {
                int dir = dirs[i];
                if (RecastCommon.GetCon(cs, dir) == 63) continue;
                int newX = cx + RecastCommon.GetDirOffsetX(dir);
                int newY = cy + RecastCommon.GetDirOffsetY(dir);
                int hpx = newX - hp.xmin;
                int hpy = newY - hp.ymin;
                if (hpx < 0 || hpx >= hp.width || hpy < 0 || hpy >= hp.height || hp.data[hpx + hpy * hp.width] != 0) continue;
                hp.data[hpx + hpy * hp.width] = 1;
                array.add(newX);
                array.add(newY);
                array.add(chf.cells[newX + bs + (newY + bs) * chf.width].index + RecastCommon.GetCon(cs, dir));
            }
            tmp = dirs[3];
            dirs[3] = dirs[directDir];
            dirs[directDir] = tmp;
        }
        array.clear();
        array.add(cx + bs);
        array.add(cy + bs);
        array.add(ci);
        Arrays.fill(hp.data, 0, hp.width * hp.height, RC_UNSET_HEIGHT);
        CompactSpan cs = chf.spans[ci];
        hp.data[cx - hp.xmin + (cy - hp.ymin) * hp.width] = cs.y;
    }

    static void push3(List<Integer> queue, int v1, int v2, int v3) {
        queue.add(v1);
        queue.add(v2);
        queue.add(v3);
    }

    static void getHeightData(Telemetry ctx, CompactHeightfield chf, int[] meshpolys, int poly, int npoly, int[] verts, int bs, HeightPatch hp, int region) {
        List<Integer> queue = new ArrayList<Integer>(512);
        Arrays.fill(hp.data, 0, hp.width * hp.height, RC_UNSET_HEIGHT);
        boolean empty = true;
        if (region != RecastConstants.RC_MULTIPLE_REGS) {
            for (int hy = 0; hy < hp.height; ++hy) {
                int y = hp.ymin + hy + bs;
                block1: for (int hx = 0; hx < hp.width; ++hx) {
                    int x = hp.xmin + hx + bs;
                    CompactCell c = chf.cells[x + y * chf.width];
                    int ni = c.index + c.count;
                    for (int i = c.index; i < ni; ++i) {
                        CompactSpan s = chf.spans[i];
                        if (s.reg != region) continue;
                        hp.data[hx + hy * hp.width] = s.y;
                        empty = false;
                        boolean border = false;
                        for (int dir = 0; dir < 4; ++dir) {
                            if (RecastCommon.GetCon(s, dir) == 63) continue;
                            int ax = x + RecastCommon.GetDirOffsetX(dir);
                            int ay = y + RecastCommon.GetDirOffsetY(dir);
                            int ai = chf.cells[ax + ay * chf.width].index + RecastCommon.GetCon(s, dir);
                            CompactSpan as = chf.spans[ai];
                            if (as.reg == region) continue;
                            border = true;
                            break;
                        }
                        if (!border) continue block1;
                        RecastMeshDetail.push3(queue, x, y, i);
                        continue block1;
                    }
                }
            }
        }
        if (empty) {
            RecastMeshDetail.seedArrayWithPolyCenter(ctx, chf, meshpolys, poly, npoly, verts, bs, hp, queue);
        }
        int head = 0;
        while (head * 3 < queue.size()) {
            int cx = (Integer)queue.get(head * 3 + 0);
            int cy = (Integer)queue.get(head * 3 + 1);
            int ci = (Integer)queue.get(head * 3 + 2);
            if (++head >= 256) {
                head = 0;
                queue = queue.subList(768, queue.size());
            }
            CompactSpan cs = chf.spans[ci];
            for (int dir = 0; dir < 4; ++dir) {
                if (RecastCommon.GetCon(cs, dir) == 63) continue;
                int ax = cx + RecastCommon.GetDirOffsetX(dir);
                int ay = cy + RecastCommon.GetDirOffsetY(dir);
                int hx = ax - hp.xmin - bs;
                int hy = ay - hp.ymin - bs;
                if (hx < 0 || hx >= hp.width || hy < 0 || hy >= hp.height || hp.data[hx + hy * hp.width] != RC_UNSET_HEIGHT) continue;
                int ai = chf.cells[ax + ay * chf.width].index + RecastCommon.GetCon(cs, dir);
                CompactSpan as = chf.spans[ai];
                hp.data[hx + hy * hp.width] = as.y;
                RecastMeshDetail.push3(queue, ax, ay, ai);
            }
        }
    }

    static int getEdgeFlags(float[] verts, int va, int vb, float[] vpoly, int npoly) {
        float thrSqr = 1.0000001E-6f;
        int i = 0;
        int j = npoly - 1;
        while (i < npoly) {
            if (RecastMeshDetail.distancePtSeg2d(verts, va, vpoly, j * 3, i * 3) < thrSqr && RecastMeshDetail.distancePtSeg2d(verts, vb, vpoly, j * 3, i * 3) < thrSqr) {
                return 1;
            }
            j = i++;
        }
        return 0;
    }

    static int getTriFlags(float[] verts, int va, int vb, int vc, float[] vpoly, int npoly) {
        int flags = 0;
        flags |= RecastMeshDetail.getEdgeFlags(verts, va, vb, vpoly, npoly) << 0;
        flags |= RecastMeshDetail.getEdgeFlags(verts, vb, vc, vpoly, npoly) << 2;
        return flags |= RecastMeshDetail.getEdgeFlags(verts, vc, va, vpoly, npoly) << 4;
    }

    public static PolyMeshDetail buildPolyMeshDetail(Telemetry ctx, PolyMesh mesh, CompactHeightfield chf, float sampleDist, float sampleMaxError) {
        ctx.startTimer("POLYMESHDETAIL");
        if (mesh.nverts == 0 || mesh.npolys == 0) {
            return null;
        }
        PolyMeshDetail dmesh = new PolyMeshDetail();
        int nvp = mesh.nvp;
        float cs = mesh.cs;
        float ch = mesh.ch;
        float[] orig = mesh.bmin;
        int borderSize = mesh.borderSize;
        int heightSearchRadius = (int)Math.max(1.0, Math.ceil(mesh.maxEdgeError));
        ArrayList<Integer> tris = new ArrayList<Integer>(512);
        float[] verts = new float[768];
        HeightPatch hp = new HeightPatch();
        int nPolyVerts = 0;
        int maxhw = 0;
        int maxhh = 0;
        int[] bounds = new int[mesh.npolys * 4];
        float[] poly = new float[nvp * 3];
        for (int i = 0; i < mesh.npolys; ++i) {
            int p = i * nvp * 2;
            bounds[i * 4 + 0] = chf.width;
            bounds[i * 4 + 1] = 0;
            bounds[i * 4 + 2] = chf.height;
            bounds[i * 4 + 3] = 0;
            for (int j = 0; j < nvp && mesh.polys[p + j] != RecastConstants.RC_MESH_NULL_IDX; ++j) {
                int v = mesh.polys[p + j] * 3;
                bounds[i * 4 + 0] = Math.min(bounds[i * 4 + 0], mesh.verts[v + 0]);
                bounds[i * 4 + 1] = Math.max(bounds[i * 4 + 1], mesh.verts[v + 0]);
                bounds[i * 4 + 2] = Math.min(bounds[i * 4 + 2], mesh.verts[v + 2]);
                bounds[i * 4 + 3] = Math.max(bounds[i * 4 + 3], mesh.verts[v + 2]);
                ++nPolyVerts;
            }
            bounds[i * 4 + 0] = Math.max(0, bounds[i * 4 + 0] - 1);
            bounds[i * 4 + 1] = Math.min(chf.width, bounds[i * 4 + 1] + 1);
            bounds[i * 4 + 2] = Math.max(0, bounds[i * 4 + 2] - 1);
            bounds[i * 4 + 3] = Math.min(chf.height, bounds[i * 4 + 3] + 1);
            if (bounds[i * 4 + 0] >= bounds[i * 4 + 1] || bounds[i * 4 + 2] >= bounds[i * 4 + 3]) continue;
            maxhw = Math.max(maxhw, bounds[i * 4 + 1] - bounds[i * 4 + 0]);
            maxhh = Math.max(maxhh, bounds[i * 4 + 3] - bounds[i * 4 + 2]);
        }
        hp.data = new int[maxhw * maxhh];
        dmesh.nmeshes = mesh.npolys;
        dmesh.nverts = 0;
        dmesh.ntris = 0;
        dmesh.meshes = new int[dmesh.nmeshes * 4];
        int vcap = nPolyVerts + nPolyVerts / 2;
        int tcap = vcap * 2;
        dmesh.nverts = 0;
        dmesh.verts = new float[vcap * 3];
        dmesh.ntris = 0;
        dmesh.tris = new int[tcap * 4];
        for (int i = 0; i < mesh.npolys; ++i) {
            int j;
            int p = i * nvp * 2;
            int npoly = 0;
            for (int j2 = 0; j2 < nvp && mesh.polys[p + j2] != RecastConstants.RC_MESH_NULL_IDX; ++j2) {
                int v = mesh.polys[p + j2] * 3;
                poly[j2 * 3 + 0] = (float)mesh.verts[v + 0] * cs;
                poly[j2 * 3 + 1] = (float)mesh.verts[v + 1] * ch;
                poly[j2 * 3 + 2] = (float)mesh.verts[v + 2] * cs;
                ++npoly;
            }
            hp.xmin = bounds[i * 4 + 0];
            hp.ymin = bounds[i * 4 + 2];
            hp.width = bounds[i * 4 + 1] - bounds[i * 4 + 0];
            hp.height = bounds[i * 4 + 3] - bounds[i * 4 + 2];
            RecastMeshDetail.getHeightData(ctx, chf, mesh.polys, p, npoly, mesh.verts, borderSize, hp, mesh.regs[i]);
            int nverts = RecastMeshDetail.buildPolyDetail(ctx, poly, npoly, sampleDist, sampleMaxError, heightSearchRadius, chf, hp, verts, tris);
            for (j = 0; j < nverts; ++j) {
                int n = j * 3 + 0;
                verts[n] = verts[n] + orig[0];
                int n2 = j * 3 + 1;
                verts[n2] = verts[n2] + (orig[1] + chf.ch);
                int n3 = j * 3 + 2;
                verts[n3] = verts[n3] + orig[2];
            }
            for (j = 0; j < npoly; ++j) {
                int n = j * 3 + 0;
                poly[n] = poly[n] + orig[0];
                int n4 = j * 3 + 1;
                poly[n4] = poly[n4] + orig[1];
                int n5 = j * 3 + 2;
                poly[n5] = poly[n5] + orig[2];
            }
            int ntris = tris.size() / 4;
            dmesh.meshes[i * 4 + 0] = dmesh.nverts;
            dmesh.meshes[i * 4 + 1] = nverts;
            dmesh.meshes[i * 4 + 2] = dmesh.ntris;
            dmesh.meshes[i * 4 + 3] = ntris;
            if (dmesh.nverts + nverts > vcap) {
                while (dmesh.nverts + nverts > vcap) {
                    vcap += 256;
                }
                float[] newv = new float[vcap * 3];
                if (dmesh.nverts != 0) {
                    System.arraycopy(dmesh.verts, 0, newv, 0, 3 * dmesh.nverts);
                }
                dmesh.verts = newv;
            }
            for (int j3 = 0; j3 < nverts; ++j3) {
                dmesh.verts[dmesh.nverts * 3 + 0] = verts[j3 * 3 + 0];
                dmesh.verts[dmesh.nverts * 3 + 1] = verts[j3 * 3 + 1];
                dmesh.verts[dmesh.nverts * 3 + 2] = verts[j3 * 3 + 2];
                ++dmesh.nverts;
            }
            if (dmesh.ntris + ntris > tcap) {
                while (dmesh.ntris + ntris > tcap) {
                    tcap += 256;
                }
                int[] newt = new int[tcap * 4];
                if (dmesh.ntris != 0) {
                    System.arraycopy(dmesh.tris, 0, newt, 0, 4 * dmesh.ntris);
                }
                dmesh.tris = newt;
            }
            for (int j4 = 0; j4 < ntris; ++j4) {
                int t = j4 * 4;
                dmesh.tris[dmesh.ntris * 4 + 0] = (Integer)tris.get(t + 0);
                dmesh.tris[dmesh.ntris * 4 + 1] = (Integer)tris.get(t + 1);
                dmesh.tris[dmesh.ntris * 4 + 2] = (Integer)tris.get(t + 2);
                dmesh.tris[dmesh.ntris * 4 + 3] = RecastMeshDetail.getTriFlags(verts, (Integer)tris.get(t + 0) * 3, (Integer)tris.get(t + 1) * 3, (Integer)tris.get(t + 2) * 3, poly, npoly);
                ++dmesh.ntris;
            }
        }
        ctx.stopTimer("POLYMESHDETAIL");
        return dmesh;
    }

    PolyMeshDetail mergePolyMeshDetails(Telemetry ctx, PolyMeshDetail[] meshes, int nmeshes) {
        int i;
        PolyMeshDetail mesh = new PolyMeshDetail();
        ctx.startTimer("MERGE_POLYMESHDETAIL");
        int maxVerts = 0;
        int maxTris = 0;
        int maxMeshes = 0;
        for (i = 0; i < nmeshes; ++i) {
            if (meshes[i] == null) continue;
            maxVerts += meshes[i].nverts;
            maxTris += meshes[i].ntris;
            maxMeshes += meshes[i].nmeshes;
        }
        mesh.nmeshes = 0;
        mesh.meshes = new int[maxMeshes * 4];
        mesh.ntris = 0;
        mesh.tris = new int[maxTris * 4];
        mesh.nverts = 0;
        mesh.verts = new float[maxVerts * 3];
        for (i = 0; i < nmeshes; ++i) {
            int k;
            PolyMeshDetail dm = meshes[i];
            if (dm == null) continue;
            for (int j = 0; j < dm.nmeshes; ++j) {
                int dst = mesh.nmeshes * 4;
                int src = j * 4;
                mesh.meshes[dst + 0] = mesh.nverts + dm.meshes[src + 0];
                mesh.meshes[dst + 1] = dm.meshes[src + 1];
                mesh.meshes[dst + 2] = mesh.ntris + dm.meshes[src + 2];
                mesh.meshes[dst + 3] = dm.meshes[src + 3];
                ++mesh.nmeshes;
            }
            for (k = 0; k < dm.nverts; ++k) {
                RecastVectors.copy(mesh.verts, mesh.nverts * 3, dm.verts, k * 3);
                ++mesh.nverts;
            }
            for (k = 0; k < dm.ntris; ++k) {
                mesh.tris[mesh.ntris * 4 + 0] = dm.tris[k * 4 + 0];
                mesh.tris[mesh.ntris * 4 + 1] = dm.tris[k * 4 + 1];
                mesh.tris[mesh.ntris * 4 + 2] = dm.tris[k * 4 + 2];
                mesh.tris[mesh.ntris * 4 + 3] = dm.tris[k * 4 + 3];
                ++mesh.ntris;
            }
        }
        ctx.stopTimer("MERGE_POLYMESHDETAIL");
        return mesh;
    }

    private static class HeightPatch {
        int xmin;
        int ymin;
        int width;
        int height;
        int[] data;

        private HeightPatch() {
        }
    }
}

