/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import org.recast4j.recast.Heightfield;
import org.recast4j.recast.RecastCommon;
import org.recast4j.recast.RecastConstants;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.Span;
import org.recast4j.recast.Telemetry;

public class RecastRasterization {
    private static boolean overlapBounds(float[] amin, float[] amax, float[] bmin, float[] bmax) {
        boolean overlap = true;
        overlap = amin[0] > bmax[0] || amax[0] < bmin[0] ? false : overlap;
        overlap = amin[1] > bmax[1] || amax[1] < bmin[1] ? false : overlap;
        overlap = amin[2] > bmax[2] || amax[2] < bmin[2] ? false : overlap;
        return overlap;
    }

    public static void addSpan(Heightfield heightfield, int x, int y, int spanMin, int spanMax, int areaId, int flagMergeThreshold) {
        int idx = x + y * heightfield.width;
        Span s = new Span();
        s.smin = spanMin;
        s.smax = spanMax;
        s.area = areaId;
        s.next = null;
        if (heightfield.spans[idx] == null) {
            heightfield.spans[idx] = s;
            return;
        }
        Span prev = null;
        Span cur = heightfield.spans[idx];
        while (cur != null && cur.smin <= s.smax) {
            if (cur.smax < s.smin) {
                prev = cur;
                cur = cur.next;
                continue;
            }
            if (cur.smin < s.smin) {
                s.smin = cur.smin;
            }
            if (cur.smax > s.smax) {
                s.smax = cur.smax;
            }
            if (Math.abs(s.smax - cur.smax) <= flagMergeThreshold) {
                s.area = Math.max(s.area, cur.area);
            }
            Span next = cur.next;
            if (prev != null) {
                prev.next = next;
            } else {
                heightfield.spans[idx] = next;
            }
            cur = next;
        }
        if (prev != null) {
            s.next = prev.next;
            prev.next = s;
        } else {
            s.next = heightfield.spans[idx];
            heightfield.spans[idx] = s;
        }
    }

    private static int[] dividePoly(float[] inVerts, int inVertsOffset, int inVertsCount, int outVerts1, int outVerts2, float axisOffset, int axis) {
        float[] d = new float[12];
        for (int i = 0; i < inVertsCount; ++i) {
            d[i] = axisOffset - inVerts[inVertsOffset + i * 3 + axis];
        }
        int m = 0;
        int n = 0;
        int i = 0;
        int j = inVertsCount - 1;
        while (i < inVertsCount) {
            block10: {
                block11: {
                    block9: {
                        boolean inb;
                        boolean ina = d[j] >= 0.0f;
                        boolean bl = inb = d[i] >= 0.0f;
                        if (ina == inb) break block9;
                        float s = d[j] / (d[j] - d[i]);
                        inVerts[outVerts1 + m * 3 + 0] = inVerts[inVertsOffset + j * 3 + 0] + (inVerts[inVertsOffset + i * 3 + 0] - inVerts[inVertsOffset + j * 3 + 0]) * s;
                        inVerts[outVerts1 + m * 3 + 1] = inVerts[inVertsOffset + j * 3 + 1] + (inVerts[inVertsOffset + i * 3 + 1] - inVerts[inVertsOffset + j * 3 + 1]) * s;
                        inVerts[outVerts1 + m * 3 + 2] = inVerts[inVertsOffset + j * 3 + 2] + (inVerts[inVertsOffset + i * 3 + 2] - inVerts[inVertsOffset + j * 3 + 2]) * s;
                        RecastVectors.copy(inVerts, outVerts2 + n * 3, inVerts, outVerts1 + m * 3);
                        ++m;
                        ++n;
                        if (d[i] > 0.0f) {
                            RecastVectors.copy(inVerts, outVerts1 + m * 3, inVerts, inVertsOffset + i * 3);
                            ++m;
                        } else if (d[i] < 0.0f) {
                            RecastVectors.copy(inVerts, outVerts2 + n * 3, inVerts, inVertsOffset + i * 3);
                            ++n;
                        }
                        break block10;
                    }
                    if (!(d[i] >= 0.0f)) break block11;
                    RecastVectors.copy(inVerts, outVerts1 + m * 3, inVerts, inVertsOffset + i * 3);
                    ++m;
                    if (d[i] != 0.0f) break block10;
                }
                RecastVectors.copy(inVerts, outVerts2 + n * 3, inVerts, inVertsOffset + i * 3);
                ++n;
            }
            j = i++;
        }
        return new int[]{m, n};
    }

    private static void rasterizeTri(float[] verts, int v0, int v1, int v2, int area, Heightfield hf, float[] hfBBMin, float[] hfBBMax, float cellSize, float inverseCellSize, float inverseCellHeight, int flagMergeThreshold) {
        float[] tmin = new float[3];
        float[] tmax = new float[3];
        float by = hfBBMax[1] - hfBBMin[1];
        RecastVectors.copy(tmin, verts, v0 * 3);
        RecastVectors.copy(tmax, verts, v0 * 3);
        RecastVectors.min(tmin, verts, v1 * 3);
        RecastVectors.min(tmin, verts, v2 * 3);
        RecastVectors.max(tmax, verts, v1 * 3);
        RecastVectors.max(tmax, verts, v2 * 3);
        if (!RecastRasterization.overlapBounds(hfBBMin, hfBBMax, tmin, tmax)) {
            return;
        }
        int z0 = (int)((tmin[2] - hfBBMin[2]) * inverseCellSize);
        int z1 = (int)((tmax[2] - hfBBMin[2]) * inverseCellSize);
        int w = hf.width;
        int h = hf.height;
        z0 = RecastCommon.clamp(z0, -1, h - 1);
        z1 = RecastCommon.clamp(z1, 0, h - 1);
        float[] buf = new float[84];
        int in = 0;
        int inRow = 21;
        int p1 = inRow + 21;
        int p2 = p1 + 21;
        RecastVectors.copy(buf, 0, verts, v0 * 3);
        RecastVectors.copy(buf, 3, verts, v1 * 3);
        RecastVectors.copy(buf, 6, verts, v2 * 3);
        int nvIn = 3;
        for (int z = z0; z <= z1; ++z) {
            float cellZ = hfBBMin[2] + (float)z * cellSize;
            int[] nvrowin = RecastRasterization.dividePoly(buf, in, nvIn, inRow, p1, cellZ + cellSize, 2);
            int nvRow = nvrowin[0];
            nvIn = nvrowin[1];
            int temp = in;
            in = p1;
            p1 = temp;
            if (nvRow < 3 || z < 0) continue;
            float minX = buf[inRow];
            float maxX = buf[inRow];
            for (int i = 1; i < nvRow; ++i) {
                float v = buf[inRow + i * 3];
                minX = Math.min(minX, v);
                maxX = Math.max(maxX, v);
            }
            int x0 = (int)((minX - hfBBMin[0]) * inverseCellSize);
            int x1 = (int)((maxX - hfBBMin[0]) * inverseCellSize);
            if (x1 < 0 || x0 >= w) continue;
            x0 = RecastCommon.clamp(x0, -1, w - 1);
            x1 = RecastCommon.clamp(x1, 0, w - 1);
            int nv2 = nvRow;
            for (int x = x0; x <= x1; ++x) {
                float cx = hfBBMin[0] + (float)x * cellSize;
                int[] nvnv2 = RecastRasterization.dividePoly(buf, inRow, nv2, p1, p2, cx + cellSize, 0);
                int nv = nvnv2[0];
                nv2 = nvnv2[1];
                int temp2 = inRow;
                inRow = p2;
                p2 = temp2;
                if (nv < 3 || x < 0) continue;
                float spanMin = buf[p1 + 1];
                float spanMax = buf[p1 + 1];
                for (int i = 1; i < nv; ++i) {
                    spanMin = Math.min(spanMin, buf[p1 + i * 3 + 1]);
                    spanMax = Math.max(spanMax, buf[p1 + i * 3 + 1]);
                }
                if ((spanMax -= hfBBMin[1]) < 0.0f || (spanMin -= hfBBMin[1]) > by) continue;
                if (spanMin < 0.0f) {
                    spanMin = 0.0f;
                }
                if (spanMax > by) {
                    spanMax = by;
                }
                int spanMinCellIndex = RecastCommon.clamp((int)Math.floor(spanMin * inverseCellHeight), 0, RecastConstants.SPAN_MAX_HEIGHT);
                int spanMaxCellIndex = RecastCommon.clamp((int)Math.ceil(spanMax * inverseCellHeight), spanMinCellIndex + 1, RecastConstants.SPAN_MAX_HEIGHT);
                RecastRasterization.addSpan(hf, x, z, spanMinCellIndex, spanMaxCellIndex, area, flagMergeThreshold);
            }
        }
    }

    public static void rasterizeTriangle(Heightfield heightfield, float[] verts, int v0, int v1, int v2, int areaId, int flagMergeThreshold, Telemetry ctx) {
        ctx.startTimer("RASTERIZE_TRIANGLES");
        float inverseCellSize = 1.0f / heightfield.cs;
        float inverseCellHeight = 1.0f / heightfield.ch;
        RecastRasterization.rasterizeTri(verts, v0, v1, v2, areaId, heightfield, heightfield.bmin, heightfield.bmax, heightfield.cs, inverseCellSize, inverseCellHeight, flagMergeThreshold);
        ctx.stopTimer("RASTERIZE_TRIANGLES");
    }

    public static void rasterizeTriangles(Heightfield heightfield, float[] verts, int[] tris, int[] areaIds, int numTris, int flagMergeThreshold, Telemetry ctx) {
        ctx.startTimer("RASTERIZE_TRIANGLES");
        float inverseCellSize = 1.0f / heightfield.cs;
        float inverseCellHeight = 1.0f / heightfield.ch;
        for (int triIndex = 0; triIndex < numTris; ++triIndex) {
            int v0 = tris[triIndex * 3 + 0];
            int v1 = tris[triIndex * 3 + 1];
            int v2 = tris[triIndex * 3 + 2];
            RecastRasterization.rasterizeTri(verts, v0, v1, v2, areaIds[triIndex], heightfield, heightfield.bmin, heightfield.bmax, heightfield.cs, inverseCellSize, inverseCellHeight, flagMergeThreshold);
        }
        ctx.stopTimer("RASTERIZE_TRIANGLES");
    }

    public static void rasterizeTriangles(Heightfield heightfield, float[] verts, int[] areaIds, int numTris, int flagMergeThreshold, Telemetry ctx) {
        ctx.startTimer("RASTERIZE_TRIANGLES");
        float inverseCellSize = 1.0f / heightfield.cs;
        float inverseCellHeight = 1.0f / heightfield.ch;
        for (int triIndex = 0; triIndex < numTris; ++triIndex) {
            int v0 = triIndex * 3 + 0;
            int v1 = triIndex * 3 + 1;
            int v2 = triIndex * 3 + 2;
            RecastRasterization.rasterizeTri(verts, v0, v1, v2, areaIds[triIndex], heightfield, heightfield.bmin, heightfield.bmax, heightfield.cs, inverseCellSize, inverseCellHeight, flagMergeThreshold);
        }
        ctx.stopTimer("RASTERIZE_TRIANGLES");
    }
}

