/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.recast4j.recast.CompactCell;
import org.recast4j.recast.CompactHeightfield;
import org.recast4j.recast.CompactSpan;
import org.recast4j.recast.RecastCommon;
import org.recast4j.recast.RecastConstants;
import org.recast4j.recast.Telemetry;

public class RecastRegion {
    static final int RC_NULL_NEI = 65535;

    public static int calculateDistanceField(CompactHeightfield chf, int[] src) {
        int aai;
        int aay;
        int aax;
        int ai;
        int ay;
        int ax;
        CompactSpan s;
        int i;
        int ni;
        CompactCell c;
        int x;
        int y;
        int i2;
        int w = chf.width;
        int h = chf.height;
        for (i2 = 0; i2 < chf.spanCount; ++i2) {
            src[i2] = 65535;
        }
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                c = chf.cells[x + y * w];
                ni = c.index + c.count;
                for (i = c.index; i < ni; ++i) {
                    s = chf.spans[i];
                    int area = chf.areas[i];
                    int nc = 0;
                    for (int dir = 0; dir < 4; ++dir) {
                        if (RecastCommon.GetCon(s, dir) == 63) continue;
                        int ax2 = x + RecastCommon.GetDirOffsetX(dir);
                        int ay2 = y + RecastCommon.GetDirOffsetY(dir);
                        int ai2 = chf.cells[ax2 + ay2 * w].index + RecastCommon.GetCon(s, dir);
                        if (area != chf.areas[ai2]) continue;
                        ++nc;
                    }
                    if (nc == 4) continue;
                    src[i] = 0;
                }
            }
        }
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                c = chf.cells[x + y * w];
                ni = c.index + c.count;
                for (i = c.index; i < ni; ++i) {
                    CompactSpan as;
                    s = chf.spans[i];
                    if (RecastCommon.GetCon(s, 0) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(0);
                        ay = y + RecastCommon.GetDirOffsetY(0);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 0);
                        as = chf.spans[ai];
                        if (src[ai] + 2 < src[i]) {
                            src[i] = src[ai] + 2;
                        }
                        if (RecastCommon.GetCon(as, 3) != 63) {
                            aax = ax + RecastCommon.GetDirOffsetX(3);
                            aay = ay + RecastCommon.GetDirOffsetY(3);
                            aai = chf.cells[aax + aay * w].index + RecastCommon.GetCon(as, 3);
                            if (src[aai] + 3 < src[i]) {
                                src[i] = src[aai] + 3;
                            }
                        }
                    }
                    if (RecastCommon.GetCon(s, 3) == 63) continue;
                    ax = x + RecastCommon.GetDirOffsetX(3);
                    ay = y + RecastCommon.GetDirOffsetY(3);
                    ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 3);
                    as = chf.spans[ai];
                    if (src[ai] + 2 < src[i]) {
                        src[i] = src[ai] + 2;
                    }
                    if (RecastCommon.GetCon(as, 2) == 63) continue;
                    aax = ax + RecastCommon.GetDirOffsetX(2);
                    aay = ay + RecastCommon.GetDirOffsetY(2);
                    aai = chf.cells[aax + aay * w].index + RecastCommon.GetCon(as, 2);
                    if (src[aai] + 3 >= src[i]) continue;
                    src[i] = src[aai] + 3;
                }
            }
        }
        for (y = h - 1; y >= 0; --y) {
            for (x = w - 1; x >= 0; --x) {
                c = chf.cells[x + y * w];
                ni = c.index + c.count;
                for (i = c.index; i < ni; ++i) {
                    CompactSpan as;
                    s = chf.spans[i];
                    if (RecastCommon.GetCon(s, 2) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(2);
                        ay = y + RecastCommon.GetDirOffsetY(2);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 2);
                        as = chf.spans[ai];
                        if (src[ai] + 2 < src[i]) {
                            src[i] = src[ai] + 2;
                        }
                        if (RecastCommon.GetCon(as, 1) != 63) {
                            aax = ax + RecastCommon.GetDirOffsetX(1);
                            aay = ay + RecastCommon.GetDirOffsetY(1);
                            aai = chf.cells[aax + aay * w].index + RecastCommon.GetCon(as, 1);
                            if (src[aai] + 3 < src[i]) {
                                src[i] = src[aai] + 3;
                            }
                        }
                    }
                    if (RecastCommon.GetCon(s, 1) == 63) continue;
                    ax = x + RecastCommon.GetDirOffsetX(1);
                    ay = y + RecastCommon.GetDirOffsetY(1);
                    ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 1);
                    as = chf.spans[ai];
                    if (src[ai] + 2 < src[i]) {
                        src[i] = src[ai] + 2;
                    }
                    if (RecastCommon.GetCon(as, 0) == 63) continue;
                    aax = ax + RecastCommon.GetDirOffsetX(0);
                    aay = ay + RecastCommon.GetDirOffsetY(0);
                    aai = chf.cells[aax + aay * w].index + RecastCommon.GetCon(as, 0);
                    if (src[aai] + 3 >= src[i]) continue;
                    src[i] = src[aai] + 3;
                }
            }
        }
        int maxDist = 0;
        for (i2 = 0; i2 < chf.spanCount; ++i2) {
            maxDist = Math.max(src[i2], maxDist);
        }
        return maxDist;
    }

    private static int[] boxBlur(CompactHeightfield chf, int thr, int[] src) {
        int w = chf.width;
        int h = chf.height;
        int[] dst = new int[chf.spanCount];
        thr *= 2;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                CompactCell c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni; ++i) {
                    CompactSpan s = chf.spans[i];
                    int cd = src[i];
                    if (cd <= thr) {
                        dst[i] = cd;
                        continue;
                    }
                    int d = cd;
                    for (int dir = 0; dir < 4; ++dir) {
                        if (RecastCommon.GetCon(s, dir) != 63) {
                            int ax = x + RecastCommon.GetDirOffsetX(dir);
                            int ay = y + RecastCommon.GetDirOffsetY(dir);
                            int ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, dir);
                            d += src[ai];
                            CompactSpan as = chf.spans[ai];
                            int dir2 = dir + 1 & 3;
                            if (RecastCommon.GetCon(as, dir2) != 63) {
                                int ax2 = ax + RecastCommon.GetDirOffsetX(dir2);
                                int ay2 = ay + RecastCommon.GetDirOffsetY(dir2);
                                int ai2 = chf.cells[ax2 + ay2 * w].index + RecastCommon.GetCon(as, dir2);
                                d += src[ai2];
                                continue;
                            }
                            d += cd;
                            continue;
                        }
                        d += cd * 2;
                    }
                    dst[i] = (d + 5) / 9;
                }
            }
        }
        return dst;
    }

    private static boolean floodRegion(int x, int y, int i, int level, int r, CompactHeightfield chf, int[] srcReg, int[] srcDist, List<Integer> stack) {
        int w = chf.width;
        int area = chf.areas[i];
        stack.clear();
        stack.add(x);
        stack.add(y);
        stack.add(i);
        srcReg[i] = r;
        srcDist[i] = 0;
        int lev = level >= 2 ? level - 2 : 0;
        int count = 0;
        while (stack.size() > 0) {
            int ai;
            int ay;
            int ax;
            int dir;
            int ci = stack.remove(stack.size() - 1);
            int cy = stack.remove(stack.size() - 1);
            int cx = stack.remove(stack.size() - 1);
            CompactSpan cs = chf.spans[ci];
            int ar = 0;
            for (dir = 0; dir < 4; ++dir) {
                int nr2;
                int nr;
                if (RecastCommon.GetCon(cs, dir) == 63) continue;
                ax = cx + RecastCommon.GetDirOffsetX(dir);
                ay = cy + RecastCommon.GetDirOffsetY(dir);
                ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(cs, dir);
                if (chf.areas[ai] != area || ((nr = srcReg[ai]) & RecastConstants.RC_BORDER_REG) != 0) continue;
                if (nr != 0 && nr != r) {
                    ar = nr;
                    break;
                }
                CompactSpan as = chf.spans[ai];
                int dir2 = dir + 1 & 3;
                if (RecastCommon.GetCon(as, dir2) == 63) continue;
                int ax2 = ax + RecastCommon.GetDirOffsetX(dir2);
                int ay2 = ay + RecastCommon.GetDirOffsetY(dir2);
                int ai2 = chf.cells[ax2 + ay2 * w].index + RecastCommon.GetCon(as, dir2);
                if (chf.areas[ai2] != area || (nr2 = srcReg[ai2]) == 0 || nr2 == r) continue;
                ar = nr2;
                break;
            }
            if (ar != 0) {
                srcReg[ci] = 0;
                continue;
            }
            ++count;
            for (dir = 0; dir < 4; ++dir) {
                if (RecastCommon.GetCon(cs, dir) == 63) continue;
                ax = cx + RecastCommon.GetDirOffsetX(dir);
                ay = cy + RecastCommon.GetDirOffsetY(dir);
                ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(cs, dir);
                if (chf.areas[ai] != area || chf.dist[ai] < lev || srcReg[ai] != 0) continue;
                srcReg[ai] = r;
                srcDist[ai] = 0;
                stack.add(ax);
                stack.add(ay);
                stack.add(ai);
            }
        }
        return count > 0;
    }

    private static int[] expandRegions(int maxIter, int level, CompactHeightfield chf, int[] srcReg, int[] srcDist, List<Integer> stack, boolean fillStack) {
        int i;
        int w = chf.width;
        int h = chf.height;
        if (fillStack) {
            stack.clear();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    CompactCell c = chf.cells[x + y * w];
                    int ni = c.index + c.count;
                    for (i = c.index; i < ni; ++i) {
                        if (chf.dist[i] < level || srcReg[i] != 0 || chf.areas[i] == 0) continue;
                        stack.add(x);
                        stack.add(y);
                        stack.add(i);
                    }
                }
            }
        } else {
            for (int j = 0; j < stack.size(); j += 3) {
                int i2 = stack.get(j + 2);
                if (srcReg[i2] == 0) continue;
                stack.set(j + 2, -1);
            }
        }
        ArrayList<Integer> dirtyEntries = new ArrayList<Integer>();
        int iter = 0;
        while (stack.size() > 0) {
            int failed = 0;
            dirtyEntries.clear();
            for (int j = 0; j < stack.size(); j += 3) {
                int x = stack.get(j + 0);
                int y = stack.get(j + 1);
                int i3 = stack.get(j + 2);
                if (i3 < 0) {
                    ++failed;
                    continue;
                }
                int r = srcReg[i3];
                int d2 = 65535;
                int area = chf.areas[i3];
                CompactSpan s = chf.spans[i3];
                for (int dir = 0; dir < 4; ++dir) {
                    if (RecastCommon.GetCon(s, dir) == 63) continue;
                    int ax = x + RecastCommon.GetDirOffsetX(dir);
                    int ay = y + RecastCommon.GetDirOffsetY(dir);
                    int ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, dir);
                    if (chf.areas[ai] != area || srcReg[ai] <= 0 || (srcReg[ai] & RecastConstants.RC_BORDER_REG) != 0 || srcDist[ai] + 2 >= d2) continue;
                    r = srcReg[ai];
                    d2 = srcDist[ai] + 2;
                }
                if (r != 0) {
                    stack.set(j + 2, -1);
                    dirtyEntries.add(i3);
                    dirtyEntries.add(r);
                    dirtyEntries.add(d2);
                    continue;
                }
                ++failed;
            }
            for (i = 0; i < dirtyEntries.size(); i += 3) {
                int idx = (Integer)dirtyEntries.get(i);
                srcReg[idx] = (Integer)dirtyEntries.get(i + 1);
                srcDist[idx] = (Integer)dirtyEntries.get(i + 2);
            }
            if (failed * 3 != stack.size() && (level <= 0 || ++iter < maxIter)) continue;
            break;
        }
        return srcReg;
    }

    private static void sortCellsByLevel(int startLevel, CompactHeightfield chf, int[] srcReg, int nbStacks, List<List<Integer>> stacks, int loglevelsPerStack) {
        int w = chf.width;
        int h = chf.height;
        startLevel >>= loglevelsPerStack;
        for (int j = 0; j < nbStacks; ++j) {
            stacks.get(j).clear();
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                CompactCell c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni; ++i) {
                    int level;
                    int sId;
                    if (chf.areas[i] == 0 || srcReg[i] != 0 || (sId = startLevel - (level = chf.dist[i] >> loglevelsPerStack)) >= nbStacks) continue;
                    if (sId < 0) {
                        sId = 0;
                    }
                    stacks.get(sId).add(x);
                    stacks.get(sId).add(y);
                    stacks.get(sId).add(i);
                }
            }
        }
    }

    private static void appendStacks(List<Integer> srcStack, List<Integer> dstStack, int[] srcReg) {
        for (int j = 0; j < srcStack.size(); j += 3) {
            int i = srcStack.get(j + 2);
            if (i < 0 || srcReg[i] != 0) continue;
            dstStack.add(srcStack.get(j));
            dstStack.add(srcStack.get(j + 1));
            dstStack.add(srcStack.get(j + 2));
        }
    }

    private static void removeAdjacentNeighbours(Region reg) {
        int i = 0;
        while (i < reg.connections.size() && reg.connections.size() > 1) {
            int ni = (i + 1) % reg.connections.size();
            if (reg.connections.get(i) == reg.connections.get(ni)) {
                reg.connections.remove(i);
                continue;
            }
            ++i;
        }
    }

    private static void replaceNeighbour(Region reg, int oldId, int newId) {
        int i;
        boolean neiChanged = false;
        for (i = 0; i < reg.connections.size(); ++i) {
            if (reg.connections.get(i) != oldId) continue;
            reg.connections.set(i, newId);
            neiChanged = true;
        }
        for (i = 0; i < reg.floors.size(); ++i) {
            if (reg.floors.get(i) != oldId) continue;
            reg.floors.set(i, newId);
        }
        if (neiChanged) {
            RecastRegion.removeAdjacentNeighbours(reg);
        }
    }

    private static boolean canMergeWithRegion(Region rega, Region regb) {
        int i;
        if (rega.areaType != regb.areaType) {
            return false;
        }
        int n = 0;
        for (i = 0; i < rega.connections.size(); ++i) {
            if (rega.connections.get(i) != regb.id) continue;
            ++n;
        }
        if (n > 1) {
            return false;
        }
        for (i = 0; i < rega.floors.size(); ++i) {
            if (rega.floors.get(i) != regb.id) continue;
            return false;
        }
        return true;
    }

    private static void addUniqueFloorRegion(Region reg, int n) {
        if (!reg.floors.contains(n)) {
            reg.floors.add(n);
        }
    }

    private static boolean mergeRegions(Region rega, Region regb) {
        int i;
        int aid = rega.id;
        int bid = regb.id;
        ArrayList<Integer> acon = new ArrayList<Integer>(rega.connections);
        List<Integer> bcon = regb.connections;
        int insa = -1;
        for (int i2 = 0; i2 < acon.size(); ++i2) {
            if ((Integer)acon.get(i2) != bid) continue;
            insa = i2;
            break;
        }
        if (insa == -1) {
            return false;
        }
        int insb = -1;
        for (i = 0; i < bcon.size(); ++i) {
            if (bcon.get(i) != aid) continue;
            insb = i;
            break;
        }
        if (insb == -1) {
            return false;
        }
        rega.connections.clear();
        int ni = acon.size();
        for (i = 0; i < ni - 1; ++i) {
            rega.connections.add((Integer)acon.get((insa + 1 + i) % ni));
        }
        ni = bcon.size();
        for (i = 0; i < ni - 1; ++i) {
            rega.connections.add(bcon.get((insb + 1 + i) % ni));
        }
        RecastRegion.removeAdjacentNeighbours(rega);
        for (int j = 0; j < regb.floors.size(); ++j) {
            RecastRegion.addUniqueFloorRegion(rega, regb.floors.get(j));
        }
        rega.spanCount += regb.spanCount;
        regb.spanCount = 0;
        regb.connections.clear();
        return true;
    }

    private static boolean isRegionConnectedToBorder(Region reg) {
        return reg.connections.contains(0);
    }

    private static boolean isSolidEdge(CompactHeightfield chf, int[] srcReg, int x, int y, int i, int dir) {
        CompactSpan s = chf.spans[i];
        int r = 0;
        if (RecastCommon.GetCon(s, dir) != 63) {
            int ax = x + RecastCommon.GetDirOffsetX(dir);
            int ay = y + RecastCommon.GetDirOffsetY(dir);
            int ai = chf.cells[ax + ay * chf.width].index + RecastCommon.GetCon(s, dir);
            r = srcReg[ai];
        }
        return r != srcReg[i];
    }

    private static void walkContour(int x, int y, int i, int dir, CompactHeightfield chf, int[] srcReg, List<Integer> cont) {
        int startDir = dir;
        int starti = i;
        CompactSpan ss = chf.spans[i];
        int curReg = 0;
        if (RecastCommon.GetCon(ss, dir) != 63) {
            int ax = x + RecastCommon.GetDirOffsetX(dir);
            int ay = y + RecastCommon.GetDirOffsetY(dir);
            int ai = chf.cells[ax + ay * chf.width].index + RecastCommon.GetCon(ss, dir);
            curReg = srcReg[ai];
        }
        cont.add(curReg);
        int iter = 0;
        while (++iter < 40000) {
            CompactSpan s = chf.spans[i];
            if (RecastRegion.isSolidEdge(chf, srcReg, x, y, i, dir)) {
                int r = 0;
                if (RecastCommon.GetCon(s, dir) != 63) {
                    int ax = x + RecastCommon.GetDirOffsetX(dir);
                    int ay = y + RecastCommon.GetDirOffsetY(dir);
                    int ai = chf.cells[ax + ay * chf.width].index + RecastCommon.GetCon(s, dir);
                    r = srcReg[ai];
                }
                if (r != curReg) {
                    curReg = r;
                    cont.add(curReg);
                }
                dir = dir + 1 & 3;
            } else {
                int ni = -1;
                int nx = x + RecastCommon.GetDirOffsetX(dir);
                int ny = y + RecastCommon.GetDirOffsetY(dir);
                if (RecastCommon.GetCon(s, dir) != 63) {
                    CompactCell nc = chf.cells[nx + ny * chf.width];
                    ni = nc.index + RecastCommon.GetCon(s, dir);
                }
                if (ni == -1) {
                    return;
                }
                x = nx;
                y = ny;
                i = ni;
                dir = dir + 3 & 3;
            }
            if (starti != i || startDir != dir) continue;
            break;
        }
        if (cont.size() > 1) {
            int j = 0;
            while (j < cont.size()) {
                int nj = (j + 1) % cont.size();
                if (cont.get(j) == cont.get(nj)) {
                    cont.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    private static int mergeAndFilterRegions(Telemetry ctx, int minRegionArea, int mergeRegionSize, int maxRegionId, CompactHeightfield chf, int[] srcReg, List<Integer> overlaps) {
        int i;
        int i2;
        int w = chf.width;
        int h = chf.height;
        int nreg = maxRegionId + 1;
        Region[] regions = new Region[nreg];
        for (int i3 = 0; i3 < nreg; ++i3) {
            regions[i3] = new Region(i3);
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                CompactCell c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (int i4 = c.index; i4 < ni; ++i4) {
                    int r = srcReg[i4];
                    if (r == 0 || r >= nreg) continue;
                    Region reg = regions[r];
                    ++reg.spanCount;
                    for (int j = c.index; j < ni; ++j) {
                        int floorId;
                        if (i4 == j || (floorId = srcReg[j]) == 0 || floorId >= nreg) continue;
                        if (floorId == r) {
                            reg.overlap = true;
                        }
                        RecastRegion.addUniqueFloorRegion(reg, floorId);
                    }
                    if (reg.connections.size() > 0) continue;
                    reg.areaType = chf.areas[i4];
                    int ndir = -1;
                    for (int dir = 0; dir < 4; ++dir) {
                        if (!RecastRegion.isSolidEdge(chf, srcReg, x, y, i4, dir)) continue;
                        ndir = dir;
                        break;
                    }
                    if (ndir == -1) continue;
                    RecastRegion.walkContour(x, y, i4, ndir, chf, srcReg, reg.connections);
                }
            }
        }
        ArrayList<Integer> stack = new ArrayList<Integer>(32);
        ArrayList<Integer> trace = new ArrayList<Integer>(32);
        for (int i5 = 0; i5 < nreg; ++i5) {
            Region reg = regions[i5];
            if (reg.id == 0 || (reg.id & RecastConstants.RC_BORDER_REG) != 0 || reg.spanCount == 0 || reg.visited) continue;
            boolean connectsToBorder = false;
            int spanCount = 0;
            stack.clear();
            trace.clear();
            reg.visited = true;
            stack.add(i5);
            while (stack.size() > 0) {
                int ri = (Integer)stack.remove(stack.size() - 1);
                Region creg = regions[ri];
                spanCount += creg.spanCount;
                trace.add(ri);
                for (int j = 0; j < creg.connections.size(); ++j) {
                    if ((creg.connections.get(j) & RecastConstants.RC_BORDER_REG) != 0) {
                        connectsToBorder = true;
                        continue;
                    }
                    Region neireg = regions[creg.connections.get(j)];
                    if (neireg.visited || neireg.id == 0 || (neireg.id & RecastConstants.RC_BORDER_REG) != 0) continue;
                    stack.add(neireg.id);
                    neireg.visited = true;
                }
            }
            if (spanCount >= minRegionArea || connectsToBorder) continue;
            for (int j = 0; j < trace.size(); ++j) {
                regions[((Integer)trace.get((int)j)).intValue()].spanCount = 0;
                regions[((Integer)trace.get((int)j)).intValue()].id = 0;
            }
        }
        int mergeCount = 0;
        do {
            mergeCount = 0;
            for (i2 = 0; i2 < nreg; ++i2) {
                Region reg = regions[i2];
                if (reg.id == 0 || (reg.id & RecastConstants.RC_BORDER_REG) != 0 || reg.overlap || reg.spanCount == 0 || reg.spanCount > mergeRegionSize && RecastRegion.isRegionConnectedToBorder(reg)) continue;
                int smallest = 0xFFFFFFF;
                int mergeId = reg.id;
                for (int j = 0; j < reg.connections.size(); ++j) {
                    if ((reg.connections.get(j) & RecastConstants.RC_BORDER_REG) != 0) continue;
                    Region mreg = regions[reg.connections.get(j)];
                    if (mreg.id == 0 || (mreg.id & RecastConstants.RC_BORDER_REG) != 0 || mreg.overlap || mreg.spanCount >= smallest || !RecastRegion.canMergeWithRegion(reg, mreg) || !RecastRegion.canMergeWithRegion(mreg, reg)) continue;
                    smallest = mreg.spanCount;
                    mergeId = mreg.id;
                }
                if (mergeId == reg.id) continue;
                int oldId = reg.id;
                Region target = regions[mergeId];
                if (!RecastRegion.mergeRegions(target, reg)) continue;
                for (int j = 0; j < nreg; ++j) {
                    if (regions[j].id == 0 || (regions[j].id & RecastConstants.RC_BORDER_REG) != 0) continue;
                    if (regions[j].id == oldId) {
                        regions[j].id = mergeId;
                    }
                    RecastRegion.replaceNeighbour(regions[j], oldId, mergeId);
                }
                ++mergeCount;
            }
        } while (mergeCount > 0);
        for (i2 = 0; i2 < nreg; ++i2) {
            regions[i2].remap = false;
            if (regions[i2].id == 0 || (regions[i2].id & RecastConstants.RC_BORDER_REG) != 0) continue;
            regions[i2].remap = true;
        }
        int regIdGen = 0;
        for (i = 0; i < nreg; ++i) {
            if (!regions[i].remap) continue;
            int oldId = regions[i].id;
            int newId = ++regIdGen;
            for (int j = i; j < nreg; ++j) {
                if (regions[j].id != oldId) continue;
                regions[j].id = newId;
                regions[j].remap = false;
            }
        }
        maxRegionId = regIdGen;
        for (i = 0; i < chf.spanCount; ++i) {
            if ((srcReg[i] & RecastConstants.RC_BORDER_REG) != 0) continue;
            srcReg[i] = regions[srcReg[i]].id;
        }
        for (i = 0; i < nreg; ++i) {
            if (!regions[i].overlap) continue;
            overlaps.add(regions[i].id);
        }
        return maxRegionId;
    }

    private static void addUniqueConnection(Region reg, int n) {
        if (!reg.connections.contains(n)) {
            reg.connections.add(n);
        }
    }

    private static int mergeAndFilterLayerRegions(Telemetry ctx, int minRegionArea, int maxRegionId, CompactHeightfield chf, int[] srcReg, List<Integer> overlaps) {
        int i;
        int j;
        int i2;
        int w = chf.width;
        int h = chf.height;
        int nreg = maxRegionId + 1;
        Region[] regions = new Region[nreg];
        for (int i3 = 0; i3 < nreg; ++i3) {
            regions[i3] = new Region(i3);
        }
        ArrayList<Integer> lregs = new ArrayList<Integer>(32);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int i4;
                CompactCell c = chf.cells[x + y * w];
                lregs.clear();
                int ni = c.index + c.count;
                for (i4 = c.index; i4 < ni; ++i4) {
                    CompactSpan s = chf.spans[i4];
                    int ri = srcReg[i4];
                    if (ri == 0 || ri >= nreg) continue;
                    Region reg = regions[ri];
                    ++reg.spanCount;
                    reg.areaType = chf.areas[i4];
                    reg.ymin = Math.min(reg.ymin, s.y);
                    reg.ymax = Math.max(reg.ymax, s.y);
                    lregs.add(ri);
                    for (int dir = 0; dir < 4; ++dir) {
                        if (RecastCommon.GetCon(s, dir) == 63) continue;
                        int ax = x + RecastCommon.GetDirOffsetX(dir);
                        int ay = y + RecastCommon.GetDirOffsetY(dir);
                        int ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, dir);
                        int rai = srcReg[ai];
                        if (rai > 0 && rai < nreg && rai != ri) {
                            RecastRegion.addUniqueConnection(reg, rai);
                        }
                        if ((rai & RecastConstants.RC_BORDER_REG) == 0) continue;
                        reg.connectsToBorder = true;
                    }
                }
                for (i4 = 0; i4 < lregs.size() - 1; ++i4) {
                    for (int j2 = i4 + 1; j2 < lregs.size(); ++j2) {
                        if (lregs.get(i4) == lregs.get(j2)) continue;
                        Region ri = regions[(Integer)lregs.get(i4)];
                        Region rj = regions[(Integer)lregs.get(j2)];
                        RecastRegion.addUniqueFloorRegion(ri, (Integer)lregs.get(j2));
                        RecastRegion.addUniqueFloorRegion(rj, (Integer)lregs.get(i4));
                    }
                }
            }
        }
        int layerId = 1;
        for (int i5 = 0; i5 < nreg; ++i5) {
            regions[i5].id = 0;
        }
        ArrayList<Integer> stack = new ArrayList<Integer>(32);
        for (i2 = 1; i2 < nreg; ++i2) {
            Region root = regions[i2];
            if (root.id != 0) continue;
            root.id = layerId;
            stack.clear();
            stack.add(i2);
            while (stack.size() > 0) {
                Region reg = regions[(Integer)stack.remove(0)];
                int ncons = reg.connections.size();
                for (j = 0; j < ncons; ++j) {
                    int k;
                    int nei = reg.connections.get(j);
                    Region regn = regions[nei];
                    if (regn.id != 0 || reg.areaType != regn.areaType) continue;
                    boolean overlap = false;
                    for (k = 0; k < root.floors.size(); ++k) {
                        if (root.floors.get(k) != nei) continue;
                        overlap = true;
                        break;
                    }
                    if (overlap) continue;
                    stack.add(nei);
                    regn.id = layerId;
                    for (k = 0; k < regn.floors.size(); ++k) {
                        RecastRegion.addUniqueFloorRegion(root, regn.floors.get(k));
                    }
                    root.ymin = Math.min(root.ymin, regn.ymin);
                    root.ymax = Math.max(root.ymax, regn.ymax);
                    root.spanCount += regn.spanCount;
                    regn.spanCount = 0;
                    root.connectsToBorder = root.connectsToBorder || regn.connectsToBorder;
                }
            }
            ++layerId;
        }
        for (i2 = 0; i2 < nreg; ++i2) {
            if (regions[i2].spanCount <= 0 || regions[i2].spanCount >= minRegionArea || regions[i2].connectsToBorder) continue;
            int reg = regions[i2].id;
            for (int j3 = 0; j3 < nreg; ++j3) {
                if (regions[j3].id != reg) continue;
                regions[j3].id = 0;
            }
        }
        for (i2 = 0; i2 < nreg; ++i2) {
            regions[i2].remap = false;
            if (regions[i2].id == 0 || (regions[i2].id & RecastConstants.RC_BORDER_REG) != 0) continue;
            regions[i2].remap = true;
        }
        int regIdGen = 0;
        for (i = 0; i < nreg; ++i) {
            if (!regions[i].remap) continue;
            int oldId = regions[i].id;
            int newId = ++regIdGen;
            for (j = i; j < nreg; ++j) {
                if (regions[j].id != oldId) continue;
                regions[j].id = newId;
                regions[j].remap = false;
            }
        }
        maxRegionId = regIdGen;
        for (i = 0; i < chf.spanCount; ++i) {
            if ((srcReg[i] & RecastConstants.RC_BORDER_REG) != 0) continue;
            srcReg[i] = regions[srcReg[i]].id;
        }
        return maxRegionId;
    }

    public static void buildDistanceField(Telemetry ctx, CompactHeightfield chf) {
        int maxDist;
        ctx.startTimer("DISTANCEFIELD");
        int[] src = new int[chf.spanCount];
        ctx.startTimer("DISTANCEFIELD_DIST");
        chf.maxDistance = maxDist = RecastRegion.calculateDistanceField(chf, src);
        ctx.stopTimer("DISTANCEFIELD_DIST");
        ctx.startTimer("DISTANCEFIELD_BLUR");
        src = RecastRegion.boxBlur(chf, 1, src);
        chf.dist = src;
        ctx.stopTimer("DISTANCEFIELD_BLUR");
        ctx.stopTimer("DISTANCEFIELD");
    }

    private static void paintRectRegion(int minx, int maxx, int miny, int maxy, int regId, CompactHeightfield chf, int[] srcReg) {
        int w = chf.width;
        for (int y = miny; y < maxy; ++y) {
            for (int x = minx; x < maxx; ++x) {
                CompactCell c = chf.cells[x + y * w];
                int ni = c.index + c.count;
                for (int i = c.index; i < ni; ++i) {
                    if (chf.areas[i] == 0) continue;
                    srcReg[i] = regId;
                }
            }
        }
    }

    public static void buildRegionsMonotone(Telemetry ctx, CompactHeightfield chf, int minRegionArea, int mergeRegionArea) {
        ctx.startTimer("REGIONS");
        int w = chf.width;
        int h = chf.height;
        int borderSize = chf.borderSize;
        int id = 1;
        int[] srcReg = new int[chf.spanCount];
        int nsweeps = Math.max(chf.width, chf.height);
        SweepSpan[] sweeps = new SweepSpan[nsweeps];
        for (int i = 0; i < sweeps.length; ++i) {
            sweeps[i] = new SweepSpan();
        }
        if (borderSize > 0) {
            int bw = Math.min(w, borderSize);
            int bh = Math.min(h, borderSize);
            RecastRegion.paintRectRegion(0, bw, 0, h, id | RecastConstants.RC_BORDER_REG, chf, srcReg);
            RecastRegion.paintRectRegion(w - bw, w, 0, h, ++id | RecastConstants.RC_BORDER_REG, chf, srcReg);
            RecastRegion.paintRectRegion(0, w, 0, bh, ++id | RecastConstants.RC_BORDER_REG, chf, srcReg);
            RecastRegion.paintRectRegion(0, w, h - bh, h, ++id | RecastConstants.RC_BORDER_REG, chf, srcReg);
            ++id;
        }
        int[] prev = new int[1024];
        for (int y = borderSize; y < h - borderSize; ++y) {
            int i;
            int ni;
            CompactCell c;
            int x;
            if (prev.length < id * 2) {
                prev = new int[id * 2];
            } else {
                Arrays.fill(prev, 0, id, 0);
            }
            int rid = 1;
            for (x = borderSize; x < w - borderSize; ++x) {
                c = chf.cells[x + y * w];
                ni = c.index + c.count;
                for (i = c.index; i < ni; ++i) {
                    int ai;
                    int ay;
                    int ax;
                    CompactSpan s = chf.spans[i];
                    if (chf.areas[i] == 0) continue;
                    int previd = 0;
                    if (RecastCommon.GetCon(s, 0) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(0);
                        ay = y + RecastCommon.GetDirOffsetY(0);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 0);
                        if ((srcReg[ai] & RecastConstants.RC_BORDER_REG) == 0 && chf.areas[i] == chf.areas[ai]) {
                            previd = srcReg[ai];
                        }
                    }
                    if (previd == 0) {
                        sweeps[previd].rid = previd = rid++;
                        sweeps[previd].ns = 0;
                        sweeps[previd].nei = 0;
                    }
                    if (RecastCommon.GetCon(s, 3) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(3);
                        ay = y + RecastCommon.GetDirOffsetY(3);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 3);
                        if (srcReg[ai] != 0 && (srcReg[ai] & RecastConstants.RC_BORDER_REG) == 0 && chf.areas[i] == chf.areas[ai]) {
                            int nr = srcReg[ai];
                            if (sweeps[previd].nei == 0 || sweeps[previd].nei == nr) {
                                sweeps[previd].nei = nr;
                                ++sweeps[previd].ns;
                                if (prev.length <= nr) {
                                    prev = Arrays.copyOf(prev, prev.length * 2);
                                }
                                int n = nr;
                                prev[n] = prev[n] + 1;
                            } else {
                                sweeps[previd].nei = 65535;
                            }
                        }
                    }
                    srcReg[i] = previd;
                }
            }
            for (int i2 = 1; i2 < rid; ++i2) {
                sweeps[i2].id = sweeps[i2].nei != 65535 && sweeps[i2].nei != 0 && prev[sweeps[i2].nei] == sweeps[i2].ns ? sweeps[i2].nei : id++;
            }
            for (x = borderSize; x < w - borderSize; ++x) {
                c = chf.cells[x + y * w];
                ni = c.index + c.count;
                for (i = c.index; i < ni; ++i) {
                    if (srcReg[i] <= 0 || srcReg[i] >= rid) continue;
                    srcReg[i] = sweeps[srcReg[i]].id;
                }
            }
        }
        ctx.startTimer("REGIONS_FILTER");
        ArrayList<Integer> overlaps = new ArrayList<Integer>();
        chf.maxRegions = RecastRegion.mergeAndFilterRegions(ctx, minRegionArea, mergeRegionArea, id, chf, srcReg, overlaps);
        ctx.stopTimer("REGIONS_FILTER");
        for (int i = 0; i < chf.spanCount; ++i) {
            chf.spans[i].reg = srcReg[i];
        }
        ctx.stopTimer("REGIONS");
    }

    public static void buildRegions(Telemetry ctx, CompactHeightfield chf, int minRegionArea, int mergeRegionArea) {
        ctx.startTimer("REGIONS");
        int w = chf.width;
        int h = chf.height;
        int borderSize = chf.borderSize;
        ctx.startTimer("REGIONS_WATERSHED");
        int LOG_NB_STACKS = 3;
        int NB_STACKS = 1 << LOG_NB_STACKS;
        ArrayList<List<Integer>> lvlStacks = new ArrayList<List<Integer>>();
        for (int i = 0; i < NB_STACKS; ++i) {
            lvlStacks.add(new ArrayList(1024));
        }
        ArrayList<Integer> stack = new ArrayList<Integer>(1024);
        int[] srcReg = new int[chf.spanCount];
        int[] srcDist = new int[chf.spanCount];
        int regionId = 1;
        int level = chf.maxDistance + 1 & 0xFFFFFFFE;
        int expandIters = 8;
        if (borderSize > 0) {
            int bw = Math.min(w, borderSize);
            int bh = Math.min(h, borderSize);
            RecastRegion.paintRectRegion(0, bw, 0, h, regionId | RecastConstants.RC_BORDER_REG, chf, srcReg);
            RecastRegion.paintRectRegion(w - bw, w, 0, h, ++regionId | RecastConstants.RC_BORDER_REG, chf, srcReg);
            RecastRegion.paintRectRegion(0, w, 0, bh, ++regionId | RecastConstants.RC_BORDER_REG, chf, srcReg);
            RecastRegion.paintRectRegion(0, w, h - bh, h, ++regionId | RecastConstants.RC_BORDER_REG, chf, srcReg);
            ++regionId;
        }
        chf.borderSize = borderSize;
        int sId = -1;
        while (level > 0) {
            level = level >= 2 ? level - 2 : 0;
            if ((sId = sId + 1 & NB_STACKS - 1) == 0) {
                RecastRegion.sortCellsByLevel(level, chf, srcReg, NB_STACKS, lvlStacks, 1);
            } else {
                RecastRegion.appendStacks((List)lvlStacks.get(sId - 1), (List)lvlStacks.get(sId), srcReg);
            }
            ctx.startTimer("REGIONS_EXPAND");
            RecastRegion.expandRegions(expandIters, level, chf, srcReg, srcDist, (List)lvlStacks.get(sId), false);
            ctx.stopTimer("REGIONS_EXPAND");
            ctx.startTimer("REGIONS_FLOOD");
            for (int j = 0; j < ((List)lvlStacks.get(sId)).size(); j += 3) {
                int x = (Integer)((List)lvlStacks.get(sId)).get(j);
                int y = (Integer)((List)lvlStacks.get(sId)).get(j + 1);
                int i = (Integer)((List)lvlStacks.get(sId)).get(j + 2);
                if (i < 0 || srcReg[i] != 0 || !RecastRegion.floodRegion(x, y, i, level, regionId, chf, srcReg, srcDist, stack)) continue;
                ++regionId;
            }
            ctx.stopTimer("REGIONS_FLOOD");
        }
        RecastRegion.expandRegions(expandIters * 8, 0, chf, srcReg, srcDist, stack, true);
        ctx.stopTimer("REGIONS_WATERSHED");
        ctx.startTimer("REGIONS_FILTER");
        ArrayList<Integer> overlaps = new ArrayList<Integer>();
        chf.maxRegions = RecastRegion.mergeAndFilterRegions(ctx, minRegionArea, mergeRegionArea, regionId, chf, srcReg, overlaps);
        if (overlaps.size() > 0) {
            ctx.warn("rcBuildRegions: " + overlaps.size() + " overlapping regions.");
        }
        ctx.stopTimer("REGIONS_FILTER");
        for (int i = 0; i < chf.spanCount; ++i) {
            chf.spans[i].reg = srcReg[i];
        }
        ctx.stopTimer("REGIONS");
    }

    public static void buildLayerRegions(Telemetry ctx, CompactHeightfield chf, int minRegionArea) {
        ctx.startTimer("REGIONS");
        int w = chf.width;
        int h = chf.height;
        int borderSize = chf.borderSize;
        int id = 1;
        int[] srcReg = new int[chf.spanCount];
        int nsweeps = Math.max(chf.width, chf.height);
        SweepSpan[] sweeps = new SweepSpan[nsweeps];
        for (int i = 0; i < sweeps.length; ++i) {
            sweeps[i] = new SweepSpan();
        }
        if (borderSize > 0) {
            int bw = Math.min(w, borderSize);
            int bh = Math.min(h, borderSize);
            RecastRegion.paintRectRegion(0, bw, 0, h, id | RecastConstants.RC_BORDER_REG, chf, srcReg);
            RecastRegion.paintRectRegion(w - bw, w, 0, h, ++id | RecastConstants.RC_BORDER_REG, chf, srcReg);
            RecastRegion.paintRectRegion(0, w, 0, bh, ++id | RecastConstants.RC_BORDER_REG, chf, srcReg);
            RecastRegion.paintRectRegion(0, w, h - bh, h, ++id | RecastConstants.RC_BORDER_REG, chf, srcReg);
            ++id;
        }
        int[] prev = new int[1024];
        for (int y = borderSize; y < h - borderSize; ++y) {
            int i;
            int ni;
            CompactCell c;
            int x;
            if (prev.length <= id * 2) {
                prev = new int[id * 2];
            } else {
                Arrays.fill(prev, 0, id, 0);
            }
            int rid = 1;
            for (x = borderSize; x < w - borderSize; ++x) {
                c = chf.cells[x + y * w];
                ni = c.index + c.count;
                for (i = c.index; i < ni; ++i) {
                    int ai;
                    int ay;
                    int ax;
                    CompactSpan s = chf.spans[i];
                    if (chf.areas[i] == 0) continue;
                    int previd = 0;
                    if (RecastCommon.GetCon(s, 0) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(0);
                        ay = y + RecastCommon.GetDirOffsetY(0);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 0);
                        if ((srcReg[ai] & RecastConstants.RC_BORDER_REG) == 0 && chf.areas[i] == chf.areas[ai]) {
                            previd = srcReg[ai];
                        }
                    }
                    if (previd == 0) {
                        sweeps[previd].rid = previd = rid++;
                        sweeps[previd].ns = 0;
                        sweeps[previd].nei = 0;
                    }
                    if (RecastCommon.GetCon(s, 3) != 63) {
                        ax = x + RecastCommon.GetDirOffsetX(3);
                        ay = y + RecastCommon.GetDirOffsetY(3);
                        ai = chf.cells[ax + ay * w].index + RecastCommon.GetCon(s, 3);
                        if (srcReg[ai] != 0 && (srcReg[ai] & RecastConstants.RC_BORDER_REG) == 0 && chf.areas[i] == chf.areas[ai]) {
                            int nr = srcReg[ai];
                            if (sweeps[previd].nei == 0 || sweeps[previd].nei == nr) {
                                sweeps[previd].nei = nr;
                                ++sweeps[previd].ns;
                                if (prev.length <= nr) {
                                    prev = Arrays.copyOf(prev, prev.length * 2);
                                }
                                int n = nr;
                                prev[n] = prev[n] + 1;
                            } else {
                                sweeps[previd].nei = 65535;
                            }
                        }
                    }
                    srcReg[i] = previd;
                }
            }
            for (int i2 = 1; i2 < rid; ++i2) {
                sweeps[i2].id = sweeps[i2].nei != 65535 && sweeps[i2].nei != 0 && prev[sweeps[i2].nei] == sweeps[i2].ns ? sweeps[i2].nei : id++;
            }
            for (x = borderSize; x < w - borderSize; ++x) {
                c = chf.cells[x + y * w];
                ni = c.index + c.count;
                for (i = c.index; i < ni; ++i) {
                    if (srcReg[i] <= 0 || srcReg[i] >= rid) continue;
                    srcReg[i] = sweeps[srcReg[i]].id;
                }
            }
        }
        ctx.startTimer("REGIONS_FILTER");
        ArrayList<Integer> overlaps = new ArrayList<Integer>();
        chf.maxRegions = RecastRegion.mergeAndFilterLayerRegions(ctx, minRegionArea, id, chf, srcReg, overlaps);
        ctx.stopTimer("REGIONS_FILTER");
        for (int i = 0; i < chf.spanCount; ++i) {
            chf.spans[i].reg = srcReg[i];
        }
        ctx.stopTimer("REGIONS");
    }

    static class Region {
        int spanCount;
        int id;
        int areaType;
        boolean remap;
        boolean visited;
        boolean overlap;
        boolean connectsToBorder;
        int ymin;
        int ymax;
        List<Integer> connections;
        List<Integer> floors;

        Region(int i) {
            this.id = i;
            this.ymin = 65535;
            this.connections = new ArrayList<Integer>();
            this.floors = new ArrayList<Integer>();
        }
    }

    static class SweepSpan {
        int rid;
        int id;
        int ns;
        int nei;

        SweepSpan() {
        }
    }
}

