/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.List;
import org.recast4j.recast.Heightfield;
import org.recast4j.recast.Recast;
import org.recast4j.recast.RecastBuilderConfig;
import org.recast4j.recast.RecastConfig;
import org.recast4j.recast.RecastRasterization;
import org.recast4j.recast.Telemetry;
import org.recast4j.recast.geom.ChunkyTriMesh;
import org.recast4j.recast.geom.InputGeomProvider;
import org.recast4j.recast.geom.TriMesh;

public class RecastVoxelization {
    public static Heightfield buildSolidHeightfield(InputGeomProvider geomProvider, RecastBuilderConfig builderCfg, Telemetry ctx) {
        RecastConfig cfg = builderCfg.cfg;
        Heightfield solid = new Heightfield(builderCfg.width, builderCfg.height, builderCfg.bmin, builderCfg.bmax, cfg.cs, cfg.ch, cfg.borderSize);
        for (TriMesh geom : geomProvider.meshes()) {
            float[] verts = geom.getVerts();
            if (cfg.useTiles) {
                float[] tbmin = new float[2];
                float[] tbmax = new float[2];
                tbmin[0] = builderCfg.bmin[0];
                tbmin[1] = builderCfg.bmin[2];
                tbmax[0] = builderCfg.bmax[0];
                tbmax[1] = builderCfg.bmax[2];
                List<ChunkyTriMesh.ChunkyTriMeshNode> nodes = geom.getChunksOverlappingRect(tbmin, tbmax);
                for (ChunkyTriMesh.ChunkyTriMeshNode node : nodes) {
                    int[] tris = node.tris;
                    int ntris = tris.length / 3;
                    int[] m_triareas = Recast.markWalkableTriangles(ctx, cfg.walkableSlopeAngle, verts, tris, ntris, cfg.walkableAreaMod);
                    RecastRasterization.rasterizeTriangles(solid, verts, tris, m_triareas, ntris, cfg.walkableClimb, ctx);
                }
                continue;
            }
            int[] tris = geom.getTris();
            int ntris = tris.length / 3;
            int[] m_triareas = Recast.markWalkableTriangles(ctx, cfg.walkableSlopeAngle, verts, tris, ntris, cfg.walkableAreaMod);
            RecastRasterization.rasterizeTriangles(solid, verts, tris, m_triareas, ntris, cfg.walkableClimb, ctx);
        }
        return solid;
    }
}

