/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class Telemetry {
    private final ThreadLocal<Map<String, AtomicLong>> timerStart = ThreadLocal.withInitial(HashMap::new);
    private final Map<String, AtomicLong> timerAccum = new ConcurrentHashMap<String, AtomicLong>();

    public void startTimer(String name) {
        this.timerStart.get().put(name, new AtomicLong(System.nanoTime()));
    }

    public void stopTimer(String name) {
        this.timerAccum.computeIfAbsent(name, __ -> new AtomicLong()).addAndGet(System.nanoTime() - this.timerStart.get().get(name).get());
    }

    public void warn(String string) {
        System.err.println(string);
    }

    public void print() {
        this.timerAccum.forEach((n, v) -> System.out.println(n + ": " + v.get() / 1000000L));
    }
}

