/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ChunkyTriMesh {
    List<ChunkyTriMeshNode> nodes;
    int ntris;
    int maxTrisPerChunk;

    private void calcExtends(BoundsItem[] items, int imin, int imax, float[] bmin, float[] bmax) {
        bmin[0] = items[imin].bmin[0];
        bmin[1] = items[imin].bmin[1];
        bmax[0] = items[imin].bmax[0];
        bmax[1] = items[imin].bmax[1];
        for (int i = imin + 1; i < imax; ++i) {
            BoundsItem it = items[i];
            if (it.bmin[0] < bmin[0]) {
                bmin[0] = it.bmin[0];
            }
            if (it.bmin[1] < bmin[1]) {
                bmin[1] = it.bmin[1];
            }
            if (it.bmax[0] > bmax[0]) {
                bmax[0] = it.bmax[0];
            }
            if (!(it.bmax[1] > bmax[1])) continue;
            bmax[1] = it.bmax[1];
        }
    }

    private int longestAxis(float x, float y) {
        return y > x ? 1 : 0;
    }

    private void subdivide(BoundsItem[] items, int imin, int imax, int trisPerChunk, List<ChunkyTriMeshNode> nodes, int[] inTris) {
        int inum = imax - imin;
        ChunkyTriMeshNode node = new ChunkyTriMeshNode();
        nodes.add(node);
        if (inum <= trisPerChunk) {
            this.calcExtends(items, imin, imax, node.bmin, node.bmax);
            node.i = nodes.size();
            node.tris = new int[inum * 3];
            int dst = 0;
            for (int i = imin; i < imax; ++i) {
                int src = items[i].i * 3;
                node.tris[dst++] = inTris[src];
                node.tris[dst++] = inTris[src + 1];
                node.tris[dst++] = inTris[src + 2];
            }
        } else {
            this.calcExtends(items, imin, imax, node.bmin, node.bmax);
            int axis = this.longestAxis(node.bmax[0] - node.bmin[0], node.bmax[1] - node.bmin[1]);
            if (axis == 0) {
                Arrays.sort(items, imin, imax, new CompareItemX());
            } else if (axis == 1) {
                Arrays.sort(items, imin, imax, new CompareItemY());
            }
            int isplit = imin + inum / 2;
            this.subdivide(items, imin, isplit, trisPerChunk, nodes, inTris);
            this.subdivide(items, isplit, imax, trisPerChunk, nodes, inTris);
            node.i = -nodes.size();
        }
    }

    public ChunkyTriMesh(float[] verts, int[] tris, int ntris, int trisPerChunk) {
        int nchunks = (ntris + trisPerChunk - 1) / trisPerChunk;
        this.nodes = new ArrayList<ChunkyTriMeshNode>(nchunks);
        this.ntris = ntris;
        BoundsItem[] items = new BoundsItem[ntris];
        for (int i = 0; i < ntris; ++i) {
            int t = i * 3;
            BoundsItem it = items[i] = new BoundsItem();
            it.i = i;
            float f = verts[tris[t] * 3 + 0];
            ((BoundsItem)it).bmax[0] = f;
            ((BoundsItem)it).bmin[0] = f;
            float f2 = verts[tris[t] * 3 + 2];
            ((BoundsItem)it).bmax[1] = f2;
            ((BoundsItem)it).bmin[1] = f2;
            for (int j = 1; j < 3; ++j) {
                int v = tris[t + j] * 3;
                if (verts[v] < it.bmin[0]) {
                    ((BoundsItem)it).bmin[0] = verts[v];
                }
                if (verts[v + 2] < it.bmin[1]) {
                    ((BoundsItem)it).bmin[1] = verts[v + 2];
                }
                if (verts[v] > it.bmax[0]) {
                    ((BoundsItem)it).bmax[0] = verts[v];
                }
                if (!(verts[v + 2] > it.bmax[1])) continue;
                ((BoundsItem)it).bmax[1] = verts[v + 2];
            }
        }
        this.subdivide(items, 0, ntris, trisPerChunk, this.nodes, tris);
        this.maxTrisPerChunk = 0;
        for (ChunkyTriMeshNode node : this.nodes) {
            boolean isLeaf = node.i >= 0;
            if (!isLeaf || node.tris.length / 3 <= this.maxTrisPerChunk) continue;
            this.maxTrisPerChunk = node.tris.length / 3;
        }
    }

    private boolean checkOverlapRect(float[] amin, float[] amax, float[] bmin, float[] bmax) {
        boolean overlap = true;
        overlap = amin[0] > bmax[0] || amax[0] < bmin[0] ? false : overlap;
        overlap = amin[1] > bmax[1] || amax[1] < bmin[1] ? false : overlap;
        return overlap;
    }

    public List<ChunkyTriMeshNode> getChunksOverlappingRect(float[] bmin, float[] bmax) {
        ArrayList<ChunkyTriMeshNode> ids = new ArrayList<ChunkyTriMeshNode>();
        int i = 0;
        while (i < this.nodes.size()) {
            boolean isLeafNode;
            ChunkyTriMeshNode node = this.nodes.get(i);
            boolean overlap = this.checkOverlapRect(bmin, bmax, node.bmin, node.bmax);
            boolean bl = isLeafNode = node.i >= 0;
            if (isLeafNode && overlap) {
                ids.add(node);
            }
            if (overlap || isLeafNode) {
                ++i;
                continue;
            }
            i = -node.i;
        }
        return ids;
    }

    private static class BoundsItem {
        private final float[] bmin = new float[2];
        private final float[] bmax = new float[2];
        private int i;

        private BoundsItem() {
        }
    }

    public static class ChunkyTriMeshNode {
        private final float[] bmin = new float[2];
        private final float[] bmax = new float[2];
        private int i;
        public int[] tris;
    }

    private class CompareItemX
    implements Comparator<BoundsItem> {
        private CompareItemX() {
        }

        @Override
        public int compare(BoundsItem a, BoundsItem b) {
            return Float.compare(a.bmin[0], b.bmin[0]);
        }
    }

    private class CompareItemY
    implements Comparator<BoundsItem> {
        private CompareItemY() {
        }

        @Override
        public int compare(BoundsItem a, BoundsItem b) {
            return Float.compare(a.bmin[1], b.bmin[1]);
        }
    }
}

